/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.schedule.runnables;

import io.github.skydynamic.increment.storage.lib.database.StorageInfo;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.config.PbsConfig;
import io.github.skydynamic.quickbakcupmulti.config.PruneScheduleConfig;
import io.github.skydynamic.quickbakcupmulti.utils.BackupManager;
import io.github.skydynamic.quickbakcupmulti.utils.DurationUtils;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;

public class DefaultPruneRunnable
implements Runnable {
    private final PruneScheduleConfig config;
    private final PruneRunnable executor;
    public static final DefaultPruneRunnable PRUNE_REGULAR_BACKUP_RUNNABLE = new DefaultPruneRunnable(QuickbakcupmultiReforged.getModConfig().getPruneScheduleConfig(), DefaultPruneRunnable::defaultPruneRegularBackup);
    public static final DefaultPruneRunnable PRUNE_TEMPORARY_BACKUP_RUNNABLE = new DefaultPruneRunnable(QuickbakcupmultiReforged.getModConfig().getPruneScheduleConfig(), DefaultPruneRunnable::defaultPruneTemporaryBackup);

    public DefaultPruneRunnable(PruneScheduleConfig config, PruneRunnable executor) {
        this.config = config;
        this.executor = executor;
    }

    @Override
    public void run() {
        CommandSourceStack commandSourceStack = QuickbakcupmultiReforged.getServerManager().getCommandSource();
        this.executor.execute(this.config, commandSourceStack);
    }

    private static void defaultPruneRegularBackup(PruneScheduleConfig config, CommandSourceStack commandSourceStack) {
        List backupList = QuickbakcupmultiReforged.getDatabase().getAllStorageInfo();
        List<StorageInfo> toDelete = DefaultPruneRunnable.filterBackupWithPbs(config.getRegularBackup(), backupList, config.getTimezoneOverride());
        toDelete.forEach(backup -> BackupManager.deleteBackup(commandSourceStack, backup.getName()));
        QuickbakcupmultiReforged.logger.info("Prune backup: {}", (Object)toDelete.size());
    }

    private static void defaultPruneTemporaryBackup(PruneScheduleConfig config, CommandSourceStack commandSourceStack) {
        QuickbakcupmultiReforged.getManager().deleteTempStorage();
        QuickbakcupmultiReforged.logger.info("Prune temporary backup success");
    }

    private static List<StorageInfo> filterBackupWithPbs(PbsConfig pbsConfig, List<StorageInfo> backupList, String timezoneOverride) {
        if (pbsConfig == null || !pbsConfig.isEnabled() || backupList == null || backupList.isEmpty()) {
            return new ArrayList<StorageInfo>();
        }
        ZoneId zoneId = timezoneOverride != null ? ZoneId.of(timezoneOverride) : ZoneId.systemDefault();
        ArrayList<StorageInfo> filteredList = new ArrayList<StorageInfo>(backupList);
        filteredList.sort(Comparator.comparingLong(StorageInfo::getTimestamp));
        ArrayList<StorageInfo> toDelete = new ArrayList<StorageInfo>();
        Map<String, Integer> timeUnits = Map.of("hour", pbsConfig.getHour(), "day", pbsConfig.getDay(), "week", pbsConfig.getWeek(), "month", pbsConfig.getMonth(), "year", pbsConfig.getYear());
        for (Map.Entry<String, Integer> entry : timeUnits.entrySet()) {
            String unit = entry.getKey();
            int count = entry.getValue();
            if (count <= 0) continue;
            HashMap<String, StorageInfo> latestPerUnit = new HashMap<String, StorageInfo>();
            for (StorageInfo backup : filteredList) {
                String key = DurationUtils.formatByUnit(backup.getTimestamp(), unit, zoneId);
                if (!latestPerUnit.containsKey(key)) {
                    latestPerUnit.put(key, backup);
                    continue;
                }
                if (backup.getTimestamp() > ((StorageInfo)latestPerUnit.get(key)).getTimestamp()) {
                    toDelete.add((StorageInfo)latestPerUnit.get(key));
                    latestPerUnit.put(key, backup);
                    continue;
                }
                toDelete.add(backup);
            }
            filteredList.removeAll(latestPerUnit.values());
        }
        if (pbsConfig.getLast() > 0 && filteredList.size() > pbsConfig.getLast()) {
            int keepCount = pbsConfig.getLast();
            List toKeep = filteredList.subList(filteredList.size() - keepCount, filteredList.size());
            HashSet toKeepSet = new HashSet(toKeep);
            toDelete.addAll(filteredList.stream().filter(b -> !toKeepSet.contains(b)).toList());
        }
        if (pbsConfig.getMaxLifeTime() != null && !pbsConfig.getMaxLifeTime().equals("0s")) {
            long maxLifeTimeMillis = DurationUtils.parseDurationToSeconds(pbsConfig.getMaxLifeTime()) * 1000L;
            long now = System.currentTimeMillis();
            List<StorageInfo> expired = filteredList.stream().filter(b -> now - b.getTimestamp() > maxLifeTimeMillis).toList();
            toDelete.addAll(expired);
            filteredList.removeAll(expired);
        }
        if (pbsConfig.getMaxAmount() > 0 && filteredList.size() > pbsConfig.getMaxAmount()) {
            int removeCount = filteredList.size() - pbsConfig.getMaxAmount();
            toDelete.addAll(filteredList.subList(0, removeCount));
        }
        return toDelete;
    }

    @FunctionalInterface
    public static interface PruneRunnable {
        public void execute(PruneScheduleConfig var1, CommandSourceStack var2);
    }
}

