/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.utils;

import io.github.skydynamic.increment.storage.lib.database.Database;
import io.github.skydynamic.increment.storage.lib.database.DatabaseTables;
import io.github.skydynamic.increment.storage.lib.database.StorageInfo;
import io.github.skydynamic.increment.storage.lib.manager.IDatabaseManager;
import io.github.skydynamic.quickbakcupmulti.DatabaseCache;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.database.DatabaseManager;
import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"Qbm-BackupManager");
    private static final IOFileFilter folderFilter = new NotFileFilter((IOFileFilter)new NameFileFilter(QuickbakcupmultiReforged.getModConfig().getIgnoredFolders()));
    private static final IOFileFilter fileFilter = new NotFileFilter((IOFileFilter)new NameFileFilter(QuickbakcupmultiReforged.getModConfig().getIgnoredFiles()));

    public static Path getBackupPath() {
        Path path = Path.of(QuickbakcupmultiReforged.getModConfig().getStoragePath(), new String[0]).resolve(QuickbakcupmultiReforged.getModContainer().getLevelId());
        if (!Files.exists(path, new LinkOption[0]) || !Files.isDirectory(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                QuickbakcupmultiReforged.logger.error("Create backup path error: {}", (Object)e.getMessage());
            }
        }
        return path;
    }

    public static List<StorageInfo> getBackupsList() {
        List backupList = !QuickbakcupmultiReforged.getModConfig().isCacheDatabase() ? QuickbakcupmultiReforged.getDatabase().getAllStorageInfo() : DatabaseCache.getStorageInfoCaches();
        return backupList;
    }

    public static List<StorageInfo> getSortedBackups() {
        return BackupManager.getBackupsList().stream().sorted(Comparator.comparingLong(StorageInfo::getTimestamp)).toList();
    }

    public static StorageInfo getBackupByIndex(int index) {
        List<StorageInfo> backups = BackupManager.getSortedBackups();
        if (index < 1 || index > backups.size()) {
            return null;
        }
        return backups.get(index - 1);
    }

    public static int getBackupIndex(String name) {
        List<StorageInfo> backups = BackupManager.getSortedBackups();
        for (int i = 0; i < backups.size(); ++i) {
            if (!backups.get(i).getName().equals(name)) continue;
            return i + 1;
        }
        return -1;
    }

    public static void makeBackup(CommandSourceStack commandSource, String name, String desc) {
        if (QuickbakcupmultiReforged.getDatabase().storageExists(name)) {
            commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.make.fail_exists", new Object[0])));
            return;
        }
        long startTime = System.currentTimeMillis();
        try {
            commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.make.start", new Object[0])));
            MinecraftServer server = commandSource.getServer();
            server.executeIfPossible(() -> server.saveEverything(true, true, true));
            for (ServerLevel serverLevel : server.getAllLevels()) {
                if (serverLevel == null || serverLevel.noSave) continue;
                serverLevel.noSave = true;
            }
            QuickbakcupmultiReforged.getManager().incrementalStorage(name, desc, QuickbakcupmultiReforged.getModContainer().getCurrentSavePath().toFile(), fileFilter, folderFilter);
            long endTime = System.currentTimeMillis();
            double intervalTime = (double)(endTime - startTime) / 1000.0;
            commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.make.success", intervalTime)));
            for (ServerLevel serverLevel : server.getAllLevels()) {
                if (serverLevel == null || !serverLevel.noSave) continue;
                serverLevel.noSave = false;
            }
        }
        catch (Exception e) {
            logger.error("Make Backup Failed", (Throwable)e);
            commandSource.sendSystemMessage(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.make.fail", e.toString())));
        }
    }

    public static void makeTempBackup() {
        QuickbakcupmultiReforged.logger.info("Make a temp backup...");
        QuickbakcupmultiReforged.getManager().incrementalStorageTemp(QuickbakcupmultiReforged.getModContainer().getCurrentSavePath().toFile(), fileFilter, folderFilter);
        QuickbakcupmultiReforged.logger.info("Make a temp backup success.");
    }

    public static boolean deleteBackup(CommandSourceStack commandSource, String name) {
        if (QuickbakcupmultiReforged.getDatabase().storageExists(name)) {
            QuickbakcupmultiReforged.getManager().deleteStorage(name);
            return true;
        }
        return false;
    }

    public static void restoreBackup(String name, RestoreExtraRunnable extraRunnable) {
        Map hashMap = QuickbakcupmultiReforged.getDatabase().getFileHashMap(name);
        Path savePath = QuickbakcupmultiReforged.getModContainer().getCurrentSavePath();
        try {
            int index = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                File hashFile;
                String fileHash = (String)entry.getKey();
                String fileName = (String)entry.getValue();
                if (fileHash.startsWith("blog_temp")) {
                    hashFile = BackupManager.getBackupPath().resolve("blogs_temp").resolve(fileHash).toFile();
                } else {
                    String hashStart = fileHash.substring(0, 2);
                    hashFile = BackupManager.getBackupPath().resolve("blogs").resolve(hashStart).resolve(fileHash).toFile();
                }
                File targetDir = savePath.resolve(fileName).toFile();
                FileUtils.copyFile((File)hashFile, (File)targetDir);
                ++index;
                if (extraRunnable == null) continue;
                extraRunnable.execute(hashMap.size(), index);
            }
        }
        catch (IOException e) {
            logger.error("Restore Failed", (Throwable)e);
        }
    }

    public static void restoreBackup(String name) {
        BackupManager.restoreBackup(name, null);
    }

    public static void deleteWorld(String worldName) {
        try {
            FileUtils.deleteDirectory((File)BackupManager.getBackupPath().toFile());
            DatabaseManager databaseManager = new DatabaseManager("QuickBakcupMulti", QuickbakcupmultiReforged.getModConfig().getStoragePath(), UUID.nameUUIDFromBytes(worldName.getBytes()));
            Database database = new Database((IDatabaseManager)databaseManager);
            List storageInfoList = database.getAllStorageInfo();
            for (StorageInfo storageInfo : storageInfoList) {
                database.deleteTableValue(storageInfo.getName(), DatabaseTables.FILE_HASH);
                database.deleteTableValue(storageInfo.getName(), DatabaseTables.STORAGE_INFO);
            }
        }
        catch (IOException e) {
            QuickbakcupmultiReforged.logger.error("Delete Failed", (Throwable)e);
        }
    }

    @FunctionalInterface
    public static interface RestoreExtraRunnable {
        public void execute(int var1, int var2);
    }
}

