/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.utils;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationUtils {
    public static long parseDurationToSeconds(String input) {
        String unit;
        Pattern pattern = Pattern.compile("(\\d+)([a-zA-Z]+)");
        Matcher matcher = pattern.matcher(input.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid jitter format: " + input);
        }
        long value = Long.parseLong(matcher.group(1));
        return switch (unit = matcher.group(2).toLowerCase()) {
            case "ms", "milli", "millis" -> value / 1000L;
            case "s", "sec", "second", "seconds" -> value;
            case "m", "min", "minute", "minutes" -> value * 60L;
            case "h", "hr", "hour", "hours" -> value * 60L * 60L;
            case "d", "day", "days" -> value * 24L * 60L * 60L;
            case "w", "week", "weeks" -> value * 7L * 24L * 60L * 60L;
            case "mo", "mon", "month", "months" -> value * 30L * 24L * 60L * 60L;
            case "y", "yr", "year", "years" -> value * 365L * 24L * 60L * 60L;
            default -> 0L;
        };
    }

    public static String formatByUnit(long timestamp, String unit, ZoneId zoneId) {
        LocalDateTime dateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        return switch (unit) {
            case "hour" -> dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH"));
            case "day" -> dateTime.format(DateTimeFormatter.ISO_LOCAL_DATE);
            case "week" -> String.format("%d-%02d", dateTime.getYear(), dateTime.getYear() / 52 + 1);
            case "month" -> dateTime.format(DateTimeFormatter.ofPattern("yyyy-MM"));
            case "year" -> String.valueOf(dateTime.getYear());
            default -> "";
        };
    }

    public static int getRandomDurationInSeconds(long maxJitterSeconds) {
        if (maxJitterSeconds <= 0L) {
            return 0;
        }
        return new Random().nextInt((int)maxJitterSeconds + 1);
    }

    public static int parseAndRandom(String input) {
        long parse = DurationUtils.parseDurationToSeconds(input);
        return DurationUtils.getRandomDurationInSeconds((int)parse);
    }
}

