/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.utils;

import io.github.skydynamic.increment.storage.lib.database.StorageInfo;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.translate.Translate;
import io.github.skydynamic.quickbakcupmulti.utils.BackupManager;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListBackupsUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"Qbm-ListBackupsUtil");
    private static final int BACKUPS_PER_PAGE = 5;

    private static long getDirSize(File dir) {
        return FileUtils.sizeOf((File)dir);
    }

    public static String truncateString(String str, int maxLength) {
        if (str.length() > maxLength) {
            return str.substring(0, maxLength - 3) + "...";
        }
        return str;
    }

    private static int getPageCount(List<?> backupsDirList, int page) {
        int size = backupsDirList.size();
        int start = (page - 1) * 5;
        return Math.min(5, size - start);
    }

    private static int getTotalPage(List<?> backupsList) {
        return (int)Math.ceil((double)backupsList.size() / 5.0);
    }

    private static MutableComponent getPageNavigationText(String direction, int page, int totalPage, int offset) {
        MutableComponent text = Component.literal((String)direction);
        text.withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText(Component.nullToEmpty((String)direction))));
        if (page != offset && totalPage > 1) {
            text.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.RunCommand("/qb list " + (page + offset)))).withStyle(style -> style.withColor(ChatFormatting.AQUA));
        } else {
            text.withStyle(style -> style.withColor(ChatFormatting.DARK_GRAY));
        }
        return text;
    }

    private static MutableComponent getBackPageText(int page, int totalPage) {
        return ListBackupsUtils.getPageNavigationText("[<-]", page, totalPage, -1);
    }

    private static MutableComponent getNextPageText(int page, int totalPage) {
        return ListBackupsUtils.getPageNavigationText("[->]", page, totalPage, 1);
    }

    private static MutableComponent getSlotText(StorageInfo info, int page, int num, int globalIndex) throws IOException {
        String name = info.getName();
        MutableComponent backText = Component.literal((String)"\u00a72[\u25b7] ");
        MutableComponent deleteText = Component.literal((String)"\u00a7c[\u00d7] ");
        MutableComponent nameText = Component.literal((String)("\u00a76" + ListBackupsUtils.truncateString(name, 8) + "\u00a7r "));
        MutableComponent indexText = Component.literal((String)("#" + globalIndex + " ")).withStyle(style -> style.withColor(ChatFormatting.GRAY));
        MutableComponent resultText = Component.literal((String)"");
        backText.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/qb restore " + globalIndex))).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.list_backup.slot.restore", name)))));
        deleteText.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/qb delete %s".formatted(name)))).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.literal((String)Translate.tr("quickbackupmulti.list_backup.slot.delete", name)))));
        nameText.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/qb show %s".formatted(name)))).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.list_backup.slot.show", name)))));
        String desc = info.getDesc();
        if (desc.isEmpty()) {
            desc = "Empty";
        }
        resultText.append("\n" + Translate.tr("quickbackupmulti.list_backup.slot.header", num + 5 * (page - 1)) + " ").append((Component)indexText).append((Component)nameText).append((Component)backText).append((Component)deleteText).append(String.format(" \u00a7b%s\u00a77: \u00a7r%s", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(info.getTimestamp()), ListBackupsUtils.truncateString(desc, 10)));
        return resultText;
    }

    public static MutableComponent list(int page) {
        long totalBackupSizeB = 0L;
        List<StorageInfo> backupsInfoList = BackupManager.getSortedBackups();
        if (backupsInfoList.isEmpty() || ListBackupsUtils.getPageCount(backupsInfoList, page) == 0) {
            return Component.literal((String)Translate.tr("quickbackupmulti.list_empty", new Object[0]));
        }
        int totalPage = ListBackupsUtils.getTotalPage(backupsInfoList);
        File blogsDir = BackupManager.getBackupPath().resolve("blogs").toFile();
        if (blogsDir.exists()) {
            totalBackupSizeB = ListBackupsUtils.getDirSize(blogsDir);
        }
        MutableComponent resultText = Component.literal((String)Translate.tr("quickbackupmulti.list_backup.title", page));
        MutableComponent backPageText = ListBackupsUtils.getBackPageText(page, totalPage);
        MutableComponent nextPageText = ListBackupsUtils.getNextPageText(page, totalPage);
        resultText.append("\n").append((Component)backPageText).append("  ").append(Translate.tr("quickbackupmulti.list_backup.page_msg", page, totalPage)).append("  ").append((Component)nextPageText);
        for (int j = 1; j <= ListBackupsUtils.getPageCount(backupsInfoList, page); ++j) {
            try {
                StorageInfo info = backupsInfoList.get(j - 1 + 5 * (page - 1));
                int globalIndex = (page - 1) * 5 + j;
                resultText.append((Component)ListBackupsUtils.getSlotText(info, page, j, globalIndex));
                continue;
            }
            catch (IOException e) {
                logger.error("Error while listing backups", (Throwable)e);
                return Component.literal((String)"Error while listing backups").withStyle(ChatFormatting.RED);
            }
        }
        double totalBackupSizeMB = (double)totalBackupSizeB / 1048576.0;
        double totalBackupSizeGB = (double)totalBackupSizeB / 1.073741824E9;
        String sizeString = totalBackupSizeMB >= 1000.0 ? String.format("%.2fGB", totalBackupSizeGB) : String.format("%.2fMB", totalBackupSizeMB);
        resultText.append("\n" + Translate.tr("quickbackupmulti.list_backup.slot.total_space", sizeString));
        return resultText;
    }

    public static MutableComponent search(List<String> searchResultList) {
        MutableComponent resultText = Component.literal((String)Translate.tr("quickbackupmulti.search.success", new Object[0]));
        for (int i = 1; i <= searchResultList.size(); ++i) {
            try {
                String name = searchResultList.get(i - 1);
                StorageInfo result = QuickbakcupmultiReforged.getDatabase().getStorageInfoWithName(name);
                int globalIndex = BackupManager.getBackupIndex(name);
                if (globalIndex <= 0) {
                    globalIndex = i;
                }
                resultText.append((Component)ListBackupsUtils.getSlotText(result, 1, i, globalIndex));
                continue;
            }
            catch (IOException e) {
                logger.error("Error while searching backups", (Throwable)e);
                return Component.literal((String)"Error while searching backups").withStyle(ChatFormatting.RED);
            }
        }
        return resultText;
    }

    public static MutableComponent show(String name) {
        MutableComponent resultText;
        if (QuickbakcupmultiReforged.getDatabase().storageExists(name)) {
            StorageInfo backupInfo = QuickbakcupmultiReforged.getDatabase().getStorageInfoWithName(name);
            resultText = Component.literal((String)Translate.tr("quickbackupmulti.show.header", new Object[0]));
            String desc = backupInfo.getDesc();
            if (desc.isEmpty()) {
                desc = Translate.tr("quickbackupmulti.empty_comment", new Object[0]);
            }
            MutableComponent backText = Component.literal((String)Translate.tr("quickbackupmulti.show.back_button", new Object[0]));
            MutableComponent deleteText = Component.literal((String)Translate.tr("quickbackupmulti.show.delete_button", new Object[0]));
            backText.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/qb restore \"%s\"".formatted(name)))).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.list_backup.slot.restore", name)))));
            deleteText.withStyle(style -> style.withClickEvent((ClickEvent)new ClickEvent.SuggestCommand("/qb delete \"%s\"".formatted(name)))).withStyle(style -> style.withHoverEvent((HoverEvent)new HoverEvent.ShowText(Component.nullToEmpty((String)Translate.tr("quickbackupmulti.list_backup.slot.delete", name)))));
            resultText.append("\n").append(Translate.tr("quickbackupmulti.show.name", new Object[0]) + ": \u00a7r" + backupInfo.getName() + "\n").append(Translate.tr("quickbackupmulti.show.desc", new Object[0]) + ": \u00a7r" + desc + "\n").append(Translate.tr("quickbackupmulti.show.time", new Object[0]) + ": \u00a7r" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(backupInfo.getTimestamp())).append("\n").append((Component)backText).append(" ").append((Component)deleteText);
        } else {
            resultText = Component.literal((String)Translate.tr("quickbackupmulti.show.fail", new Object[0]));
            resultText.withStyle(style -> style.withColor(ChatFormatting.RED));
        }
        return resultText;
    }
}

