/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.skydynamic.quickbakcupmulti.ModVersion;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;

public class UpdateChecker
extends Thread {
    private static final HttpClient CLIENT = HttpClient.newHttpClient();
    private static final String RELEASE_API_URL = "https://api.github.com/repos/QuickBackupMultiMod-Dev/QuickBackupM-Reforged/releases";

    public UpdateChecker() {
        super("QuickBackupM-Reforged-Update-Checker");
    }

    @Override
    public void run() {
        ModVersion currentVersion = QuickbakcupmultiReforged.getModContainer().getModVersion();
        try {
            ModVersion releaseVersion;
            HttpResponse<String> response = CLIENT.send(HttpRequest.newBuilder().uri(new URI(RELEASE_API_URL)).build(), HttpResponse.BodyHandlers.ofString());
            JsonElement jsonElement = JsonParser.parseString((String)response.body());
            JsonObject release = null;
            if (jsonElement.isJsonArray()) {
                JsonArray releases = jsonElement.getAsJsonArray();
                JsonObject jsonObject = release = releases.get(0).isJsonObject() ? releases.get(0).getAsJsonObject() : null;
            }
            if (release != null && (releaseVersion = new ModVersion(release.get("tag_name").getAsString())).isNewerThan(currentVersion)) {
                QuickbakcupmultiReforged.logger.info("New version available: {}", (Object)releaseVersion);
                QuickbakcupmultiReforged.logger.info("Download link: {}", (Object)release.get("html_url").getAsString());
            }
        }
        catch (IOException | InterruptedException | URISyntaxException e) {
            QuickbakcupmultiReforged.logger.error("Failed to check update", (Throwable)e);
        }
    }
}

