/*
 * Decompiled with CFR 0.152.
 */
package io.github.skydynamic.quickbakcupmulti.utils.permission;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.skydynamic.quickbakcupmulti.QuickbakcupmultiReforged;
import io.github.skydynamic.quickbakcupmulti.utils.permission.PermissionType;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class PermissionManager {
    private static final Path configPath = QuickbakcupmultiReforged.getModContainer().getConfigPath();
    private static final File config = configPath.resolve("QuickBackupMulti-Permission.json").toFile();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private PermissionConfig permissionConfig;

    public PermissionManager() {
        if (!config.exists()) {
            this.initPermission();
        } else {
            this.loadPermissionByFile();
        }
    }

    public void setPermissionByPermissionLevelInt(int level, String playerName) {
        this.permissionConfig.setByPermissionType(PermissionType.getByLevelInt(level), playerName);
    }

    public void setPermissionByPermissionType(PermissionType permission, String playerName) {
        this.permissionConfig.setByPermissionType(permission, playerName);
    }

    public PermissionType getPlayerPermission(String name) {
        return this.permissionConfig.perm.getOrDefault(name, PermissionType.USER);
    }

    public int getPlayerPermissionLevel(String player) {
        return this.getPlayerPermission((String)player).level;
    }

    private void loadPermissionByFile() {
        try {
            FileReader reader = new FileReader(config);
            this.permissionConfig = (PermissionConfig)gson.fromJson((Reader)reader, PermissionConfig.class);
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void savePermissionToFile() {
        try {
            if (config.exists()) {
                config.delete();
            }
            if (!config.exists()) {
                config.createNewFile();
            }
            FileWriter writer = new FileWriter(config);
            gson.toJson((Object)this.permissionConfig, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void reloadPermission() {
        this.loadPermissionByFile();
    }

    public void initPermission() {
        try {
            this.permissionConfig = new PermissionConfig();
            config.createNewFile();
            FileWriter writer = new FileWriter(config);
            gson.toJson((Object)this.permissionConfig, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasPermission(@NotNull CommandSourceStack source, int mcPermission, PermissionType modPermission) {
        ServerPlayer player = source.getPlayer();
        if (player != null) {
            if (PermissionManager.checkLocalGamePermission(source)) {
                return true;
            }
            return source.hasPermission(mcPermission) || QuickbakcupmultiReforged.getModContainer().getPermissionManager().getPlayerPermissionLevel(player.getName().getString()) >= modPermission.level;
        }
        return true;
    }

    public static boolean checkLocalGamePermission(@NotNull CommandSourceStack source) {
        try {
            return PermissionManager.getPermission(source);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    private static boolean getPermission(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer player;
        MinecraftServer server;
        boolean flag = source.hasPermission(4);
        if (!flag && (server = source.getServer()).isSingleplayer() && (player = source.getPlayer()) != null && source.isPlayer()) {
            flag = server.isSingleplayerOwner(player.getGameProfile());
        }
        return flag;
    }

    static class PermissionConfig {
        private final Map<String, PermissionType> perm = new HashMap<String, PermissionType>();

        PermissionConfig() {
        }

        public void setByPermissionType(PermissionType type, String name) {
            this.perm.put(name, type);
            QuickbakcupmultiReforged.getModContainer().getPermissionManager().savePermissionToFile();
        }
    }
}

