/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.generatorcraft.GeneratorcraftMod;
import net.mcreator.generatorcraft.procedures.DevBecomeOpProcedure;
import net.mcreator.generatorcraft.procedures.DevGamemodeSwitcherProcedure;
import net.mcreator.generatorcraft.procedures.DevIgnoreCooldownsButtonProcedure;
import net.mcreator.generatorcraft.procedures.DevIgnoreLimitsButtonProcedure;
import net.mcreator.generatorcraft.procedures.DevModifyButtonProcedure;
import net.mcreator.generatorcraft.procedures.DevToTimeButtonProcedure;
import net.mcreator.generatorcraft.world.inventory.DevGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DevGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public DevGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public DevGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(DevGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(DevGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            DevGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = DevGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            DevModifyButtonProcedure.execute((LevelAccessor)world, (Entity)entity, guistate);
        }
        if (buttonID == 1) {
            DevIgnoreLimitsButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            DevBecomeOpProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            DevGamemodeSwitcherProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, guistate);
        }
        if (buttonID == 4) {
            DevIgnoreCooldownsButtonProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            DevToTimeButtonProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        GeneratorcraftMod.addNetworkMessage(DevGUIButtonMessage.class, DevGUIButtonMessage::buffer, DevGUIButtonMessage::new, DevGUIButtonMessage::handler);
    }
}

