/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.network;

import java.util.function.Supplier;
import net.mcreator.generatorcraft.GeneratorcraftMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeneratorcraftModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GeneratorcraftMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        GeneratorcraftMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.coins = message.data.coins;
                    variables.gems = message.data.gems;
                    variables.ValueOverlayShown = message.data.ValueOverlayShown;
                    variables.coin_chance = message.data.coin_chance;
                    variables.box_chance = message.data.box_chance;
                    variables.coin_multiplier = message.data.coin_multiplier;
                    variables.combat_log_timer = message.data.combat_log_timer;
                    variables.combat_logged = message.data.combat_logged;
                    variables.held_box_rarity = message.data.held_box_rarity;
                    variables.opened_box_rarity = message.data.opened_box_rarity;
                    variables.upgrade_coin_chance_cost = message.data.upgrade_coin_chance_cost;
                    variables.upgrade_box_chance_cost = message.data.upgrade_box_chance_cost;
                    variables.upgrade_coin_multiplayer_cost = message.data.upgrade_coin_multiplayer_cost;
                    variables.gem_chance = message.data.gem_chance;
                    variables.gem_chance_upgrade_cost = message.data.gem_chance_upgrade_cost;
                    variables.gamble_slot_0 = message.data.gamble_slot_0;
                    variables.gamble_slot_1 = message.data.gamble_slot_1;
                    variables.gamble_slot_2 = message.data.gamble_slot_2;
                    variables.slots_forgive = message.data.slots_forgive;
                    variables.slots_rolling = message.data.slots_rolling;
                    variables.slots_unlocked = message.data.slots_unlocked;
                    variables.combat_log_time = message.data.combat_log_time;
                    variables.upgrade_combat_log_time_cost = message.data.upgrade_combat_log_time_cost;
                    variables.combat_log_time_seconds = message.data.combat_log_time_seconds;
                    variables.debug_overlay_shown = message.data.debug_overlay_shown;
                    variables.lootbox_item = message.data.lootbox_item;
                    variables.watermark_funny = message.data.watermark_funny;
                    variables.slot_thing = message.data.slot_thing;
                    variables.dice_roll = message.data.dice_roll;
                    variables.is_ad_active_right_now = message.data.is_ad_active_right_now;
                    variables.ad_time_until_skip = message.data.ad_time_until_skip;
                    variables.adblock_enabled = message.data.adblock_enabled;
                    variables.can_skip_ad = message.data.can_skip_ad;
                    variables.time_until_ad_ticks = message.data.time_until_ad_ticks;
                    variables.time_until_ad_seconds = message.data.time_until_ad_seconds;
                    variables.time_until_ad_minutes = message.data.time_until_ad_minutes;
                    variables.ad_time_until_skip_seconds = message.data.ad_time_until_skip_seconds;
                    variables.tips_enabled = message.data.tips_enabled;
                    variables.captcha_active = message.data.captcha_active;
                    variables.human_number_1 = message.data.human_number_1;
                    variables.human_number_2 = message.data.human_number_2;
                    variables.human_number_3 = message.data.human_number_3;
                    variables.GC_LEVEL = message.data.GC_LEVEL;
                    variables.level_color = message.data.level_color;
                    variables.gc_team_name = message.data.gc_team_name;
                    variables.player_username = message.data.player_username;
                    variables.gc_team_active = message.data.gc_team_active;
                    variables.gc_current_xp = message.data.gc_current_xp;
                    variables.gc_total_xp = message.data.gc_total_xp;
                    variables.max_coins = message.data.max_coins;
                    variables.max_gems = message.data.max_gems;
                    variables.bank_unlocked = message.data.bank_unlocked;
                    variables.coins_in_bank = message.data.coins_in_bank;
                    variables.gems_in_bank = message.data.gems_in_bank;
                    variables.max_coins_in_bank = message.data.max_coins_in_bank;
                    variables.max_gems_in_bank = message.data.max_gems_in_bank;
                    variables.bank_level = message.data.bank_level;
                    variables.ignore_limits_dev = message.data.ignore_limits_dev;
                    variables.know_how_to_play = message.data.know_how_to_play;
                    variables.ignore_cooldowns_dev = message.data.ignore_cooldowns_dev;
                    variables.forgive_claimed = message.data.forgive_claimed;
                    variables.daily_collected = message.data.daily_collected;
                    variables.slot_spins = message.data.slot_spins;
                    variables.daily_reminder_clock = message.data.daily_reminder_clock;
                    variables.daily_reminder_action = message.data.daily_reminder_action;
                    variables.box_chance_logic = message.data.box_chance_logic;
                    variables.duper_cooldown_active = message.data.duper_cooldown_active;
                    variables.duper_cooldown_clock_ticks = message.data.duper_cooldown_clock_ticks;
                    variables.price_multiplier = message.data.price_multiplier;
                    variables.upgrade_price_multiplier_cost = message.data.upgrade_price_multiplier_cost;
                    variables.price_mp_fixed = message.data.price_mp_fixed;
                    variables.rebirths = message.data.rebirths;
                    variables.rebirth_boost = message.data.rebirth_boost;
                    variables.rebirth_notify = message.data.rebirth_notify;
                    variables.debt_to_world_bank = message.data.debt_to_world_bank;
                    variables.debt_timer_ticks = message.data.debt_timer_ticks;
                    variables.debt_timer_seconds = message.data.debt_timer_seconds;
                    variables.bad_debt_timer = message.data.bad_debt_timer;
                    variables.failed_to_repay_debt = message.data.failed_to_repay_debt;
                    variables.is_loaning = message.data.is_loaning;
                    variables.emptix_tokens = message.data.emptix_tokens;
                    variables.lootbox_table_id = message.data.lootbox_table_id;
                    variables.actual_hit = message.data.actual_hit;
                    variables.actual_damage = message.data.actual_damage;
                    variables.mobkill_msg = message.data.mobkill_msg;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double coins = 0.0;
        public double gems = 0.0;
        public boolean ValueOverlayShown = true;
        public double coin_chance = 1.0;
        public double box_chance = 10.0;
        public double coin_multiplier = 1.0;
        public double combat_log_timer = 0.0;
        public boolean combat_logged = false;
        public double held_box_rarity = 0.0;
        public double opened_box_rarity = 0.0;
        public double upgrade_coin_chance_cost = 10.0;
        public double upgrade_box_chance_cost = 500.0;
        public double upgrade_coin_multiplayer_cost = 5000.0;
        public double gem_chance = 0.0;
        public double gem_chance_upgrade_cost = 10000.0;
        public ItemStack gamble_slot_0 = ItemStack.f_41583_;
        public ItemStack gamble_slot_1 = ItemStack.f_41583_;
        public ItemStack gamble_slot_2 = ItemStack.f_41583_;
        public double slots_forgive = 0.0;
        public boolean slots_rolling = false;
        public boolean slots_unlocked = false;
        public double combat_log_time = 100.0;
        public double upgrade_combat_log_time_cost = 500.0;
        public double combat_log_time_seconds = 0.0;
        public boolean debug_overlay_shown = false;
        public ItemStack lootbox_item = ItemStack.f_41583_;
        public boolean watermark_funny = true;
        public double slot_thing = 1.0;
        public double dice_roll = 0.0;
        public boolean is_ad_active_right_now = false;
        public double ad_time_until_skip = 0.0;
        public boolean adblock_enabled = false;
        public boolean can_skip_ad = false;
        public double time_until_ad_ticks = 0.0;
        public double time_until_ad_seconds = 0.0;
        public double time_until_ad_minutes = 0.0;
        public double ad_time_until_skip_seconds = 0.0;
        public boolean tips_enabled = true;
        public boolean captcha_active = false;
        public double human_number_1 = 0.0;
        public double human_number_2 = 0.0;
        public double human_number_3 = 0.0;
        public double GC_LEVEL = 1.0;
        public String level_color = "white";
        public String gc_team_name = "none";
        public String player_username = "\"\"";
        public boolean gc_team_active = false;
        public double gc_current_xp = 1.0;
        public double gc_total_xp = 1.0;
        public double max_coins = 1000.0;
        public double max_gems = 1000.0;
        public boolean bank_unlocked = false;
        public double coins_in_bank = 0.0;
        public double gems_in_bank = 0.0;
        public double max_coins_in_bank = 0.0;
        public double max_gems_in_bank = 0.0;
        public double bank_level = 0.0;
        public boolean ignore_limits_dev = false;
        public boolean know_how_to_play = false;
        public boolean ignore_cooldowns_dev = false;
        public boolean forgive_claimed = false;
        public boolean daily_collected = false;
        public double slot_spins = 0.0;
        public double daily_reminder_clock = 0.0;
        public boolean daily_reminder_action = false;
        public boolean box_chance_logic = true;
        public boolean duper_cooldown_active = false;
        public double duper_cooldown_clock_ticks = 72000.0;
        public double price_multiplier = 1.0;
        public double upgrade_price_multiplier_cost = 0.0;
        public boolean price_mp_fixed = false;
        public double rebirths = 0.0;
        public double rebirth_boost = 0.0;
        public boolean rebirth_notify = false;
        public double debt_to_world_bank = 0.0;
        public double debt_timer_ticks = 0.0;
        public double debt_timer_seconds = 0.0;
        public double bad_debt_timer = 0.0;
        public boolean failed_to_repay_debt = false;
        public boolean is_loaning = false;
        public double emptix_tokens = 0.0;
        public String lootbox_table_id = "\"\"";
        public boolean actual_hit = false;
        public boolean actual_damage = false;
        public boolean mobkill_msg = true;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("coins", this.coins);
            nbt.m_128347_("gems", this.gems);
            nbt.m_128379_("ValueOverlayShown", this.ValueOverlayShown);
            nbt.m_128347_("coin_chance", this.coin_chance);
            nbt.m_128347_("box_chance", this.box_chance);
            nbt.m_128347_("coin_multiplier", this.coin_multiplier);
            nbt.m_128347_("combat_log_timer", this.combat_log_timer);
            nbt.m_128379_("combat_logged", this.combat_logged);
            nbt.m_128347_("held_box_rarity", this.held_box_rarity);
            nbt.m_128347_("opened_box_rarity", this.opened_box_rarity);
            nbt.m_128347_("upgrade_coin_chance_cost", this.upgrade_coin_chance_cost);
            nbt.m_128347_("upgrade_box_chance_cost", this.upgrade_box_chance_cost);
            nbt.m_128347_("upgrade_coin_multiplayer_cost", this.upgrade_coin_multiplayer_cost);
            nbt.m_128347_("gem_chance", this.gem_chance);
            nbt.m_128347_("gem_chance_upgrade_cost", this.gem_chance_upgrade_cost);
            nbt.m_128365_("gamble_slot_0", (Tag)this.gamble_slot_0.m_41739_(new CompoundTag()));
            nbt.m_128365_("gamble_slot_1", (Tag)this.gamble_slot_1.m_41739_(new CompoundTag()));
            nbt.m_128365_("gamble_slot_2", (Tag)this.gamble_slot_2.m_41739_(new CompoundTag()));
            nbt.m_128347_("slots_forgive", this.slots_forgive);
            nbt.m_128379_("slots_rolling", this.slots_rolling);
            nbt.m_128379_("slots_unlocked", this.slots_unlocked);
            nbt.m_128347_("combat_log_time", this.combat_log_time);
            nbt.m_128347_("upgrade_combat_log_time_cost", this.upgrade_combat_log_time_cost);
            nbt.m_128347_("combat_log_time_seconds", this.combat_log_time_seconds);
            nbt.m_128379_("debug_overlay_shown", this.debug_overlay_shown);
            nbt.m_128365_("lootbox_item", (Tag)this.lootbox_item.m_41739_(new CompoundTag()));
            nbt.m_128379_("watermark_funny", this.watermark_funny);
            nbt.m_128347_("slot_thing", this.slot_thing);
            nbt.m_128347_("dice_roll", this.dice_roll);
            nbt.m_128379_("is_ad_active_right_now", this.is_ad_active_right_now);
            nbt.m_128347_("ad_time_until_skip", this.ad_time_until_skip);
            nbt.m_128379_("adblock_enabled", this.adblock_enabled);
            nbt.m_128379_("can_skip_ad", this.can_skip_ad);
            nbt.m_128347_("time_until_ad_ticks", this.time_until_ad_ticks);
            nbt.m_128347_("time_until_ad_seconds", this.time_until_ad_seconds);
            nbt.m_128347_("time_until_ad_minutes", this.time_until_ad_minutes);
            nbt.m_128347_("ad_time_until_skip_seconds", this.ad_time_until_skip_seconds);
            nbt.m_128379_("tips_enabled", this.tips_enabled);
            nbt.m_128379_("captcha_active", this.captcha_active);
            nbt.m_128347_("human_number_1", this.human_number_1);
            nbt.m_128347_("human_number_2", this.human_number_2);
            nbt.m_128347_("human_number_3", this.human_number_3);
            nbt.m_128347_("GC_LEVEL", this.GC_LEVEL);
            nbt.m_128359_("level_color", this.level_color);
            nbt.m_128359_("gc_team_name", this.gc_team_name);
            nbt.m_128359_("player_username", this.player_username);
            nbt.m_128379_("gc_team_active", this.gc_team_active);
            nbt.m_128347_("gc_current_xp", this.gc_current_xp);
            nbt.m_128347_("gc_total_xp", this.gc_total_xp);
            nbt.m_128347_("max_coins", this.max_coins);
            nbt.m_128347_("max_gems", this.max_gems);
            nbt.m_128379_("bank_unlocked", this.bank_unlocked);
            nbt.m_128347_("coins_in_bank", this.coins_in_bank);
            nbt.m_128347_("gems_in_bank", this.gems_in_bank);
            nbt.m_128347_("max_coins_in_bank", this.max_coins_in_bank);
            nbt.m_128347_("max_gems_in_bank", this.max_gems_in_bank);
            nbt.m_128347_("bank_level", this.bank_level);
            nbt.m_128379_("ignore_limits_dev", this.ignore_limits_dev);
            nbt.m_128379_("know_how_to_play", this.know_how_to_play);
            nbt.m_128379_("ignore_cooldowns_dev", this.ignore_cooldowns_dev);
            nbt.m_128379_("forgive_claimed", this.forgive_claimed);
            nbt.m_128379_("daily_collected", this.daily_collected);
            nbt.m_128347_("slot_spins", this.slot_spins);
            nbt.m_128347_("daily_reminder_clock", this.daily_reminder_clock);
            nbt.m_128379_("daily_reminder_action", this.daily_reminder_action);
            nbt.m_128379_("box_chance_logic", this.box_chance_logic);
            nbt.m_128379_("duper_cooldown_active", this.duper_cooldown_active);
            nbt.m_128347_("duper_cooldown_clock_ticks", this.duper_cooldown_clock_ticks);
            nbt.m_128347_("price_multiplier", this.price_multiplier);
            nbt.m_128347_("upgrade_price_multiplier_cost", this.upgrade_price_multiplier_cost);
            nbt.m_128379_("price_mp_fixed", this.price_mp_fixed);
            nbt.m_128347_("rebirths", this.rebirths);
            nbt.m_128347_("rebirth_boost", this.rebirth_boost);
            nbt.m_128379_("rebirth_notify", this.rebirth_notify);
            nbt.m_128347_("debt_to_world_bank", this.debt_to_world_bank);
            nbt.m_128347_("debt_timer_ticks", this.debt_timer_ticks);
            nbt.m_128347_("debt_timer_seconds", this.debt_timer_seconds);
            nbt.m_128347_("bad_debt_timer", this.bad_debt_timer);
            nbt.m_128379_("failed_to_repay_debt", this.failed_to_repay_debt);
            nbt.m_128379_("is_loaning", this.is_loaning);
            nbt.m_128347_("emptix_tokens", this.emptix_tokens);
            nbt.m_128359_("lootbox_table_id", this.lootbox_table_id);
            nbt.m_128379_("actual_hit", this.actual_hit);
            nbt.m_128379_("actual_damage", this.actual_damage);
            nbt.m_128379_("mobkill_msg", this.mobkill_msg);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.coins = nbt.m_128459_("coins");
            this.gems = nbt.m_128459_("gems");
            this.ValueOverlayShown = nbt.m_128471_("ValueOverlayShown");
            this.coin_chance = nbt.m_128459_("coin_chance");
            this.box_chance = nbt.m_128459_("box_chance");
            this.coin_multiplier = nbt.m_128459_("coin_multiplier");
            this.combat_log_timer = nbt.m_128459_("combat_log_timer");
            this.combat_logged = nbt.m_128471_("combat_logged");
            this.held_box_rarity = nbt.m_128459_("held_box_rarity");
            this.opened_box_rarity = nbt.m_128459_("opened_box_rarity");
            this.upgrade_coin_chance_cost = nbt.m_128459_("upgrade_coin_chance_cost");
            this.upgrade_box_chance_cost = nbt.m_128459_("upgrade_box_chance_cost");
            this.upgrade_coin_multiplayer_cost = nbt.m_128459_("upgrade_coin_multiplayer_cost");
            this.gem_chance = nbt.m_128459_("gem_chance");
            this.gem_chance_upgrade_cost = nbt.m_128459_("gem_chance_upgrade_cost");
            this.gamble_slot_0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("gamble_slot_0"));
            this.gamble_slot_1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("gamble_slot_1"));
            this.gamble_slot_2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("gamble_slot_2"));
            this.slots_forgive = nbt.m_128459_("slots_forgive");
            this.slots_rolling = nbt.m_128471_("slots_rolling");
            this.slots_unlocked = nbt.m_128471_("slots_unlocked");
            this.combat_log_time = nbt.m_128459_("combat_log_time");
            this.upgrade_combat_log_time_cost = nbt.m_128459_("upgrade_combat_log_time_cost");
            this.combat_log_time_seconds = nbt.m_128459_("combat_log_time_seconds");
            this.debug_overlay_shown = nbt.m_128471_("debug_overlay_shown");
            this.lootbox_item = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("lootbox_item"));
            this.watermark_funny = nbt.m_128471_("watermark_funny");
            this.slot_thing = nbt.m_128459_("slot_thing");
            this.dice_roll = nbt.m_128459_("dice_roll");
            this.is_ad_active_right_now = nbt.m_128471_("is_ad_active_right_now");
            this.ad_time_until_skip = nbt.m_128459_("ad_time_until_skip");
            this.adblock_enabled = nbt.m_128471_("adblock_enabled");
            this.can_skip_ad = nbt.m_128471_("can_skip_ad");
            this.time_until_ad_ticks = nbt.m_128459_("time_until_ad_ticks");
            this.time_until_ad_seconds = nbt.m_128459_("time_until_ad_seconds");
            this.time_until_ad_minutes = nbt.m_128459_("time_until_ad_minutes");
            this.ad_time_until_skip_seconds = nbt.m_128459_("ad_time_until_skip_seconds");
            this.tips_enabled = nbt.m_128471_("tips_enabled");
            this.captcha_active = nbt.m_128471_("captcha_active");
            this.human_number_1 = nbt.m_128459_("human_number_1");
            this.human_number_2 = nbt.m_128459_("human_number_2");
            this.human_number_3 = nbt.m_128459_("human_number_3");
            this.GC_LEVEL = nbt.m_128459_("GC_LEVEL");
            this.level_color = nbt.m_128461_("level_color");
            this.gc_team_name = nbt.m_128461_("gc_team_name");
            this.player_username = nbt.m_128461_("player_username");
            this.gc_team_active = nbt.m_128471_("gc_team_active");
            this.gc_current_xp = nbt.m_128459_("gc_current_xp");
            this.gc_total_xp = nbt.m_128459_("gc_total_xp");
            this.max_coins = nbt.m_128459_("max_coins");
            this.max_gems = nbt.m_128459_("max_gems");
            this.bank_unlocked = nbt.m_128471_("bank_unlocked");
            this.coins_in_bank = nbt.m_128459_("coins_in_bank");
            this.gems_in_bank = nbt.m_128459_("gems_in_bank");
            this.max_coins_in_bank = nbt.m_128459_("max_coins_in_bank");
            this.max_gems_in_bank = nbt.m_128459_("max_gems_in_bank");
            this.bank_level = nbt.m_128459_("bank_level");
            this.ignore_limits_dev = nbt.m_128471_("ignore_limits_dev");
            this.know_how_to_play = nbt.m_128471_("know_how_to_play");
            this.ignore_cooldowns_dev = nbt.m_128471_("ignore_cooldowns_dev");
            this.forgive_claimed = nbt.m_128471_("forgive_claimed");
            this.daily_collected = nbt.m_128471_("daily_collected");
            this.slot_spins = nbt.m_128459_("slot_spins");
            this.daily_reminder_clock = nbt.m_128459_("daily_reminder_clock");
            this.daily_reminder_action = nbt.m_128471_("daily_reminder_action");
            this.box_chance_logic = nbt.m_128471_("box_chance_logic");
            this.duper_cooldown_active = nbt.m_128471_("duper_cooldown_active");
            this.duper_cooldown_clock_ticks = nbt.m_128459_("duper_cooldown_clock_ticks");
            this.price_multiplier = nbt.m_128459_("price_multiplier");
            this.upgrade_price_multiplier_cost = nbt.m_128459_("upgrade_price_multiplier_cost");
            this.price_mp_fixed = nbt.m_128471_("price_mp_fixed");
            this.rebirths = nbt.m_128459_("rebirths");
            this.rebirth_boost = nbt.m_128459_("rebirth_boost");
            this.rebirth_notify = nbt.m_128471_("rebirth_notify");
            this.debt_to_world_bank = nbt.m_128459_("debt_to_world_bank");
            this.debt_timer_ticks = nbt.m_128459_("debt_timer_ticks");
            this.debt_timer_seconds = nbt.m_128459_("debt_timer_seconds");
            this.bad_debt_timer = nbt.m_128459_("bad_debt_timer");
            this.failed_to_repay_debt = nbt.m_128471_("failed_to_repay_debt");
            this.is_loaning = nbt.m_128471_("is_loaning");
            this.emptix_tokens = nbt.m_128459_("emptix_tokens");
            this.lootbox_table_id = nbt.m_128461_("lootbox_table_id");
            this.actual_hit = nbt.m_128471_("actual_hit");
            this.actual_damage = nbt.m_128471_("actual_damage");
            this.mobkill_msg = nbt.m_128471_("mobkill_msg");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("generatorcraft", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "generatorcraft_mapvars";
        public double gem_multiplier = 1.0;
        public boolean gem_boost_event_active = false;
        public boolean big_gem_bought = false;
        public String big_gem_owner = "\"\"";
        public String big_gem_date = "\"\"";
        public double time_until_tip = 0.0;
        public boolean hoarder_event_active = false;
        public ItemStack hoarder_item = ItemStack.f_41583_;
        public double GC_VERSION = 0.0;
        public double day_of_week = 0.0;
        public double duper_price = 15000.0;
        public double event_timer = 0.0;
        public boolean event_active = false;
        public double active_event_id = 0.0;
        public String active_event_name = "\"\"";
        public boolean emptix_event_active = false;
        public double world_bank = 0.0;
        public double economy_boost = 0.0;
        public String economy_state = "\"\"";
        public boolean world_bank_default = false;
        public double real_price_multiplier = 0.0;
        public double real_output_multiplier = 0.0;
        public boolean corruption_event_active = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.gem_multiplier = nbt.m_128459_("gem_multiplier");
            this.gem_boost_event_active = nbt.m_128471_("gem_boost_event_active");
            this.big_gem_bought = nbt.m_128471_("big_gem_bought");
            this.big_gem_owner = nbt.m_128461_("big_gem_owner");
            this.big_gem_date = nbt.m_128461_("big_gem_date");
            this.time_until_tip = nbt.m_128459_("time_until_tip");
            this.hoarder_event_active = nbt.m_128471_("hoarder_event_active");
            this.hoarder_item = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("hoarder_item"));
            this.GC_VERSION = nbt.m_128459_("GC_VERSION");
            this.day_of_week = nbt.m_128459_("day_of_week");
            this.duper_price = nbt.m_128459_("duper_price");
            this.event_timer = nbt.m_128459_("event_timer");
            this.event_active = nbt.m_128471_("event_active");
            this.active_event_id = nbt.m_128459_("active_event_id");
            this.active_event_name = nbt.m_128461_("active_event_name");
            this.emptix_event_active = nbt.m_128471_("emptix_event_active");
            this.world_bank = nbt.m_128459_("world_bank");
            this.economy_boost = nbt.m_128459_("economy_boost");
            this.economy_state = nbt.m_128461_("economy_state");
            this.world_bank_default = nbt.m_128471_("world_bank_default");
            this.real_price_multiplier = nbt.m_128459_("real_price_multiplier");
            this.real_output_multiplier = nbt.m_128459_("real_output_multiplier");
            this.corruption_event_active = nbt.m_128471_("corruption_event_active");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("gem_multiplier", this.gem_multiplier);
            nbt.m_128379_("gem_boost_event_active", this.gem_boost_event_active);
            nbt.m_128379_("big_gem_bought", this.big_gem_bought);
            nbt.m_128359_("big_gem_owner", this.big_gem_owner);
            nbt.m_128359_("big_gem_date", this.big_gem_date);
            nbt.m_128347_("time_until_tip", this.time_until_tip);
            nbt.m_128379_("hoarder_event_active", this.hoarder_event_active);
            nbt.m_128365_("hoarder_item", (Tag)this.hoarder_item.m_41739_(new CompoundTag()));
            nbt.m_128347_("GC_VERSION", this.GC_VERSION);
            nbt.m_128347_("day_of_week", this.day_of_week);
            nbt.m_128347_("duper_price", this.duper_price);
            nbt.m_128347_("event_timer", this.event_timer);
            nbt.m_128379_("event_active", this.event_active);
            nbt.m_128347_("active_event_id", this.active_event_id);
            nbt.m_128359_("active_event_name", this.active_event_name);
            nbt.m_128379_("emptix_event_active", this.emptix_event_active);
            nbt.m_128347_("world_bank", this.world_bank);
            nbt.m_128347_("economy_boost", this.economy_boost);
            nbt.m_128359_("economy_state", this.economy_state);
            nbt.m_128379_("world_bank_default", this.world_bank_default);
            nbt.m_128347_("real_price_multiplier", this.real_price_multiplier);
            nbt.m_128347_("real_output_multiplier", this.real_output_multiplier);
            nbt.m_128379_("corruption_event_active", this.corruption_event_active);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "generatorcraft_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.coins = original.coins;
            clone.gems = original.gems;
            clone.ValueOverlayShown = original.ValueOverlayShown;
            clone.coin_chance = original.coin_chance;
            clone.box_chance = original.box_chance;
            clone.coin_multiplier = original.coin_multiplier;
            clone.held_box_rarity = original.held_box_rarity;
            clone.opened_box_rarity = original.opened_box_rarity;
            clone.upgrade_coin_chance_cost = original.upgrade_coin_chance_cost;
            clone.upgrade_box_chance_cost = original.upgrade_box_chance_cost;
            clone.upgrade_coin_multiplayer_cost = original.upgrade_coin_multiplayer_cost;
            clone.gem_chance = original.gem_chance;
            clone.gem_chance_upgrade_cost = original.gem_chance_upgrade_cost;
            clone.gamble_slot_0 = original.gamble_slot_0;
            clone.gamble_slot_1 = original.gamble_slot_1;
            clone.gamble_slot_2 = original.gamble_slot_2;
            clone.slots_forgive = original.slots_forgive;
            clone.slots_rolling = original.slots_rolling;
            clone.slots_unlocked = original.slots_unlocked;
            clone.combat_log_time = original.combat_log_time;
            clone.upgrade_combat_log_time_cost = original.upgrade_combat_log_time_cost;
            clone.combat_log_time_seconds = original.combat_log_time_seconds;
            clone.debug_overlay_shown = original.debug_overlay_shown;
            clone.lootbox_item = original.lootbox_item;
            clone.watermark_funny = original.watermark_funny;
            clone.slot_thing = original.slot_thing;
            clone.dice_roll = original.dice_roll;
            clone.is_ad_active_right_now = original.is_ad_active_right_now;
            clone.ad_time_until_skip = original.ad_time_until_skip;
            clone.adblock_enabled = original.adblock_enabled;
            clone.can_skip_ad = original.can_skip_ad;
            clone.time_until_ad_ticks = original.time_until_ad_ticks;
            clone.time_until_ad_seconds = original.time_until_ad_seconds;
            clone.time_until_ad_minutes = original.time_until_ad_minutes;
            clone.ad_time_until_skip_seconds = original.ad_time_until_skip_seconds;
            clone.tips_enabled = original.tips_enabled;
            clone.captcha_active = original.captcha_active;
            clone.human_number_1 = original.human_number_1;
            clone.human_number_2 = original.human_number_2;
            clone.human_number_3 = original.human_number_3;
            clone.GC_LEVEL = original.GC_LEVEL;
            clone.level_color = original.level_color;
            clone.gc_team_name = original.gc_team_name;
            clone.player_username = original.player_username;
            clone.gc_team_active = original.gc_team_active;
            clone.gc_current_xp = original.gc_current_xp;
            clone.gc_total_xp = original.gc_total_xp;
            clone.max_coins = original.max_coins;
            clone.max_gems = original.max_gems;
            clone.bank_unlocked = original.bank_unlocked;
            clone.coins_in_bank = original.coins_in_bank;
            clone.gems_in_bank = original.gems_in_bank;
            clone.max_coins_in_bank = original.max_coins_in_bank;
            clone.max_gems_in_bank = original.max_gems_in_bank;
            clone.bank_level = original.bank_level;
            clone.ignore_limits_dev = original.ignore_limits_dev;
            clone.know_how_to_play = original.know_how_to_play;
            clone.ignore_cooldowns_dev = original.ignore_cooldowns_dev;
            clone.forgive_claimed = original.forgive_claimed;
            clone.daily_collected = original.daily_collected;
            clone.slot_spins = original.slot_spins;
            clone.daily_reminder_clock = original.daily_reminder_clock;
            clone.daily_reminder_action = original.daily_reminder_action;
            clone.box_chance_logic = original.box_chance_logic;
            clone.duper_cooldown_active = original.duper_cooldown_active;
            clone.duper_cooldown_clock_ticks = original.duper_cooldown_clock_ticks;
            clone.price_multiplier = original.price_multiplier;
            clone.upgrade_price_multiplier_cost = original.upgrade_price_multiplier_cost;
            clone.price_mp_fixed = original.price_mp_fixed;
            clone.rebirths = original.rebirths;
            clone.rebirth_boost = original.rebirth_boost;
            clone.rebirth_notify = original.rebirth_notify;
            clone.debt_to_world_bank = original.debt_to_world_bank;
            clone.debt_timer_ticks = original.debt_timer_ticks;
            clone.debt_timer_seconds = original.debt_timer_seconds;
            clone.bad_debt_timer = original.bad_debt_timer;
            clone.failed_to_repay_debt = original.failed_to_repay_debt;
            clone.is_loaning = original.is_loaning;
            clone.emptix_tokens = original.emptix_tokens;
            clone.lootbox_table_id = original.lootbox_table_id;
            clone.actual_hit = original.actual_hit;
            clone.actual_damage = original.actual_damage;
            clone.mobkill_msg = original.mobkill_msg;
            if (!event.isWasDeath()) {
                clone.combat_log_timer = original.combat_log_timer;
                clone.combat_logged = original.combat_logged;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

