/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.generatorcraft.network;

import java.util.function.Supplier;
import net.mcreator.generatorcraft.GeneratorcraftMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeneratorcraftModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        GeneratorcraftMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handleData);
        GeneratorcraftMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handleData);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int dataType;
        private final SavedData data;

        public SavedDataSyncMessage(int dataType, SavedData data) {
            this.dataType = dataType;
            this.data = data;
        }

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            int dataType = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            SavedData data = null;
            if (nbt != null) {
                SavedData savedData = data = dataType == 0 ? new MapVariables() : new WorldVariables();
                if (data instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)data;
                    mapVariables.read(nbt);
                } else if (data instanceof WorldVariables) {
                    WorldVariables worldVariables = (WorldVariables)data;
                    worldVariables.read(nbt);
                }
            }
            this.dataType = dataType;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.dataType);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handleData(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.dataType == 0) {
                        MapVariables.clientSide.read(message.data.m_7176_(new CompoundTag()));
                    } else {
                        WorldVariables.clientSide.read(message.data.m_7176_(new CompoundTag()));
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public record PlayerVariablesSyncMessage(PlayerVariables data) {
        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this(new PlayerVariables());
            this.data.deserializeNBT(buffer.m_130260_());
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_(message.data().serializeNBT());
        }

        public static void handleData(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES).ifPresent(cap -> cap.deserializeNBT(message.data.serializeNBT()));
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables
    implements INBTSerializable<CompoundTag> {
        boolean _syncDirty = false;
        public double coins = 0.0;
        public double gems = 0.0;
        public boolean ValueOverlayShown = true;
        public double coin_chance = 1.0;
        public double box_chance = 10.0;
        public double coin_multiplier = 1.0;
        public double combat_log_timer = 0.0;
        public boolean combat_logged = false;
        public double held_box_rarity = 0.0;
        public double opened_box_rarity = 0.0;
        public double upgrade_coin_chance_cost = 10.0;
        public double upgrade_box_chance_cost = 500.0;
        public double upgrade_coin_multiplayer_cost = 5000.0;
        public double gem_chance = 0.0;
        public double gem_chance_upgrade_cost = 10000.0;
        public ItemStack gamble_slot_0 = ItemStack.f_41583_;
        public ItemStack gamble_slot_1 = ItemStack.f_41583_;
        public ItemStack gamble_slot_2 = ItemStack.f_41583_;
        public double slots_forgive = 0.0;
        public boolean slots_rolling = false;
        public boolean slots_unlocked = false;
        public double combat_log_time = 100.0;
        public double upgrade_combat_log_time_cost = 500.0;
        public double combat_log_time_seconds = 0.0;
        public boolean debug_overlay_shown = false;
        public ItemStack lootbox_item = ItemStack.f_41583_;
        public boolean watermark_funny = true;
        public double slot_thing = 1.0;
        public double dice_roll = 0.0;
        public boolean is_ad_active_right_now = false;
        public double ad_time_until_skip = 0.0;
        public boolean adblock_enabled = false;
        public boolean can_skip_ad = false;
        public double time_until_ad_ticks = 0.0;
        public double time_until_ad_seconds = 0.0;
        public double time_until_ad_minutes = 0.0;
        public double ad_time_until_skip_seconds = 0.0;
        public boolean tips_enabled = true;
        public boolean captcha_active = false;
        public double human_number_1 = 0.0;
        public double human_number_2 = 0.0;
        public double human_number_3 = 0.0;
        public double GC_LEVEL = 1.0;
        public String level_color = "white";
        public String gc_team_name = "none";
        public String player_username = "\"\"";
        public boolean gc_team_active = false;
        public double gc_current_xp = 1.0;
        public double gc_total_xp = 1.0;
        public double max_coins = 1000.0;
        public double max_gems = 1000.0;
        public boolean bank_unlocked = false;
        public double coins_in_bank = 0.0;
        public double gems_in_bank = 0.0;
        public double max_coins_in_bank = 0.0;
        public double max_gems_in_bank = 0.0;
        public double bank_level = 0.0;
        public boolean ignore_limits_dev = false;
        public boolean know_how_to_play = false;
        public boolean ignore_cooldowns_dev = false;
        public boolean forgive_claimed = false;
        public boolean daily_collected = false;
        public double slot_spins = 0.0;
        public double daily_reminder_clock = 0.0;
        public boolean daily_reminder_action = false;
        public boolean box_chance_logic = true;
        public boolean duper_cooldown_active = false;
        public double duper_cooldown_clock_ticks = 72000.0;
        public double price_multiplier = 1.0;
        public double upgrade_price_multiplier_cost = 0.0;
        public boolean price_mp_fixed = false;
        public double rebirths = 0.0;
        public double rebirth_boost = 0.0;
        public boolean rebirth_notify = false;
        public double debt_to_world_bank = 0.0;
        public double debt_timer_ticks = 0.0;
        public double debt_timer_seconds = 0.0;
        public double bad_debt_timer = 0.0;
        public boolean failed_to_repay_debt = false;
        public boolean is_loaning = false;
        public double emptix_tokens = 0.0;
        public String lootbox_table_id = "\"\"";
        public boolean actual_hit = false;
        public boolean actual_damage = false;
        public boolean mobkill_msg = true;
        public double player_tick_gc_p = 0.0;
        public ItemStack ltbx_rwrd_0 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_1 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_2 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_3 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_4 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_5 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_6 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_7 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_8 = ItemStack.f_41583_;
        public ItemStack ltbx_rwrd_final = ItemStack.f_41583_;
        public boolean ltbx_roll_visible = true;
        public boolean ltbx_rolling = false;
        public ItemStack lootbox_to_remove = ItemStack.f_41583_;
        public double ltbx_ticks = 0.0;
        public double default_lootbox_counter = 0.0;
        public boolean default_lootbox_logic = false;
        public double uncommon_lootbox_counter = 0.0;
        public boolean uncommon_lootbox_logic = false;
        public double rare_lootbox_counter = 0.0;
        public boolean rare_lootbox_logic = false;
        public double epic_lootbox_counter = 0.0;
        public boolean epic_lootbox_logic = false;
        public double legendary_lootbox_counter = 0.0;
        public boolean legendary_lootbox_logic = false;
        public double mythic_lootbox_counter = 0.0;
        public boolean mythic_lootbox_logic = false;
        public double dante_lootbox_counter = 0.0;
        public boolean dante_lootbox_logic = false;
        public double weapon_lootbox_counter = 0.0;
        public boolean weapon_lootbox_logic = false;
        public double corrupted_lootbox_counter = 0.0;
        public boolean corrupted_lootbox_logic = false;
        public double total_lootbox_counter = 0.0;
        public double adskip_random_coins = 0.0;
        public double adskip_random_gems = 0.0;
        public double local_cost_usage = 0.0;
        public ItemStack local_item_usage = ItemStack.f_41583_;
        public BlockState local_broken_block_usage = Blocks.f_50016_.m_49966_();
        public boolean local_good_usage = false;
        public double local_coins_usage = 0.0;
        public double local_amount_uwu_usage = 0.0;
        public double daily_coins = 0.0;
        public double daily_gems = 0.0;
        public double coins_lost = 0.0;
        public double gems_lost = 0.0;
        public double coin_to_drop = 0.0;
        public double gem_to_drop = 0.0;
        public double looting_coins = 0.0;
        public double looting_gems = 0.0;
        public ItemStack local_result_usage = ItemStack.f_41583_;
        public double local_amount_usage = 0.0;
        public double applied_rebirth = 0.0;
        public double random_ad_number = 0.0;

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("coins", this.coins);
            nbt.m_128347_("gems", this.gems);
            nbt.m_128379_("ValueOverlayShown", this.ValueOverlayShown);
            nbt.m_128347_("coin_chance", this.coin_chance);
            nbt.m_128347_("box_chance", this.box_chance);
            nbt.m_128347_("coin_multiplier", this.coin_multiplier);
            nbt.m_128347_("combat_log_timer", this.combat_log_timer);
            nbt.m_128379_("combat_logged", this.combat_logged);
            nbt.m_128347_("held_box_rarity", this.held_box_rarity);
            nbt.m_128347_("opened_box_rarity", this.opened_box_rarity);
            nbt.m_128347_("upgrade_coin_chance_cost", this.upgrade_coin_chance_cost);
            nbt.m_128347_("upgrade_box_chance_cost", this.upgrade_box_chance_cost);
            nbt.m_128347_("upgrade_coin_multiplayer_cost", this.upgrade_coin_multiplayer_cost);
            nbt.m_128347_("gem_chance", this.gem_chance);
            nbt.m_128347_("gem_chance_upgrade_cost", this.gem_chance_upgrade_cost);
            nbt.m_128365_("gamble_slot_0", (Tag)this.gamble_slot_0.m_41739_(new CompoundTag()));
            nbt.m_128365_("gamble_slot_1", (Tag)this.gamble_slot_1.m_41739_(new CompoundTag()));
            nbt.m_128365_("gamble_slot_2", (Tag)this.gamble_slot_2.m_41739_(new CompoundTag()));
            nbt.m_128347_("slots_forgive", this.slots_forgive);
            nbt.m_128379_("slots_rolling", this.slots_rolling);
            nbt.m_128379_("slots_unlocked", this.slots_unlocked);
            nbt.m_128347_("combat_log_time", this.combat_log_time);
            nbt.m_128347_("upgrade_combat_log_time_cost", this.upgrade_combat_log_time_cost);
            nbt.m_128347_("combat_log_time_seconds", this.combat_log_time_seconds);
            nbt.m_128379_("debug_overlay_shown", this.debug_overlay_shown);
            nbt.m_128365_("lootbox_item", (Tag)this.lootbox_item.m_41739_(new CompoundTag()));
            nbt.m_128379_("watermark_funny", this.watermark_funny);
            nbt.m_128347_("slot_thing", this.slot_thing);
            nbt.m_128347_("dice_roll", this.dice_roll);
            nbt.m_128379_("is_ad_active_right_now", this.is_ad_active_right_now);
            nbt.m_128347_("ad_time_until_skip", this.ad_time_until_skip);
            nbt.m_128379_("adblock_enabled", this.adblock_enabled);
            nbt.m_128379_("can_skip_ad", this.can_skip_ad);
            nbt.m_128347_("time_until_ad_ticks", this.time_until_ad_ticks);
            nbt.m_128347_("time_until_ad_seconds", this.time_until_ad_seconds);
            nbt.m_128347_("time_until_ad_minutes", this.time_until_ad_minutes);
            nbt.m_128347_("ad_time_until_skip_seconds", this.ad_time_until_skip_seconds);
            nbt.m_128379_("tips_enabled", this.tips_enabled);
            nbt.m_128379_("captcha_active", this.captcha_active);
            nbt.m_128347_("human_number_1", this.human_number_1);
            nbt.m_128347_("human_number_2", this.human_number_2);
            nbt.m_128347_("human_number_3", this.human_number_3);
            nbt.m_128347_("GC_LEVEL", this.GC_LEVEL);
            nbt.m_128359_("level_color", this.level_color);
            nbt.m_128359_("gc_team_name", this.gc_team_name);
            nbt.m_128359_("player_username", this.player_username);
            nbt.m_128379_("gc_team_active", this.gc_team_active);
            nbt.m_128347_("gc_current_xp", this.gc_current_xp);
            nbt.m_128347_("gc_total_xp", this.gc_total_xp);
            nbt.m_128347_("max_coins", this.max_coins);
            nbt.m_128347_("max_gems", this.max_gems);
            nbt.m_128379_("bank_unlocked", this.bank_unlocked);
            nbt.m_128347_("coins_in_bank", this.coins_in_bank);
            nbt.m_128347_("gems_in_bank", this.gems_in_bank);
            nbt.m_128347_("max_coins_in_bank", this.max_coins_in_bank);
            nbt.m_128347_("max_gems_in_bank", this.max_gems_in_bank);
            nbt.m_128347_("bank_level", this.bank_level);
            nbt.m_128379_("ignore_limits_dev", this.ignore_limits_dev);
            nbt.m_128379_("know_how_to_play", this.know_how_to_play);
            nbt.m_128379_("ignore_cooldowns_dev", this.ignore_cooldowns_dev);
            nbt.m_128379_("forgive_claimed", this.forgive_claimed);
            nbt.m_128379_("daily_collected", this.daily_collected);
            nbt.m_128347_("slot_spins", this.slot_spins);
            nbt.m_128347_("daily_reminder_clock", this.daily_reminder_clock);
            nbt.m_128379_("daily_reminder_action", this.daily_reminder_action);
            nbt.m_128379_("box_chance_logic", this.box_chance_logic);
            nbt.m_128379_("duper_cooldown_active", this.duper_cooldown_active);
            nbt.m_128347_("duper_cooldown_clock_ticks", this.duper_cooldown_clock_ticks);
            nbt.m_128347_("price_multiplier", this.price_multiplier);
            nbt.m_128347_("upgrade_price_multiplier_cost", this.upgrade_price_multiplier_cost);
            nbt.m_128379_("price_mp_fixed", this.price_mp_fixed);
            nbt.m_128347_("rebirths", this.rebirths);
            nbt.m_128347_("rebirth_boost", this.rebirth_boost);
            nbt.m_128379_("rebirth_notify", this.rebirth_notify);
            nbt.m_128347_("debt_to_world_bank", this.debt_to_world_bank);
            nbt.m_128347_("debt_timer_ticks", this.debt_timer_ticks);
            nbt.m_128347_("debt_timer_seconds", this.debt_timer_seconds);
            nbt.m_128347_("bad_debt_timer", this.bad_debt_timer);
            nbt.m_128379_("failed_to_repay_debt", this.failed_to_repay_debt);
            nbt.m_128379_("is_loaning", this.is_loaning);
            nbt.m_128347_("emptix_tokens", this.emptix_tokens);
            nbt.m_128359_("lootbox_table_id", this.lootbox_table_id);
            nbt.m_128379_("actual_hit", this.actual_hit);
            nbt.m_128379_("actual_damage", this.actual_damage);
            nbt.m_128379_("mobkill_msg", this.mobkill_msg);
            nbt.m_128347_("player_tick_gc_p", this.player_tick_gc_p);
            nbt.m_128365_("ltbx_rwrd_0", (Tag)this.ltbx_rwrd_0.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_1", (Tag)this.ltbx_rwrd_1.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_2", (Tag)this.ltbx_rwrd_2.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_3", (Tag)this.ltbx_rwrd_3.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_4", (Tag)this.ltbx_rwrd_4.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_5", (Tag)this.ltbx_rwrd_5.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_6", (Tag)this.ltbx_rwrd_6.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_7", (Tag)this.ltbx_rwrd_7.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_8", (Tag)this.ltbx_rwrd_8.m_41739_(new CompoundTag()));
            nbt.m_128365_("ltbx_rwrd_final", (Tag)this.ltbx_rwrd_final.m_41739_(new CompoundTag()));
            nbt.m_128379_("ltbx_roll_visible", this.ltbx_roll_visible);
            nbt.m_128379_("ltbx_rolling", this.ltbx_rolling);
            nbt.m_128365_("lootbox_to_remove", (Tag)this.lootbox_to_remove.m_41739_(new CompoundTag()));
            nbt.m_128347_("ltbx_ticks", this.ltbx_ticks);
            nbt.m_128347_("default_lootbox_counter", this.default_lootbox_counter);
            nbt.m_128379_("default_lootbox_logic", this.default_lootbox_logic);
            nbt.m_128347_("uncommon_lootbox_counter", this.uncommon_lootbox_counter);
            nbt.m_128379_("uncommon_lootbox_logic", this.uncommon_lootbox_logic);
            nbt.m_128347_("rare_lootbox_counter", this.rare_lootbox_counter);
            nbt.m_128379_("rare_lootbox_logic", this.rare_lootbox_logic);
            nbt.m_128347_("epic_lootbox_counter", this.epic_lootbox_counter);
            nbt.m_128379_("epic_lootbox_logic", this.epic_lootbox_logic);
            nbt.m_128347_("legendary_lootbox_counter", this.legendary_lootbox_counter);
            nbt.m_128379_("legendary_lootbox_logic", this.legendary_lootbox_logic);
            nbt.m_128347_("mythic_lootbox_counter", this.mythic_lootbox_counter);
            nbt.m_128379_("mythic_lootbox_logic", this.mythic_lootbox_logic);
            nbt.m_128347_("dante_lootbox_counter", this.dante_lootbox_counter);
            nbt.m_128379_("dante_lootbox_logic", this.dante_lootbox_logic);
            nbt.m_128347_("weapon_lootbox_counter", this.weapon_lootbox_counter);
            nbt.m_128379_("weapon_lootbox_logic", this.weapon_lootbox_logic);
            nbt.m_128347_("corrupted_lootbox_counter", this.corrupted_lootbox_counter);
            nbt.m_128379_("corrupted_lootbox_logic", this.corrupted_lootbox_logic);
            nbt.m_128347_("total_lootbox_counter", this.total_lootbox_counter);
            nbt.m_128347_("adskip_random_coins", this.adskip_random_coins);
            nbt.m_128347_("adskip_random_gems", this.adskip_random_gems);
            nbt.m_128347_("local_cost_usage", this.local_cost_usage);
            nbt.m_128365_("local_item_usage", (Tag)this.local_item_usage.m_41739_(new CompoundTag()));
            nbt.m_128365_("local_broken_block_usage", (Tag)NbtUtils.m_129202_((BlockState)this.local_broken_block_usage));
            nbt.m_128379_("local_good_usage", this.local_good_usage);
            nbt.m_128347_("local_coins_usage", this.local_coins_usage);
            nbt.m_128347_("local_amount_uwu_usage", this.local_amount_uwu_usage);
            nbt.m_128347_("daily_coins", this.daily_coins);
            nbt.m_128347_("daily_gems", this.daily_gems);
            nbt.m_128347_("coins_lost", this.coins_lost);
            nbt.m_128347_("gems_lost", this.gems_lost);
            nbt.m_128347_("coin_to_drop", this.coin_to_drop);
            nbt.m_128347_("gem_to_drop", this.gem_to_drop);
            nbt.m_128347_("looting_coins", this.looting_coins);
            nbt.m_128347_("looting_gems", this.looting_gems);
            nbt.m_128365_("local_result_usage", (Tag)this.local_result_usage.m_41739_(new CompoundTag()));
            nbt.m_128347_("local_amount_usage", this.local_amount_usage);
            nbt.m_128347_("applied_rebirth", this.applied_rebirth);
            nbt.m_128347_("random_ad_number", this.random_ad_number);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.coins = nbt.m_128459_("coins");
            this.gems = nbt.m_128459_("gems");
            this.ValueOverlayShown = nbt.m_128471_("ValueOverlayShown");
            this.coin_chance = nbt.m_128459_("coin_chance");
            this.box_chance = nbt.m_128459_("box_chance");
            this.coin_multiplier = nbt.m_128459_("coin_multiplier");
            this.combat_log_timer = nbt.m_128459_("combat_log_timer");
            this.combat_logged = nbt.m_128471_("combat_logged");
            this.held_box_rarity = nbt.m_128459_("held_box_rarity");
            this.opened_box_rarity = nbt.m_128459_("opened_box_rarity");
            this.upgrade_coin_chance_cost = nbt.m_128459_("upgrade_coin_chance_cost");
            this.upgrade_box_chance_cost = nbt.m_128459_("upgrade_box_chance_cost");
            this.upgrade_coin_multiplayer_cost = nbt.m_128459_("upgrade_coin_multiplayer_cost");
            this.gem_chance = nbt.m_128459_("gem_chance");
            this.gem_chance_upgrade_cost = nbt.m_128459_("gem_chance_upgrade_cost");
            this.gamble_slot_0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("gamble_slot_0"));
            this.gamble_slot_1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("gamble_slot_1"));
            this.gamble_slot_2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("gamble_slot_2"));
            this.slots_forgive = nbt.m_128459_("slots_forgive");
            this.slots_rolling = nbt.m_128471_("slots_rolling");
            this.slots_unlocked = nbt.m_128471_("slots_unlocked");
            this.combat_log_time = nbt.m_128459_("combat_log_time");
            this.upgrade_combat_log_time_cost = nbt.m_128459_("upgrade_combat_log_time_cost");
            this.combat_log_time_seconds = nbt.m_128459_("combat_log_time_seconds");
            this.debug_overlay_shown = nbt.m_128471_("debug_overlay_shown");
            this.lootbox_item = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("lootbox_item"));
            this.watermark_funny = nbt.m_128471_("watermark_funny");
            this.slot_thing = nbt.m_128459_("slot_thing");
            this.dice_roll = nbt.m_128459_("dice_roll");
            this.is_ad_active_right_now = nbt.m_128471_("is_ad_active_right_now");
            this.ad_time_until_skip = nbt.m_128459_("ad_time_until_skip");
            this.adblock_enabled = nbt.m_128471_("adblock_enabled");
            this.can_skip_ad = nbt.m_128471_("can_skip_ad");
            this.time_until_ad_ticks = nbt.m_128459_("time_until_ad_ticks");
            this.time_until_ad_seconds = nbt.m_128459_("time_until_ad_seconds");
            this.time_until_ad_minutes = nbt.m_128459_("time_until_ad_minutes");
            this.ad_time_until_skip_seconds = nbt.m_128459_("ad_time_until_skip_seconds");
            this.tips_enabled = nbt.m_128471_("tips_enabled");
            this.captcha_active = nbt.m_128471_("captcha_active");
            this.human_number_1 = nbt.m_128459_("human_number_1");
            this.human_number_2 = nbt.m_128459_("human_number_2");
            this.human_number_3 = nbt.m_128459_("human_number_3");
            this.GC_LEVEL = nbt.m_128459_("GC_LEVEL");
            this.level_color = nbt.m_128461_("level_color");
            this.gc_team_name = nbt.m_128461_("gc_team_name");
            this.player_username = nbt.m_128461_("player_username");
            this.gc_team_active = nbt.m_128471_("gc_team_active");
            this.gc_current_xp = nbt.m_128459_("gc_current_xp");
            this.gc_total_xp = nbt.m_128459_("gc_total_xp");
            this.max_coins = nbt.m_128459_("max_coins");
            this.max_gems = nbt.m_128459_("max_gems");
            this.bank_unlocked = nbt.m_128471_("bank_unlocked");
            this.coins_in_bank = nbt.m_128459_("coins_in_bank");
            this.gems_in_bank = nbt.m_128459_("gems_in_bank");
            this.max_coins_in_bank = nbt.m_128459_("max_coins_in_bank");
            this.max_gems_in_bank = nbt.m_128459_("max_gems_in_bank");
            this.bank_level = nbt.m_128459_("bank_level");
            this.ignore_limits_dev = nbt.m_128471_("ignore_limits_dev");
            this.know_how_to_play = nbt.m_128471_("know_how_to_play");
            this.ignore_cooldowns_dev = nbt.m_128471_("ignore_cooldowns_dev");
            this.forgive_claimed = nbt.m_128471_("forgive_claimed");
            this.daily_collected = nbt.m_128471_("daily_collected");
            this.slot_spins = nbt.m_128459_("slot_spins");
            this.daily_reminder_clock = nbt.m_128459_("daily_reminder_clock");
            this.daily_reminder_action = nbt.m_128471_("daily_reminder_action");
            this.box_chance_logic = nbt.m_128471_("box_chance_logic");
            this.duper_cooldown_active = nbt.m_128471_("duper_cooldown_active");
            this.duper_cooldown_clock_ticks = nbt.m_128459_("duper_cooldown_clock_ticks");
            this.price_multiplier = nbt.m_128459_("price_multiplier");
            this.upgrade_price_multiplier_cost = nbt.m_128459_("upgrade_price_multiplier_cost");
            this.price_mp_fixed = nbt.m_128471_("price_mp_fixed");
            this.rebirths = nbt.m_128459_("rebirths");
            this.rebirth_boost = nbt.m_128459_("rebirth_boost");
            this.rebirth_notify = nbt.m_128471_("rebirth_notify");
            this.debt_to_world_bank = nbt.m_128459_("debt_to_world_bank");
            this.debt_timer_ticks = nbt.m_128459_("debt_timer_ticks");
            this.debt_timer_seconds = nbt.m_128459_("debt_timer_seconds");
            this.bad_debt_timer = nbt.m_128459_("bad_debt_timer");
            this.failed_to_repay_debt = nbt.m_128471_("failed_to_repay_debt");
            this.is_loaning = nbt.m_128471_("is_loaning");
            this.emptix_tokens = nbt.m_128459_("emptix_tokens");
            this.lootbox_table_id = nbt.m_128461_("lootbox_table_id");
            this.actual_hit = nbt.m_128471_("actual_hit");
            this.actual_damage = nbt.m_128471_("actual_damage");
            this.mobkill_msg = nbt.m_128471_("mobkill_msg");
            this.player_tick_gc_p = nbt.m_128459_("player_tick_gc_p");
            this.ltbx_rwrd_0 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_0"));
            this.ltbx_rwrd_1 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_1"));
            this.ltbx_rwrd_2 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_2"));
            this.ltbx_rwrd_3 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_3"));
            this.ltbx_rwrd_4 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_4"));
            this.ltbx_rwrd_5 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_5"));
            this.ltbx_rwrd_6 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_6"));
            this.ltbx_rwrd_7 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_7"));
            this.ltbx_rwrd_8 = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_8"));
            this.ltbx_rwrd_final = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ltbx_rwrd_final"));
            this.ltbx_roll_visible = nbt.m_128471_("ltbx_roll_visible");
            this.ltbx_rolling = nbt.m_128471_("ltbx_rolling");
            this.lootbox_to_remove = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("lootbox_to_remove"));
            this.ltbx_ticks = nbt.m_128459_("ltbx_ticks");
            this.default_lootbox_counter = nbt.m_128459_("default_lootbox_counter");
            this.default_lootbox_logic = nbt.m_128471_("default_lootbox_logic");
            this.uncommon_lootbox_counter = nbt.m_128459_("uncommon_lootbox_counter");
            this.uncommon_lootbox_logic = nbt.m_128471_("uncommon_lootbox_logic");
            this.rare_lootbox_counter = nbt.m_128459_("rare_lootbox_counter");
            this.rare_lootbox_logic = nbt.m_128471_("rare_lootbox_logic");
            this.epic_lootbox_counter = nbt.m_128459_("epic_lootbox_counter");
            this.epic_lootbox_logic = nbt.m_128471_("epic_lootbox_logic");
            this.legendary_lootbox_counter = nbt.m_128459_("legendary_lootbox_counter");
            this.legendary_lootbox_logic = nbt.m_128471_("legendary_lootbox_logic");
            this.mythic_lootbox_counter = nbt.m_128459_("mythic_lootbox_counter");
            this.mythic_lootbox_logic = nbt.m_128471_("mythic_lootbox_logic");
            this.dante_lootbox_counter = nbt.m_128459_("dante_lootbox_counter");
            this.dante_lootbox_logic = nbt.m_128471_("dante_lootbox_logic");
            this.weapon_lootbox_counter = nbt.m_128459_("weapon_lootbox_counter");
            this.weapon_lootbox_logic = nbt.m_128471_("weapon_lootbox_logic");
            this.corrupted_lootbox_counter = nbt.m_128459_("corrupted_lootbox_counter");
            this.corrupted_lootbox_logic = nbt.m_128471_("corrupted_lootbox_logic");
            this.total_lootbox_counter = nbt.m_128459_("total_lootbox_counter");
            this.adskip_random_coins = nbt.m_128459_("adskip_random_coins");
            this.adskip_random_gems = nbt.m_128459_("adskip_random_gems");
            this.local_cost_usage = nbt.m_128459_("local_cost_usage");
            this.local_item_usage = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("local_item_usage"));
            this.local_broken_block_usage = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt.m_128469_("local_broken_block_usage"));
            this.local_good_usage = nbt.m_128471_("local_good_usage");
            this.local_coins_usage = nbt.m_128459_("local_coins_usage");
            this.local_amount_uwu_usage = nbt.m_128459_("local_amount_uwu_usage");
            this.daily_coins = nbt.m_128459_("daily_coins");
            this.daily_gems = nbt.m_128459_("daily_gems");
            this.coins_lost = nbt.m_128459_("coins_lost");
            this.gems_lost = nbt.m_128459_("gems_lost");
            this.coin_to_drop = nbt.m_128459_("coin_to_drop");
            this.gem_to_drop = nbt.m_128459_("gem_to_drop");
            this.looting_coins = nbt.m_128459_("looting_coins");
            this.looting_gems = nbt.m_128459_("looting_gems");
            this.local_result_usage = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("local_result_usage"));
            this.local_amount_usage = nbt.m_128459_("local_amount_usage");
            this.applied_rebirth = nbt.m_128459_("applied_rebirth");
            this.random_ad_number = nbt.m_128459_("random_ad_number");
        }

        public void markSyncDirty() {
            this._syncDirty = true;
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"generatorcraft", (String)"player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES ? this.instance.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.playerVariables.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.playerVariables.deserializeNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "generatorcraft_mapvars";
        boolean _syncDirty = false;
        public double gem_multiplier = 1.0;
        public boolean gem_boost_event_active = false;
        public boolean big_gem_bought = false;
        public String big_gem_owner = "\"\"";
        public String big_gem_date = "\"\"";
        public double time_until_tip = 0.0;
        public boolean hoarder_event_active = false;
        public ItemStack hoarder_item = ItemStack.f_41583_;
        public double GC_VERSION = 0.0;
        public double day_of_week = 0.0;
        public double duper_price = 15000.0;
        public double event_timer = 0.0;
        public boolean event_active = false;
        public double active_event_id = 0.0;
        public String active_event_name = "\"\"";
        public boolean emptix_event_active = false;
        public double world_bank = 0.0;
        public double economy_boost = 0.0;
        public String economy_state = "\"\"";
        public boolean world_bank_default = false;
        public double real_price_multiplier = 0.0;
        public double real_output_multiplier = 0.0;
        public boolean corruption_event_active = false;
        public String default_log_intro = "\"\"";
        public boolean gc_mob_spawn = true;
        public double world_tick_gc_p = 0.0;
        public String time_as_text = "\"\"";
        public double event_frequency = 0.0;
        public double event_duration = 0.0;
        public double event_timer_frequency = 0.0;
        public double event_timer_duration = 0.0;
        public boolean do_events_generatorcraft = false;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.gem_multiplier = nbt.m_128459_("gem_multiplier");
            this.gem_boost_event_active = nbt.m_128471_("gem_boost_event_active");
            this.big_gem_bought = nbt.m_128471_("big_gem_bought");
            this.big_gem_owner = nbt.m_128461_("big_gem_owner");
            this.big_gem_date = nbt.m_128461_("big_gem_date");
            this.time_until_tip = nbt.m_128459_("time_until_tip");
            this.hoarder_event_active = nbt.m_128471_("hoarder_event_active");
            this.hoarder_item = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("hoarder_item"));
            this.GC_VERSION = nbt.m_128459_("GC_VERSION");
            this.day_of_week = nbt.m_128459_("day_of_week");
            this.duper_price = nbt.m_128459_("duper_price");
            this.event_timer = nbt.m_128459_("event_timer");
            this.event_active = nbt.m_128471_("event_active");
            this.active_event_id = nbt.m_128459_("active_event_id");
            this.active_event_name = nbt.m_128461_("active_event_name");
            this.emptix_event_active = nbt.m_128471_("emptix_event_active");
            this.world_bank = nbt.m_128459_("world_bank");
            this.economy_boost = nbt.m_128459_("economy_boost");
            this.economy_state = nbt.m_128461_("economy_state");
            this.world_bank_default = nbt.m_128471_("world_bank_default");
            this.real_price_multiplier = nbt.m_128459_("real_price_multiplier");
            this.real_output_multiplier = nbt.m_128459_("real_output_multiplier");
            this.corruption_event_active = nbt.m_128471_("corruption_event_active");
            this.default_log_intro = nbt.m_128461_("default_log_intro");
            this.gc_mob_spawn = nbt.m_128471_("gc_mob_spawn");
            this.world_tick_gc_p = nbt.m_128459_("world_tick_gc_p");
            this.time_as_text = nbt.m_128461_("time_as_text");
            this.event_frequency = nbt.m_128459_("event_frequency");
            this.event_duration = nbt.m_128459_("event_duration");
            this.event_timer_frequency = nbt.m_128459_("event_timer_frequency");
            this.event_timer_duration = nbt.m_128459_("event_timer_duration");
            this.do_events_generatorcraft = nbt.m_128471_("do_events_generatorcraft");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("gem_multiplier", this.gem_multiplier);
            nbt.m_128379_("gem_boost_event_active", this.gem_boost_event_active);
            nbt.m_128379_("big_gem_bought", this.big_gem_bought);
            nbt.m_128359_("big_gem_owner", this.big_gem_owner);
            nbt.m_128359_("big_gem_date", this.big_gem_date);
            nbt.m_128347_("time_until_tip", this.time_until_tip);
            nbt.m_128379_("hoarder_event_active", this.hoarder_event_active);
            nbt.m_128365_("hoarder_item", (Tag)this.hoarder_item.m_41739_(new CompoundTag()));
            nbt.m_128347_("GC_VERSION", this.GC_VERSION);
            nbt.m_128347_("day_of_week", this.day_of_week);
            nbt.m_128347_("duper_price", this.duper_price);
            nbt.m_128347_("event_timer", this.event_timer);
            nbt.m_128379_("event_active", this.event_active);
            nbt.m_128347_("active_event_id", this.active_event_id);
            nbt.m_128359_("active_event_name", this.active_event_name);
            nbt.m_128379_("emptix_event_active", this.emptix_event_active);
            nbt.m_128347_("world_bank", this.world_bank);
            nbt.m_128347_("economy_boost", this.economy_boost);
            nbt.m_128359_("economy_state", this.economy_state);
            nbt.m_128379_("world_bank_default", this.world_bank_default);
            nbt.m_128347_("real_price_multiplier", this.real_price_multiplier);
            nbt.m_128347_("real_output_multiplier", this.real_output_multiplier);
            nbt.m_128379_("corruption_event_active", this.corruption_event_active);
            nbt.m_128359_("default_log_intro", this.default_log_intro);
            nbt.m_128379_("gc_mob_spawn", this.gc_mob_spawn);
            nbt.m_128347_("world_tick_gc_p", this.world_tick_gc_p);
            nbt.m_128359_("time_as_text", this.time_as_text);
            nbt.m_128347_("event_frequency", this.event_frequency);
            nbt.m_128347_("event_duration", this.event_duration);
            nbt.m_128347_("event_timer_frequency", this.event_timer_frequency);
            nbt.m_128347_("event_timer_duration", this.event_timer_duration);
            nbt.m_128379_("do_events_generatorcraft", this.do_events_generatorcraft);
            return nbt;
        }

        public void markSyncDirty() {
            this.m_77762_();
            this._syncDirty = true;
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "generatorcraft_worldvars";
        boolean _syncDirty = false;
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void markSyncDirty() {
            this.m_77762_();
            this._syncDirty = true;
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability)));
            }
        }

        @SubscribeEvent
        public static void onPlayerTickUpdateSyncPlayerVariables(TickEvent.PlayerTickEvent event) {
            Player player;
            if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.getCapability(PLAYER_VARIABLES).ifPresent(capability -> {
                    if (capability._syncDirty) {
                        GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new PlayerVariablesSyncMessage((PlayerVariables)capability));
                        capability._syncDirty = false;
                    }
                });
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            event.getOriginal().getCapability(PLAYER_VARIABLES).ifPresent(original -> event.getEntity().getCapability(PLAYER_VARIABLES).ifPresent(clone -> {
                clone.coins = original.coins;
                clone.gems = original.gems;
                clone.ValueOverlayShown = original.ValueOverlayShown;
                clone.coin_chance = original.coin_chance;
                clone.box_chance = original.box_chance;
                clone.coin_multiplier = original.coin_multiplier;
                clone.held_box_rarity = original.held_box_rarity;
                clone.opened_box_rarity = original.opened_box_rarity;
                clone.upgrade_coin_chance_cost = original.upgrade_coin_chance_cost;
                clone.upgrade_box_chance_cost = original.upgrade_box_chance_cost;
                clone.upgrade_coin_multiplayer_cost = original.upgrade_coin_multiplayer_cost;
                clone.gem_chance = original.gem_chance;
                clone.gem_chance_upgrade_cost = original.gem_chance_upgrade_cost;
                clone.gamble_slot_0 = original.gamble_slot_0;
                clone.gamble_slot_1 = original.gamble_slot_1;
                clone.gamble_slot_2 = original.gamble_slot_2;
                clone.slots_forgive = original.slots_forgive;
                clone.slots_rolling = original.slots_rolling;
                clone.slots_unlocked = original.slots_unlocked;
                clone.combat_log_time = original.combat_log_time;
                clone.upgrade_combat_log_time_cost = original.upgrade_combat_log_time_cost;
                clone.combat_log_time_seconds = original.combat_log_time_seconds;
                clone.debug_overlay_shown = original.debug_overlay_shown;
                clone.lootbox_item = original.lootbox_item;
                clone.watermark_funny = original.watermark_funny;
                clone.slot_thing = original.slot_thing;
                clone.dice_roll = original.dice_roll;
                clone.is_ad_active_right_now = original.is_ad_active_right_now;
                clone.ad_time_until_skip = original.ad_time_until_skip;
                clone.adblock_enabled = original.adblock_enabled;
                clone.can_skip_ad = original.can_skip_ad;
                clone.time_until_ad_ticks = original.time_until_ad_ticks;
                clone.time_until_ad_seconds = original.time_until_ad_seconds;
                clone.time_until_ad_minutes = original.time_until_ad_minutes;
                clone.ad_time_until_skip_seconds = original.ad_time_until_skip_seconds;
                clone.tips_enabled = original.tips_enabled;
                clone.captcha_active = original.captcha_active;
                clone.human_number_1 = original.human_number_1;
                clone.human_number_2 = original.human_number_2;
                clone.human_number_3 = original.human_number_3;
                clone.GC_LEVEL = original.GC_LEVEL;
                clone.level_color = original.level_color;
                clone.gc_team_name = original.gc_team_name;
                clone.player_username = original.player_username;
                clone.gc_team_active = original.gc_team_active;
                clone.gc_current_xp = original.gc_current_xp;
                clone.gc_total_xp = original.gc_total_xp;
                clone.max_coins = original.max_coins;
                clone.max_gems = original.max_gems;
                clone.bank_unlocked = original.bank_unlocked;
                clone.coins_in_bank = original.coins_in_bank;
                clone.gems_in_bank = original.gems_in_bank;
                clone.max_coins_in_bank = original.max_coins_in_bank;
                clone.max_gems_in_bank = original.max_gems_in_bank;
                clone.bank_level = original.bank_level;
                clone.ignore_limits_dev = original.ignore_limits_dev;
                clone.know_how_to_play = original.know_how_to_play;
                clone.ignore_cooldowns_dev = original.ignore_cooldowns_dev;
                clone.forgive_claimed = original.forgive_claimed;
                clone.daily_collected = original.daily_collected;
                clone.slot_spins = original.slot_spins;
                clone.daily_reminder_clock = original.daily_reminder_clock;
                clone.daily_reminder_action = original.daily_reminder_action;
                clone.box_chance_logic = original.box_chance_logic;
                clone.duper_cooldown_active = original.duper_cooldown_active;
                clone.duper_cooldown_clock_ticks = original.duper_cooldown_clock_ticks;
                clone.price_multiplier = original.price_multiplier;
                clone.upgrade_price_multiplier_cost = original.upgrade_price_multiplier_cost;
                clone.price_mp_fixed = original.price_mp_fixed;
                clone.rebirths = original.rebirths;
                clone.rebirth_boost = original.rebirth_boost;
                clone.rebirth_notify = original.rebirth_notify;
                clone.debt_to_world_bank = original.debt_to_world_bank;
                clone.debt_timer_ticks = original.debt_timer_ticks;
                clone.debt_timer_seconds = original.debt_timer_seconds;
                clone.bad_debt_timer = original.bad_debt_timer;
                clone.failed_to_repay_debt = original.failed_to_repay_debt;
                clone.is_loaning = original.is_loaning;
                clone.emptix_tokens = original.emptix_tokens;
                clone.lootbox_table_id = original.lootbox_table_id;
                clone.actual_hit = original.actual_hit;
                clone.actual_damage = original.actual_damage;
                clone.mobkill_msg = original.mobkill_msg;
                clone.player_tick_gc_p = original.player_tick_gc_p;
                clone.ltbx_rwrd_0 = original.ltbx_rwrd_0;
                clone.ltbx_rwrd_1 = original.ltbx_rwrd_1;
                clone.ltbx_rwrd_2 = original.ltbx_rwrd_2;
                clone.ltbx_rwrd_3 = original.ltbx_rwrd_3;
                clone.ltbx_rwrd_4 = original.ltbx_rwrd_4;
                clone.ltbx_rwrd_5 = original.ltbx_rwrd_5;
                clone.ltbx_rwrd_6 = original.ltbx_rwrd_6;
                clone.ltbx_rwrd_7 = original.ltbx_rwrd_7;
                clone.ltbx_rwrd_8 = original.ltbx_rwrd_8;
                clone.ltbx_rwrd_final = original.ltbx_rwrd_final;
                clone.ltbx_roll_visible = original.ltbx_roll_visible;
                clone.ltbx_rolling = original.ltbx_rolling;
                clone.lootbox_to_remove = original.lootbox_to_remove;
                clone.ltbx_ticks = original.ltbx_ticks;
                clone.default_lootbox_counter = original.default_lootbox_counter;
                clone.default_lootbox_logic = original.default_lootbox_logic;
                clone.uncommon_lootbox_counter = original.uncommon_lootbox_counter;
                clone.uncommon_lootbox_logic = original.uncommon_lootbox_logic;
                clone.rare_lootbox_counter = original.rare_lootbox_counter;
                clone.rare_lootbox_logic = original.rare_lootbox_logic;
                clone.epic_lootbox_counter = original.epic_lootbox_counter;
                clone.epic_lootbox_logic = original.epic_lootbox_logic;
                clone.legendary_lootbox_counter = original.legendary_lootbox_counter;
                clone.legendary_lootbox_logic = original.legendary_lootbox_logic;
                clone.mythic_lootbox_counter = original.mythic_lootbox_counter;
                clone.mythic_lootbox_logic = original.mythic_lootbox_logic;
                clone.dante_lootbox_counter = original.dante_lootbox_counter;
                clone.dante_lootbox_logic = original.dante_lootbox_logic;
                clone.weapon_lootbox_counter = original.weapon_lootbox_counter;
                clone.weapon_lootbox_logic = original.weapon_lootbox_logic;
                clone.corrupted_lootbox_counter = original.corrupted_lootbox_counter;
                clone.corrupted_lootbox_logic = original.corrupted_lootbox_logic;
                clone.total_lootbox_counter = original.total_lootbox_counter;
                clone.adskip_random_coins = original.adskip_random_coins;
                clone.adskip_random_gems = original.adskip_random_gems;
                clone.local_cost_usage = original.local_cost_usage;
                clone.local_item_usage = original.local_item_usage;
                clone.local_broken_block_usage = original.local_broken_block_usage;
                clone.local_good_usage = original.local_good_usage;
                clone.local_coins_usage = original.local_coins_usage;
                clone.local_amount_uwu_usage = original.local_amount_uwu_usage;
                clone.daily_coins = original.daily_coins;
                clone.daily_gems = original.daily_gems;
                clone.coins_lost = original.coins_lost;
                clone.gems_lost = original.gems_lost;
                clone.coin_to_drop = original.coin_to_drop;
                clone.gem_to_drop = original.gem_to_drop;
                clone.looting_coins = original.looting_coins;
                clone.looting_gems = original.looting_gems;
                clone.local_result_usage = original.local_result_usage;
                clone.local_amount_usage = original.local_amount_usage;
                clone.applied_rebirth = original.applied_rebirth;
                clone.random_ad_number = original.random_ad_number;
                if (!event.isWasDeath()) {
                    clone.combat_log_timer = original.combat_log_timer;
                    clone.combat_logged = original.combat_logged;
                }
            }));
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                MapVariables mapdata = MapVariables.get((LevelAccessor)player2.m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)player2.m_9236_());
                if (mapdata != null) {
                    GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            ServerPlayer player;
            WorldVariables worlddata;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && (worlddata = WorldVariables.get((LevelAccessor)(player = (ServerPlayer)player2).m_9236_())) != null) {
                GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }

        @SubscribeEvent
        public static void onWorldTick(TickEvent.LevelTickEvent event) {
            Level level;
            if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                WorldVariables worldVariables = WorldVariables.get((LevelAccessor)level2);
                if (worldVariables._syncDirty) {
                    GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((ServerLevel)level2).m_46472_()), (Object)new SavedDataSyncMessage(1, worldVariables));
                    worldVariables._syncDirty = false;
                }
                MapVariables mapVariables = MapVariables.get((LevelAccessor)level2);
                if (mapVariables._syncDirty) {
                    GeneratorcraftMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, mapVariables));
                    mapVariables._syncDirty = false;
                }
            }
        }
    }
}

