/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.moonstone.moonstonemod.client.renderer.MRender;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class BloodBoom {
    public BloodBoom(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, @NotNull Entity entity) {
        float s = entity.tickCount;
        float alp = 1.0f - (float)entity.tickCount / 20.0f;
        if (alp < 0.0f) {
            alp = 0.0f;
        }
        matrices.pushPose();
        this.renderSphere1(matrices, vertexConsumers, 240, s /= 3.0f, alp);
        matrices.popPose();
    }

    public void renderSphere1(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, float s, float a) {
        float radius = s;
        int stacks = 48;
        int slices = 48;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(MRender.translucent());
        for (int i = 0; i < stacks; ++i) {
            float phi0 = (float)Math.PI * ((float)(i + 0) / (float)stacks);
            float phi1 = (float)Math.PI * ((float)(i + 1) / (float)stacks);
            for (int j = 0; j < slices; ++j) {
                float theta0 = (float)Math.PI * 2 * ((float)(j + 0) / (float)slices);
                float theta1 = (float)Math.PI * 2 * ((float)(j + 1) / (float)slices);
                float x0 = radius * (float)Math.sin(phi0) * (float)Math.cos(theta0);
                float y0 = radius * (float)Math.cos(phi0);
                float z0 = radius * (float)Math.sin(phi0) * (float)Math.sin(theta0);
                float x1 = radius * (float)Math.sin(phi0) * (float)Math.cos(theta1);
                float y1 = radius * (float)Math.cos(phi0);
                float z1 = radius * (float)Math.sin(phi0) * (float)Math.sin(theta1);
                float x2 = radius * (float)Math.sin(phi1) * (float)Math.cos(theta1);
                float y2 = radius * (float)Math.cos(phi1);
                float z2 = radius * (float)Math.sin(phi1) * (float)Math.sin(theta1);
                float x3 = radius * (float)Math.sin(phi1) * (float)Math.cos(theta0);
                float y3 = radius * (float)Math.cos(phi1);
                float z3 = radius * (float)Math.sin(phi1) * (float)Math.sin(theta0);
                vertexConsumer.addVertex(matrices.last().pose(), x0, y0, z0).setColor(1.0f, 0.0f, 0.0f, a).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x1, y1, z1).setColor(1.0f, 0.0f, 0.0f, a).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x2, y2, z2).setColor(1.0f, 0.0f, 0.0f, a).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x3, y3, z3).setColor(1.0f, 0.0f, 0.0f, a).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
            }
        }
    }
}

