/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.moonstone.moonstonemod.client.renderer.MRender;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class CircleCubeBoom {
    public CircleCubeBoom(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, @NotNull Entity entity) {
        float alp = 100.0f;
        alp -= (float)entity.tickCount;
        if (alp > 10.0f) {
            alp -= (float)(entity.tickCount * 2);
        }
        if (alp < 0.0f) {
            alp = 0.0f;
        }
        matrices.pushPose();
        this.renderCircle3(matrices, vertexConsumers, light, 0.0f, 0.0f, 0.0f, 1.0f + (float)entity.tickCount / 33.0f, alp /= 100.0f, entity);
        matrices.popPose();
    }

    public void renderCircle3(@NotNull PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float x, float y, float z, float radius, float alp, Entity entity) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer(MRender.lines());
        int verticalSegments = 6;
        int horizontalSegments = 6;
        poseStack.translate(0.0f, 1.0f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees((float)(-entity.tickCount)));
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(-entity.tickCount)));
        for (int i = 0; i < verticalSegments; ++i) {
            float vAngle1 = (float)(Math.PI * (double)i / (double)verticalSegments);
            float vAngle2 = (float)(Math.PI * (double)(i + 1) / (double)verticalSegments);
            for (int j = 0; j < horizontalSegments; ++j) {
                float hAngle1 = (float)(Math.PI * 2 * (double)j / (double)horizontalSegments);
                float hAngle2 = (float)(Math.PI * 2 * (double)(j + 1) / (double)horizontalSegments);
                float x1 = (float)((double)x + (double)radius * Math.sin(vAngle1) * Math.cos(hAngle1));
                float y1 = (float)((double)y + (double)radius * Math.cos(vAngle1));
                float z1 = (float)((double)z + (double)radius * Math.sin(vAngle1) * Math.sin(hAngle1));
                float x2 = (float)((double)x + (double)radius * Math.sin(vAngle1) * Math.cos(hAngle2));
                float y2 = (float)((double)y + (double)radius * Math.cos(vAngle1));
                float z2 = (float)((double)z + (double)radius * Math.sin(vAngle1) * Math.sin(hAngle2));
                float x3 = (float)((double)x + (double)radius * Math.sin(vAngle2) * Math.cos(hAngle1));
                float y3 = (float)((double)y + (double)radius * Math.cos(vAngle2));
                float z3 = (float)((double)z + (double)radius * Math.sin(vAngle2) * Math.sin(hAngle1));
                float x4 = (float)((double)x + (double)radius * Math.sin(vAngle2) * Math.cos(hAngle2));
                float y4 = (float)((double)y + (double)radius * Math.cos(vAngle2));
                float z4 = (float)((double)z + (double)radius * Math.sin(vAngle2) * Math.sin(hAngle2));
                vertexConsumer.addVertex(poseStack.last().pose(), x1, y1, z1).setColor(0.0f, 0.0f, 0.0f, alp).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLight, packedLight).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(poseStack.last().pose(), x2, y2, z2).setColor(0.0f, 0.0f, 0.0f, alp).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLight, packedLight).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(poseStack.last().pose(), x3, y3, z3).setColor(0.0f, 0.0f, 0.0f, alp).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLight, packedLight).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(poseStack.last().pose(), x2, y2, z2).setColor(0.0f, 0.0f, 0.0f, alp).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLight, packedLight).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(poseStack.last().pose(), x3, y3, z3).setColor(0.0f, 0.0f, 0.0f, alp).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLight, packedLight).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(poseStack.last().pose(), x4, y4, z4).setColor(0.0f, 0.0f, 0.0f, alp).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLight, packedLight).setNormal(1.0f, 0.0f, 0.0f);
            }
        }
    }
}

