/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.moonstone.moonstonemod.client.particle.blood;
import com.moonstone.moonstonemod.client.particle.blue;
import com.moonstone.moonstonemod.client.particle.popr;
import com.moonstone.moonstonemod.client.renderer.MRender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME, modid="moonstone")
public final class ParticleRenderer {
    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Vec3 camPos = event.getCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        RenderType renderType = MRender.LIGHTNING;
        VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(renderType);
        Minecraft.getInstance().particleEngine.iterateParticles(particle -> {
            Vec3 offset;
            if (particle instanceof blood) {
                blood blood2 = (blood)((Object)particle);
                poseStack.pushPose();
                offset = particle.getPos().subtract(camPos);
                poseStack.translate(offset.x, offset.y, offset.z);
                ParticleRenderer.setT(poseStack, blood2, consumer);
                poseStack.popPose();
            }
            if (particle instanceof blue) {
                blue blue2 = (blue)((Object)particle);
                poseStack.pushPose();
                offset = particle.getPos().subtract(camPos);
                poseStack.translate(offset.x, offset.y, offset.z);
                blue2.setBlue(poseStack, blue2, consumer);
                poseStack.popPose();
            }
        });
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch(renderType);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void line(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Vec3 camPos = event.getCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        RenderType renderType = MRender.lines();
        VertexConsumer consumer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(renderType);
        Minecraft.getInstance().particleEngine.iterateParticles(particle -> {
            if (particle instanceof popr) {
                popr black = (popr)((Object)particle);
                poseStack.pushPose();
                Vec3 offset = particle.getPos().subtract(camPos);
                poseStack.translate(offset.x, offset.y, offset.z);
                black.renderBlack(poseStack, consumer, 240, 0.0f, 0.0f, 0.0f, black);
                poseStack.popPose();
            }
        });
        Minecraft.getInstance().renderBuffers().bufferSource().endBatch(renderType);
        poseStack.popPose();
    }

    private static void setT(PoseStack matrices, blood entity, VertexConsumer vertexConsumers) {
        matrices.pushPose();
        for (int i = 1; i < entity.getTrailPositions().size(); ++i) {
            Vec3 prevPos = entity.getTrailPositions().get(i - 1);
            Vec3 currPos = entity.getTrailPositions().get(i);
            Vec3 adjustedPrevPos = new Vec3(prevPos.x - entity.getPos().x, prevPos.y - entity.getPos().y, prevPos.z - entity.getPos().z);
            Vec3 adjustedCurrPos = new Vec3(currPos.x - entity.getPos().x, currPos.y - entity.getPos().y, currPos.z - entity.getPos().z);
            float alpha = (float)i / (float)entity.getTrailPositions().size();
            ParticleRenderer.renderBlood(matrices, vertexConsumers, adjustedPrevPos, adjustedCurrPos, alpha, RenderType.lightning(), 0.1f);
        }
        matrices.popPose();
    }

    public static void renderBlood(PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 start, Vec3 end, float a, RenderType renderType, float r) {
        int segmentCount = 8;
        for (int i = 0; i < segmentCount; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segmentCount;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segmentCount;
            double x1 = Math.cos(angle1) * (double)r;
            double z1 = Math.sin(angle1) * (double)r;
            double x2 = Math.cos(angle2) * (double)r;
            double z2 = Math.sin(angle2) * (double)r;
            Vec3 up1 = start.add(x1, 0.0, z1);
            Vec3 up2 = start.add(x2, 0.0, z2);
            Vec3 down1 = end.add(x1, 0.0, z1);
            Vec3 down2 = end.add(x2, 0.0, z2);
            ParticleRenderer.addSquare(vertexConsumer, poseStack, up1, up2, down1, down2, a);
        }
    }

    private static void addSquare(VertexConsumer vertexConsumer, PoseStack poseStack, Vec3 up1, Vec3 up2, Vec3 down1, Vec3 down2, float alpha) {
        vertexConsumer.addVertex(poseStack.last().pose(), (float)up1.x, (float)up1.y, (float)up1.z).setColor(255, 0, 0, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)down1.x, (float)down1.y, (float)down1.z).setColor(255, 0, 0, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)down2.x, (float)down2.y, (float)down2.z).setColor(255, 0, 0, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)up2.x, (float)up2.y, (float)up2.z).setColor(255, 0, 0, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
    }
}

