/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.client.particle;

import com.moonstone.moonstonemod.entity.owner_blood;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class blood
extends TextureSheetParticle {
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public blood(ClientLevel level, double x, double y, double z, float movementX, float movementY, float movementZ) {
        super(level, x, y, z, (double)movementX, (double)movementY, (double)movementZ);
        this.lifetime = 500;
        this.alpha = 0.0f;
    }

    protected int getLightColor(float p_107249_) {
        return 240;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.trailPositions.add(new Vec3(this.x, this.y, this.z));
        if (this.trailPositions.size() > 33) {
            this.trailPositions.removeFirst();
        }
        Vec3 playerPos = this.getPos();
        float range = 16.0f;
        List entities = this.level.getEntitiesOfClass(owner_blood.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (owner_blood ownerBlood : entities) {
            LivingEntity livingEntity = ownerBlood.getTarget();
            if (livingEntity instanceof LivingEntity) {
                LivingEntity living = livingEntity;
                if (living.isAlive()) {
                    this.setv((Entity)living);
                    continue;
                }
                this.setv((Entity)ownerBlood);
                continue;
            }
            this.setv((Entity)ownerBlood);
        }
        this.alpha = 0.0f;
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.remove();
        }
        super.tick();
    }

    public void setv(Entity e) {
        Vec3 targetPos = e.position().add(0.0, 0.0, 0.0);
        Vec3 currentPos = this.getPos();
        Vec3 direction = targetPos.subtract(currentPos).normalize();
        Vec3 currentDirection = new Vec3(this.xd, this.yd, this.zd).normalize();
        double angle = Math.acos(currentDirection.dot(direction)) * 57.29577951308232;
        if (angle > 10.0) {
            double angleLimit = Math.toRadians(10.0);
            Vec3 limitedDirection = currentDirection.scale(Math.cos(angleLimit)).add(direction.normalize().scale(Math.sin(angleLimit)));
            this.setParticleSpeed(limitedDirection.x * 0.5, limitedDirection.y * 0.5, limitedDirection.z * 0.5);
        } else {
            this.setParticleSpeed(direction.x * 0.5, direction.y * 0.5, direction.z * 0.5);
        }
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Provider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            blood particle = new blood(level, x, y, z, (float)xSpeed, (float)ySpeed, (float)zSpeed);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

