/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity;

import com.moonstone.moonstonemod.entity.SwordOfTwelve;
import com.moonstone.moonstonemod.init.moonstoneitem.Effects;
import com.moonstone.moonstonemod.init.moonstoneitem.EntityTs;
import com.moonstone.moonstonemod.init.moonstoneitem.Particles;
import com.ytgld.seeking_immortals.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AtSword
extends SwordOfTwelve {
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();
    private LivingEntity target;
    public int yRot = 0;

    public AtSword(EntityType<? extends AtSword> entityType, Level level) {
        super(entityType, level);
        this.setSoundEvent(SoundEvents.BONE_BLOCK_BREAK);
        this.setXRot(Mth.nextInt((RandomSource)RandomSource.create(), (int)0, (int)360));
    }

    @Override
    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
    }

    @Override
    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    @Override
    public LivingEntity getTarget() {
        return this.target;
    }

    @Override
    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        BlockState blockstate = this.level().getBlockState(new BlockPos(this.getBlockX(), this.getBlockY() - 1, this.getBlockZ()));
        this.level().levelEvent(2001, new BlockPos((int)this.getX(), (int)(this.getY() + 1.0), (int)this.getZ()), Block.getId((BlockState)blockstate));
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        float is = 1.8f;
        Vec3 position = this.position();
        List ess = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(position.x - (double)is, position.y - (double)is, position.z - (double)is, position.x + (double)is, position.y + (double)is, position.z + (double)is));
        for (LivingEntity es : ess) {
            Player player;
            Entity entity;
            if (this.getOwner() == null || !((entity = this.getOwner()) instanceof Player) || es.is((Entity)(player = (Player)entity))) continue;
            es.addEffect(new MobEffectInstance(Effects.dead, 200, 2));
            es.invulnerableTime = 0;
            es.hurt(es.damageSources().mobProjectile((Entity)this, (LivingEntity)player), (float)(player.getAttributeValue(Attributes.ATTACK_DAMAGE) / 10.0 + 1.0));
            this.discard();
        }
    }

    public void addParticles() {
        Vec3 vec3 = this.position();
        int i = this.random.nextIntBetweenInclusive(1, 3);
        for (int j = 0; j < i; ++j) {
            double d0 = 0.4;
            Vec3 vec31 = new Vec3(this.getX() + 0.4 * (this.random.nextGaussian() - this.random.nextGaussian()), this.getY() + 0.4 * (this.random.nextGaussian() - this.random.nextGaussian()), this.getZ() + 0.4 * (this.random.nextGaussian() - this.random.nextGaussian()));
            Vec3 vec32 = vec3.vectorTo(vec31);
            this.level().addParticle((ParticleOptions)ParticleTypes.OMINOUS_SPAWNING, vec3.x(), vec3.y(), vec3.z(), vec32.x(), vec32.y(), vec32.z());
        }
    }

    @Override
    public void playerTouch(Player entity) {
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isNoGravity()) {
            this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
            if (this.trailPositions.size() > 50) {
                this.trailPositions.removeFirst();
            }
            if (this.tickCount >= 190) {
                this.discard();
            }
            float is = 5.0f;
            BlockState blockstate = this.level().getBlockState(new BlockPos(this.getBlockX(), this.getBlockY() - 1, this.getBlockZ()));
            double d0 = this.getX() + (double)Mth.randomBetween((RandomSource)RandomSource.create(), (float)-0.7f, (float)0.7f);
            double d1 = this.getY();
            double d2 = this.getZ() + (double)Mth.randomBetween((RandomSource)RandomSource.create(), (float)-0.7f, (float)0.7f);
            this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
        } else {
            this.addParticles();
            this.setPos(this.position().x, this.position().y + Math.sin((float)this.tickCount / 50.0f) / 40.0, this.position().z);
            if (((Boolean)Config.SERVER.entityParticle.get()).booleanValue() && this.tickCount % 25 == 0) {
                this.level().addParticle((ParticleOptions)Particles.blue.get(), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
            if (this.tickCount >= 600) {
                this.level().explode(this.getOwner(), this.getX(), this.getY(), this.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
                this.discard();
            }
            if (this.target == null || !this.target.isAlive()) {
                this.findNewTarget();
            }
            if (this.target != null && this.tickCount % 5 == 0) {
                AtSword atSword = new AtSword((EntityType<? extends AtSword>)((EntityType)EntityTs.at_sword_entity.get()), this.level());
                atSword.setPos(this.target.position().add((double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-3.0f, (float)3.0f), (double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)6.0f, (float)10.0f), (double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-2.9f, (float)2.9f)));
                if (this.getOwner() != null) {
                    atSword.setOwner(this.getOwner());
                }
                this.target.level().addFreshEntity((Entity)atSword);
            }
        }
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            OwnableEntity tamableAnimal;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (this.getOwner() == null || entity instanceof OwnableEntity && (tamableAnimal = (OwnableEntity)entity).getOwner() != null && tamableAnimal.getOwner().equals((Object)this.getOwner()) || name.getNamespace().equals("moonstone") || entity.is(this.getOwner()) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }
}

