/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity;

import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.init.items.BookItems;
import com.moonstone.moonstonemod.init.items.Items;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class blood
extends ThrowableItemProjectile {
    private LivingEntity target;
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public blood(EntityType<? extends blood> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    protected Item getDefaultItem() {
        return (Item)Items.blood.get();
    }

    @NotNull
    public ItemStack getItem() {
        return ((Item)Items.blood.get()).getDefaultInstance();
    }

    public float getXRot() {
        return 0.0f;
    }

    public float getYRot() {
        return 0.0f;
    }

    public void tick() {
        super.tick();
        if (!this.getTags().contains("Blood")) {
            if (this.tickCount % 100 == 0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ELYTRA_FLYING, SoundSource.NEUTRAL, 0.31f, 0.31f);
            }
            if (this.target == null || !this.target.isAlive()) {
                this.findNewTarget();
            }
            float s = (float)this.tickCount / 500.0f;
            if (this.target != null && this.tickCount > 25) {
                Vec3 targetPos = this.target.position().add(0.0, 0.5, 0.0);
                Vec3 currentPos = this.position();
                Vec3 direction = targetPos.subtract(currentPos).normalize();
                this.setDeltaMovement(direction.x * (double)(0.005f + s), direction.y * (double)(0.005f + s), direction.z * (double)(0.005f + s));
            }
        } else if (this.tickCount > 5) {
            this.discard();
        }
        this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        if (this.trailPositions.size() > 50) {
            this.trailPositions.removeFirst();
        }
        this.setNoGravity(true);
        this.setYRot(0.0f);
        this.setXRot(0.0f);
    }

    public void playerTouch(@NotNull Player entity) {
        if (this.tickCount > 20) {
            Entity entity2;
            super.playerTouch(entity);
            entity.addItem(new ItemStack((ItemLike)Items.blood.get()));
            this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (Holder)SoundEvents.RESPAWN_ANCHOR_DEPLETE, SoundSource.NEUTRAL, 1.45f, 1.45f);
            if (Handler.hascurio((LivingEntity)entity, (Item)Items.deceased_contract.get())) {
                entity.heal(entity.getMaxHealth() * 0.15f);
            }
            if (this.getOwner() != null && (entity2 = this.getOwner()) instanceof Player) {
                Player player = (Player)entity2;
                if (Handler.hascurio((LivingEntity)player, (Item)BookItems.bloodstain.get())) {
                    player.level().explode((Entity)player, player.getX(), player.getY(), player.getZ(), 3.5f, false, Level.ExplosionInteraction.NONE);
                }
                if (Handler.hascurio((LivingEntity)player, (Item)BookItems.spore_outbreak.get())) {
                    player.heal(player.getMaxHealth() / 5.0f);
                }
                if (Handler.hascurio((LivingEntity)player, (Item)BookItems.weak.get())) {
                    player.hurt(player.damageSources().dryOut(), player.getMaxHealth() / 10.0f);
                    player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 200, 2));
                }
            }
            this.discard();
        }
    }

    private void findNewTarget() {
        Entity entity = this.getOwner();
        if (entity instanceof LivingEntity) {
            LivingEntity living;
            this.target = living = (LivingEntity)entity;
        }
    }
}

