/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.bloodvruis;

import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.entity.bloodvruis.blood_orb_attack;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.moonstoneitem.EntityTs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class blood_orb_owner
extends TamableAnimal {
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public blood_orb_owner(EntityType<? extends blood_orb_owner> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setNoGravity(true);
    }

    public void die(@NotNull DamageSource p_21809_) {
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    public void tick() {
        LivingEntity livingEntity;
        Player player;
        Mob mob2;
        super.tick();
        this.setNoGravity(true);
        this.setXRot(0.0f);
        this.setYRot(0.0f);
        LivingEntity owner = this.getOwner();
        LivingEntity target = this.getTarget();
        this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        if (this.trailPositions.size() > 66) {
            this.trailPositions.removeFirst();
        }
        Vec3 currentPos = this.position();
        if (target != null) {
            target.addEffect(new MobEffectInstance(MobEffects.GLOWING, 10, 2, false, false));
            Vec3 targetPos = target.position().add(0.0, 0.5, 0.0);
            Vec3 direction = targetPos.subtract(currentPos).normalize();
            this.setDeltaMovement(direction.x * 0.5750000029802322, direction.y * 0.5750000029802322, direction.z * 0.5750000029802322);
        }
        if (owner != null) {
            float yRot = owner.getYRot();
            float xRot = owner.getXRot();
            this.setXRot(xRot);
            this.setYRot(yRot);
            double desiredDistance = 2.0;
            Vec3 targetPos = owner.position().add(0.0, 3.0, 0.0);
            Vec3 forward = owner.getLookAngle();
            Vec3 direction = forward.scale(-1.0).normalize();
            Vec3 newTargetPos = targetPos.add(direction.scale(desiredDistance));
            this.setDeltaMovement(newTargetPos.subtract(currentPos).normalize().scale((double)0.15f));
        }
        Vec3 playerPos = this.position().add(0.0, 0.75, 0.0);
        int range = 20;
        List entities = this.level().getEntitiesOfClass(Mob.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (Mob mob2 : entities) {
            ResourceLocation entity;
            if (this.getTarget() != null || (entity = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob2.getType())).getNamespace().equals("moonstone")) continue;
            this.setTarget((LivingEntity)mob2);
        }
        if (this.getTarget() != null && !this.getTarget().isAlive()) {
            this.setTarget(null);
        }
        if (this.getOwner() != null) {
            if (this.getOwner().getLastHurtByMob() != null && !this.getOwner().getLastHurtByMob().is((Entity)this)) {
                this.setTarget(this.getOwner().getLastHurtByMob());
            }
            if (this.getOwner().getLastAttacker() != null && !this.getOwner().getLastAttacker().is((Entity)this)) {
                this.setTarget(this.getOwner().getLastAttacker());
            }
            if (this.getOwner().getLastHurtMob() != null && !this.getOwner().getLastHurtMob().is((Entity)this)) {
                this.setTarget(this.getOwner().getLastHurtMob());
            }
        }
        if (this.getTarget() != null && (mob2 = this.getOwner()) instanceof Player) {
            player = (Player)mob2;
            if (this.tickCount % 100 == 0) {
                blood_orb_attack attack_blood2 = new blood_orb_attack((EntityType<? extends blood_orb_attack>)((EntityType)EntityTs.blood_orb_attack.get()), this.level());
                attack_blood2.setPos(this.position());
                attack_blood2.setOwner((Entity)this.getOwner());
                this.level().addFreshEntity((Entity)attack_blood2);
                this.playRemoveOneSound((Entity)this);
            }
        }
        if (this.getOwner() != null && (livingEntity = this.getOwner()) instanceof Player && !Handler.hascurio((LivingEntity)(player = (Player)livingEntity), (Item)Items.evil_blood.get())) {
            this.discard();
        }
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound(SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, 1.8f, 1.8f);
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected void doPush(Entity p_27415_) {
    }

    protected void pushEntities() {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uuid;
        blood_orb_owner wolf2 = (blood_orb_owner)((EntityType)EntityTs.blood_orb_owner.get()).create((Level)serverLevel);
        if (wolf2 != null && (uuid = this.getOwnerUUID()) != null) {
            wolf2.setOwnerUUID(uuid);
            wolf2.setTame(true, true);
        }
        return wolf2;
    }
}

