/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.bloodvruis;

import com.moonstone.moonstonemod.init.items.Items;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class blood_orb_small
extends ThrowableItemProjectile {
    private LivingEntity target;
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public blood_orb_small(EntityType<? extends blood_orb_small> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    protected Item getDefaultItem() {
        return (Item)Items.blood.get();
    }

    @NotNull
    public ItemStack getItem() {
        return ((Item)Items.blood.get()).getDefaultInstance();
    }

    public float getXRot() {
        return 0.0f;
    }

    public float getYRot() {
        return 0.0f;
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound((SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), 0.5f, 0.5f);
    }

    public void tick() {
        super.tick();
        Vec3 playerPos = this.position().add(0.0, 0.75, 0.0);
        boolean range = true;
        List entities = this.level().getEntitiesOfClass(Mob.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (Mob entity : entities) {
            Entity entity2;
            if (this.getOwner() == null || entity.is(this.getOwner()) || !((entity2 = this.getOwner()) instanceof Player)) continue;
            Player player = (Player)entity2;
            ResourceLocation entitys = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (entitys.getNamespace().equals("moonstone")) continue;
            entity.invulnerableTime = 0;
            entity.hurt(this.getOwner().damageSources().dryOut(), 5.0f + player.getMaxHealth() / 4.0f);
            this.playRemoveOneSound((Entity)this);
            this.discard();
        }
        if (this.tickCount > 200) {
            this.discard();
        }
        if (this.target != null && !this.target.isAlive()) {
            this.target = null;
        }
        if (this.tickCount > 3 && this.tickCount < 7 && this.target == null) {
            this.discard();
        }
        if (this.target == null || !this.target.isAlive()) {
            this.findNewTarget();
        }
        float s = (float)this.tickCount / 88.0f;
        if (this.target != null) {
            Vec3 targetPos = this.target.position().add(0.0, 0.5, 0.0);
            Vec3 currentPos = this.position();
            Vec3 direction = targetPos.subtract(currentPos).normalize();
            this.setDeltaMovement(direction.x * (double)(0.005f + s), direction.y * (double)(0.005f + s), direction.z * (double)(0.005f + s));
        }
        this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        if (this.trailPositions.size() > 10) {
            this.trailPositions.removeFirst();
        }
        this.setNoGravity(true);
        this.setYRot(0.0f);
        this.setXRot(0.0f);
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(12.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (this.getOwner() == null || name.getNamespace().equals("moonstone") || entity.is(this.getOwner()) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }
}

