/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.client.blood;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.client.renderer.MRender;
import com.moonstone.moonstonemod.entity.bloodvruis.blood_orb_attack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BloodOrbAttack
extends EntityRenderer<blood_orb_attack> {
    public BloodOrbAttack(EntityRendererProvider.Context p_173917_) {
        super(p_173917_);
    }

    public void render(blood_orb_attack entity, float p_114486_, float p_114487_, PoseStack poseStack, MultiBufferSource bufferSource, int p_114490_) {
        this.setT(poseStack, entity, bufferSource);
        this.renderSphere1(poseStack, bufferSource, 240, 0.3f);
        super.render((Entity)entity, p_114486_, p_114487_, poseStack, bufferSource, p_114490_);
    }

    private void setT(PoseStack matrices, blood_orb_attack entity, MultiBufferSource vertexConsumers) {
        matrices.pushPose();
        for (int i = 1; i < entity.getTrailPositions().size(); ++i) {
            Vec3 prevPos = entity.getTrailPositions().get(i - 1);
            Vec3 currPos = entity.getTrailPositions().get(i);
            Vec3 adjustedPrevPos = new Vec3(prevPos.x - entity.getX(), prevPos.y - entity.getY(), prevPos.z - entity.getZ());
            Vec3 adjustedCurrPos = new Vec3(currPos.x - entity.getX(), currPos.y - entity.getY(), currPos.z - entity.getZ());
            float alpha = (float)i / (float)entity.getTrailPositions().size();
            Handler.renderColor(matrices, vertexConsumers, adjustedPrevPos, adjustedCurrPos, alpha, RenderType.lightning(), 0.2f, 128, 0, 128);
        }
        matrices.popPose();
    }

    public void renderSphere1(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, float s) {
        int stacks = 20;
        int slices = 20;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(MRender.ging());
        for (int i = 0; i < stacks; ++i) {
            float phi0 = (float)Math.PI * ((float)(i + 0) / (float)stacks);
            float phi1 = (float)Math.PI * ((float)(i + 1) / (float)stacks);
            for (int j = 0; j < slices; ++j) {
                float theta0 = (float)Math.PI * 2 * ((float)(j + 0) / (float)slices);
                float theta1 = (float)Math.PI * 2 * ((float)(j + 1) / (float)slices);
                float x0 = s * (float)Math.sin(phi0) * (float)Math.cos(theta0);
                float y0 = s * (float)Math.cos(phi0);
                float z0 = s * (float)Math.sin(phi0) * (float)Math.sin(theta0);
                float x1 = s * (float)Math.sin(phi0) * (float)Math.cos(theta1);
                float y1 = s * (float)Math.cos(phi0);
                float z1 = s * (float)Math.sin(phi0) * (float)Math.sin(theta1);
                float x2 = s * (float)Math.sin(phi1) * (float)Math.cos(theta1);
                float y2 = s * (float)Math.cos(phi1);
                float z2 = s * (float)Math.sin(phi1) * (float)Math.sin(theta1);
                float x3 = s * (float)Math.sin(phi1) * (float)Math.cos(theta0);
                float y3 = s * (float)Math.cos(phi1);
                float z3 = s * (float)Math.sin(phi1) * (float)Math.sin(theta0);
                vertexConsumer.addVertex(matrices.last().pose(), x0, y0, z0).setColor(1.0f, 1.0f, 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x1, y1, z1).setColor(1.0f, 1.0f, 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x2, y2, z2).setColor(1.0f, 1.0f, 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                vertexConsumer.addVertex(matrices.last().pose(), x3, y3, z3).setColor(1.0f, 1.0f, 1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
            }
        }
    }

    public ResourceLocation getTextureLocation(blood_orb_attack p_114482_) {
        return ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/entity/flysword.png");
    }
}

