/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.extend;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.init.items.BookItems;
import com.moonstone.moonstonemod.init.moonstoneitem.Effects;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class MoonTamableAnimal
extends TamableAnimal {
    public int time;

    protected MoonTamableAnimal(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
    }

    public void die(@NotNull DamageSource cause) {
        LivingEntity livingEntity;
        if (this.getOwner() != null && (livingEntity = this.getOwner()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.getTags().contains("blood_stasisTAG")) {
                player.heal(player.getMaxHealth() / 10.0f);
            }
        }
    }

    public boolean doHurtTarget(Entity entity) {
        Player player;
        LivingEntity livingEntity;
        if (this.getOwner() != null && (livingEntity = this.getOwner()) instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)livingEntity), (Item)BookItems.plague_book.get()) && this.getTarget() != null) {
            this.getTarget().addEffect(new MobEffectInstance(Effects.fear, 200, 0));
        }
        return super.doHurtTarget(entity);
    }

    public void tick() {
        LivingEntity livingEntity;
        super.tick();
        if (this.tickCount <= 10) {
            this.heal(1000.0f);
        }
        if (this.getOwner() != null && this.getTarget() != null && this.getTarget().is((Entity)this.getOwner())) {
            this.setTarget(null);
        }
        if (this.getOwner() != null && (livingEntity = this.getOwner()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (Handler.hascurio((LivingEntity)player, (Item)BookItems.detect.get()) && this.getTarget() != null && !this.getTarget().is((Entity)this.getOwner())) {
                this.getTarget().addEffect(new MobEffectInstance(MobEffects.GLOWING, 100, 0));
            }
            if (Handler.hascurio((LivingEntity)player, (Item)BookItems.exercise_reinforcement.get())) {
                this.getAttributes().addTransientAttributeModifiers(this.moveTag(player));
            }
        }
        if (this.getTags().contains("tumourTAG")) {
            this.getAttributes().addTransientAttributeModifiers(this.tumourTAG());
        }
        if (this.getTags().contains("bone_structureTAG")) {
            this.getAttributes().addTransientAttributeModifiers(this.bone_structureTAG(this.getOwner()));
        }
        if (this.getTags().contains("mummificationTAG")) {
            this.getAttributes().addTransientAttributeModifiers(this.mummificationTAG());
        }
        if (this.getTags().contains("mummificationTAG") && this.tickCount % 2 == 1) {
            --this.time;
        }
        if (this.getTags().contains("organizational_regenerationTAG") && this.tickCount % 5 == 1) {
            this.heal(1.0f);
            ++this.time;
        }
    }

    private Multimap<Holder<Attribute>, AttributeModifier> tumourTAG() {
        HashMultimap modifierMultimap = HashMultimap.create();
        modifierMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagetumour"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        modifierMultimap.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagetumour"), 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return modifierMultimap;
    }

    private Multimap<Holder<Attribute>, AttributeModifier> bone_structureTAG(LivingEntity owner) {
        HashMultimap modifierMultimap = HashMultimap.create();
        if (owner != null) {
            modifierMultimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagebone_structure"), owner.getAttributeValue(Attributes.ARMOR) * (double)0.7f, AttributeModifier.Operation.ADD_VALUE));
            modifierMultimap.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagebone_structure"), owner.getAttributeValue(Attributes.MAX_HEALTH) * (double)0.3f, AttributeModifier.Operation.ADD_VALUE));
        }
        return modifierMultimap;
    }

    private Multimap<Holder<Attribute>, AttributeModifier> mummificationTAG() {
        HashMultimap modifierMultimap = HashMultimap.create();
        modifierMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagemummification"), -0.2, AttributeModifier.Operation.ADD_VALUE));
        return modifierMultimap;
    }

    private Multimap<Holder<Attribute>, AttributeModifier> moveTag(Player player) {
        HashMultimap modifierMultimap = HashMultimap.create();
        modifierMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damageexercise_reinforcement"), player.getAttributeValue(Attributes.MOVEMENT_SPEED) * (double)0.6f, AttributeModifier.Operation.ADD_VALUE));
        return modifierMultimap;
    }
}

