/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.nightmare;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.moonstone.moonstonemod.entity.nightmare.Emerging;
import com.moonstone.moonstonemod.entity.nightmare.SetRoarTarget;
import com.moonstone.moonstonemod.entity.nightmare.SonicBoom;
import com.moonstone.moonstonemod.entity.nightmare.nightmare_giant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.warden.SetWardenLookTarget;
import net.minecraft.world.entity.ai.behavior.warden.TryToSniff;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class AInightmare {
    public static final int EMERGE_DURATION = Mth.ceil((float)133.59999f);
    public static final int ROAR_DURATION = Mth.ceil((float)84.0f);
    private static final List<SensorType<? extends Sensor<? super nightmare_giant>>> SENSOR_TYPES = List.of(SensorType.NEAREST_PLAYERS);
    private static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.ROAR_TARGET, MemoryModuleType.DISTURBANCE_LOCATION, MemoryModuleType.RECENT_PROJECTILE, MemoryModuleType.IS_SNIFFING, MemoryModuleType.IS_EMERGING, MemoryModuleType.ROAR_SOUND_DELAY, MemoryModuleType.DIG_COOLDOWN, MemoryModuleType.ROAR_SOUND_COOLDOWN, MemoryModuleType.SNIFF_COOLDOWN, MemoryModuleType.TOUCH_COOLDOWN, MemoryModuleType.VIBRATION_COOLDOWN, MemoryModuleType.SONIC_BOOM_COOLDOWN, MemoryModuleType.SONIC_BOOM_SOUND_COOLDOWN, MemoryModuleType.SONIC_BOOM_SOUND_DELAY);
    private static final BehaviorControl<nightmare_giant> DIG_COOLDOWN_SETTER = BehaviorBuilder.create(p_258953_ -> p_258953_.group((App)p_258953_.registered(MemoryModuleType.DIG_COOLDOWN)).apply((Applicative)p_258953_, p_258960_ -> (p_258956_, p_258957_, p_258958_) -> {
        if (p_258953_.tryGet(p_258960_).isPresent()) {
            p_258960_.setWithExpiry((Object)Unit.INSTANCE, 1200L);
        }
        return true;
    }));

    public static void updateActivity(nightmare_giant p_219513_) {
        p_219513_.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.EMERGE, (Object)Activity.DIG, (Object)Activity.ROAR, (Object)Activity.FIGHT, (Object)Activity.INVESTIGATE, (Object)Activity.SNIFF, (Object)Activity.IDLE));
    }

    public static Brain<?> makeBrain(nightmare_giant p_219521_, Dynamic<?> p_219522_) {
        Brain.Provider provider = Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
        Brain brain2 = provider.makeBrain(p_219522_);
        AInightmare.initCoreActivity((Brain<nightmare_giant>)brain2);
        AInightmare.initEmergeActivity((Brain<nightmare_giant>)brain2);
        AInightmare.initIdleActivity((Brain<nightmare_giant>)brain2);
        AInightmare.initFightActivity(p_219521_, (Brain<nightmare_giant>)brain2);
        AInightmare.initInvestigateActivity((Brain<nightmare_giant>)brain2);
        brain2.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain2.setDefaultActivity(Activity.IDLE);
        brain2.useDefaultActivity();
        return brain2;
    }

    private static void initCoreActivity(Brain<nightmare_giant> p_219511_) {
        p_219511_.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)SetWardenLookTarget.create(), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initEmergeActivity(Brain<nightmare_giant> p_219527_) {
        p_219527_.addActivityAndRemoveMemoryWhenStopped(Activity.EMERGE, 5, ImmutableList.of(new Emerging(EMERGE_DURATION)), MemoryModuleType.IS_EMERGING);
    }

    private static void initIdleActivity(Brain<nightmare_giant> p_219537_) {
        p_219537_.addActivity(Activity.IDLE, 10, ImmutableList.of(SetRoarTarget.create(nightmare_giant::getEntityAngryAt), (Object)TryToSniff.create(), (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.IS_SNIFFING, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.stroll((float)0.5f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))));
    }

    private static void initInvestigateActivity(Brain<nightmare_giant> p_219542_) {
        p_219542_.addActivityAndRemoveMemoryWhenStopped(Activity.INVESTIGATE, 5, ImmutableList.of(SetRoarTarget.create(nightmare_giant::getEntityAngryAt), (Object)GoToTargetLocation.create((MemoryModuleType)MemoryModuleType.DISTURBANCE_LOCATION, (int)2, (float)0.7f)), MemoryModuleType.DISTURBANCE_LOCATION);
    }

    private static void initFightActivity(nightmare_giant p_219518_, Brain<nightmare_giant> p_219519_) {
        p_219519_.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)((Object)new SonicBoom())), MemoryModuleType.ATTACK_TARGET);
    }

    public static void setDigCooldown(LivingEntity p_219506_) {
        if (p_219506_.getBrain().hasMemoryValue(MemoryModuleType.DIG_COOLDOWN)) {
            p_219506_.getBrain().setMemoryWithExpiry(MemoryModuleType.DIG_COOLDOWN, (Object)Unit.INSTANCE, 1200L);
        }
    }

    public static void setDisturbanceLocation(nightmare_giant p_219524_, BlockPos p_219525_) {
        if (p_219524_.level().getWorldBorder().isWithinBounds(p_219525_) && !p_219524_.getEntityAngryAt().isPresent()) {
            AInightmare.setDigCooldown((LivingEntity)p_219524_);
            p_219524_.getBrain().setMemoryWithExpiry(MemoryModuleType.SNIFF_COOLDOWN, (Object)Unit.INSTANCE, 100L);
            p_219524_.getBrain().setMemoryWithExpiry(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(p_219525_), 100L);
            p_219524_.getBrain().setMemoryWithExpiry(MemoryModuleType.DISTURBANCE_LOCATION, (Object)p_219525_, 100L);
            p_219524_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        }
    }
}

