/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.nightmare;

import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.entity.zombie.cell_zombie;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.moonstoneitem.Particles;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class nightmare_entity
extends cell_zombie {
    private float clientSideAttackTime = 0.0f;
    public int time = 0;

    public nightmare_entity(EntityType<? extends nightmare_entity> p_27412_, Level p_27413_) {
        super((EntityType<? extends cell_zombie>)p_27412_, p_27413_);
        this.setNoAi(true);
    }

    public boolean isPushable() {
        return false;
    }

    public float getAttackAnimationScale(float p_32813_) {
        return (this.clientSideAttackTime + p_32813_) / 80.0f;
    }

    @Override
    public void tick() {
        Level level;
        super.tick();
        ++this.time;
        if (this.time < 10 && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SONIC_BOOM, this.getX(), this.getY() + 1.0, this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        }
        if (this.time > 360) {
            this.level().explode((Entity)this, this.getX(), this.getY() + 1.0, this.getZ(), 1.0f, Level.ExplosionInteraction.NONE);
            this.discard();
        } else if (this.time >= 280 || this.time % 130 == 0) {
            // empty if block
        }
        if (!this.level().isClientSide) {
            Vec3 position = this.position();
            int is = 8;
            List ess = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(position.x - (double)is, position.y - (double)is, position.z - (double)is, position.x + (double)is, position.y + (double)is, position.z + (double)is));
            for (LivingEntity es : ess) {
                Vec3 motion = position.subtract(es.position().add(0.0, (double)(es.getBbHeight() / 2.0f), 0.0));
                if (Math.sqrt(motion.x * motion.x + motion.y * motion.y + motion.z * motion.z) > 1.0) {
                    motion = motion.normalize();
                }
                if (Handler.hascurio(es, (Item)Items.nightmare_heart.get())) continue;
                es.setDeltaMovement(motion.scale(0.1));
            }
            Vec3 playerPos = this.position();
            int range = 12;
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            for (LivingEntity livingentity : entities) {
                if (livingentity.is((Entity)this)) continue;
                if (this.clientSideAttackTime < 80.0f) {
                    this.clientSideAttackTime += 1.0f;
                }
                double d5 = this.getAttackAnimationScale(0.0f);
                double d0 = livingentity.getX() - this.getX();
                double d1 = livingentity.getY(0.5) - this.getEyeY();
                double d2 = livingentity.getZ() - this.getZ();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d0 /= d3;
                d1 /= d3;
                d2 /= d3;
                for (double d4 = this.getRandom().nextDouble(); d4 < d3; d4 += 1.8 - d5 + this.getRandom().nextDouble() * (1.7 - d5)) {
                    Level level2 = this.level();
                    if (!(level2 instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level2;
                    if (Handler.hascurio(livingentity, (Item)Items.nightmare_heart.get()) || livingentity.is((Entity)this) || this.tickCount % 20 != 0) continue;
                    serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)Particles.gold.get()), this.getX() + d0 * d4, this.getEyeY() + 0.75 + d1 * d4, this.getZ() + d2 * d4, 2, 0.0, 0.0, 0.0, 0.0);
                }
                if (Handler.hascurio(livingentity, (Item)Items.nightmare_heart.get()) || livingentity.is((Entity)this) || this.tickCount % 20 != 0) continue;
                livingentity.hurt(livingentity.damageSources().magic(), 3.0f + livingentity.getMaxHealth() / 50.0f);
                livingentity.invulnerableTime = 0;
            }
        }
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    @Override
    public boolean hurt(DamageSource p_27424_, float p_27425_) {
        return false;
    }
}

