/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity;

import com.moonstone.moonstonemod.init.moonstoneitem.EntityTs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class snake
extends TamableAnimal {
    private LivingEntity target;
    private int cloudTime = 0;
    private int time = 0;
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public snake(EntityType<? extends snake> p_27412_, Level p_27413_) {
        super(p_27412_, p_27413_);
    }

    public float getXRot() {
        return 0.0f;
    }

    public float getYRot() {
        return 0.0f;
    }

    public void tick() {
        Object object;
        super.tick();
        ++this.time;
        if (this.time > 300) {
            this.discard();
        }
        if (this.cloudTime > 0) {
            --this.cloudTime;
        }
        this.teleportTo(this.getX(), this.getY() + Math.sin((float)this.time / 20.0f) / 20.0, this.getZ());
        Vec3 playerPos = this.position().add(0.0, 0.75, 0.0);
        boolean range = true;
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        if (this.getOwner() != null && (object = this.getOwner()) instanceof Player) {
            Player player = (Player)object;
            for (LivingEntity living : entities) {
                if (this.target == null || !living.is((Entity)this.target) || player.getAttribute(Attributes.ATTACK_DAMAGE) == null || this.cloudTime > 0) continue;
                this.cloudTime = 15;
                float dam = (float)player.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
                living.invulnerableTime = 0;
                living.hurt(living.damageSources().mobAttack((LivingEntity)this), dam *= 1.5f);
                if (this.time <= 15) continue;
                this.discard();
            }
        }
        if (this.target == null || !this.target.isAlive()) {
            this.findNewTarget();
        }
        if (this.target != null && this.cloudTime <= 0) {
            Vec3 targetPos = this.target.position().add(0.0, 0.5, 0.0);
            Vec3 currentPos = this.position();
            Vec3 direction = targetPos.subtract(currentPos).normalize();
            Vec3 currentDirection = this.getDeltaMovement().normalize();
            double angle = Math.acos(currentDirection.dot(direction)) * 57.29577951308232;
            if (angle > 14.0) {
                double angleLimit = Math.toRadians(14.0);
                Vec3 limitedDirection = currentDirection.scale(Math.cos(angleLimit)).add(direction.normalize().scale(Math.sin(angleLimit)));
                this.setDeltaMovement(limitedDirection.x * 0.25, limitedDirection.y * 0.25, limitedDirection.z * 0.25);
            } else {
                this.setDeltaMovement(direction.x * 0.25, direction.y * 0.25, direction.z * 0.25);
            }
        }
        this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        if (this.trailPositions.size() > 30) {
            this.trailPositions.removeFirst();
        }
        this.setNoGravity(true);
        this.setXRot(0.0f);
        this.setYRot(0.0f);
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource p_30386_, float p_30387_) {
        return p_30386_.getEntity() == null || this.getOwner() == null || !p_30386_.getEntity().is((Entity)this.getOwner());
    }

    protected void doPush(Entity p_27415_) {
    }

    protected void pushEntities() {
    }

    public void die(@NotNull DamageSource p_21809_) {
    }

    public void setItemSlot(EquipmentSlot p_21036_, ItemStack p_21037_) {
    }

    public void setItemInHand(InteractionHand p_21009_, ItemStack p_21010_) {
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    public boolean isFood(ItemStack itemStack) {
        return false;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        UUID uuid;
        snake wolf2 = (snake)((EntityType)EntityTs.snake.get()).create((Level)p_146743_);
        if (wolf2 != null && (uuid = this.getOwnerUUID()) != null) {
            wolf2.setOwnerUUID(uuid);
            wolf2.setTame(true, true);
        }
        return wolf2;
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            OwnableEntity tamableAnimal;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (this.getOwner() == null || entity instanceof OwnableEntity && (tamableAnimal = (OwnableEntity)entity).getOwner() != null && tamableAnimal.getOwner().equals((Object)this.getOwner()) || name.getNamespace().equals("moonstone") || entity.is((Entity)this.getOwner()) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }
}

