/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity;

import com.moonstone.moonstonemod.entity.attack_blood;
import com.moonstone.moonstonemod.entity.zombie.blood_zombie_boom;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.moonstoneitem.EntityTs;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class sun
extends ThrowableItemProjectile {
    private LivingEntity target;
    private int time = 200;

    public sun(EntityType<? extends sun> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    protected Item getDefaultItem() {
        return (Item)Items.blood.get();
    }

    @NotNull
    public ItemStack getItem() {
        return ((Item)Items.blood.get()).getDefaultInstance();
    }

    public float getXRot() {
        return 0.0f;
    }

    public float getYRot() {
        return 0.0f;
    }

    public void tick() {
        Object attack_blood2;
        super.tick();
        --this.time;
        if (this.target == null || !this.target.isAlive()) {
            this.findNewTarget();
        }
        if (this.time < 2) {
            attack_blood2 = new blood_zombie_boom((EntityType<? extends blood_zombie_boom>)((EntityType)EntityTs.blood_zombie_boom.get()), this.level());
            attack_blood2.setPos(this.position());
            this.level().addFreshEntity((Entity)attack_blood2);
            this.playSound((SoundEvent)SoundEvents.GENERIC_EXPLODE.value(), 1.5f, 1.5f);
            this.discard();
        }
        if (this.tickCount < 20) {
            this.setPos(new Vec3(this.getX(), this.getY() + (double)0.15f, this.getZ()));
        } else {
            this.setPos(new Vec3(this.getX(), this.getY() + (double)0.015f, this.getZ()));
            if (this.tickCount % 5 == 0 && this.target != null) {
                attack_blood2 = new attack_blood((EntityType<? extends attack_blood>)((EntityType)EntityTs.attack_blood.get()), this.level());
                ((attack_blood)((Object)attack_blood2)).setTarget(this.target);
                attack_blood2.setPos(this.position());
                attack_blood2.setOwner(this.getOwner());
                this.level().addFreshEntity((Entity)attack_blood2);
                this.playRemoveOneSound((Entity)this);
            }
        }
        this.setNoGravity(true);
        this.setYRot(0.0f);
        this.setXRot(0.0f);
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound((SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), 0.55f, 0.55f);
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            OwnableEntity tamableAnimal;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (this.getOwner() == null || entity instanceof OwnableEntity && (tamableAnimal = (OwnableEntity)entity).getOwner() != null && tamableAnimal.getOwner().equals((Object)this.getOwner()) || name.getNamespace().equals("moonstone") || entity.is(this.getOwner()) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }
}

