/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.zombie;

import com.moonstone.moonstonemod.entity.zombie.blood_zombie_boom;
import com.moonstone.moonstonemod.init.moonstoneitem.EntityTs;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class blood_zombie_fly
extends ThrowableItemProjectile {
    public int age = 0;
    private LivingEntity target;

    public blood_zombie_fly(EntityType<? extends blood_zombie_fly> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    @NotNull
    protected Item getDefaultItem() {
        return Items.IRON_SWORD;
    }

    public void tick() {
        super.tick();
        this.setNoGravity(true);
        this.setInvisible(true);
        ++this.age;
        if (this.age > 100) {
            this.discard();
        }
        if (this.target == null || !this.target.isAlive()) {
            this.findNewTarget();
        }
        if (this.target != null && this.age > 20) {
            Vec3 targetPos = this.target.position().add(0.0, 0.5, 0.0);
            Vec3 currentPos = this.position();
            Vec3 direction = targetPos.subtract(currentPos).normalize();
            this.setDeltaMovement(direction.x / 3.0, direction.y / 3.0, direction.z / 3.0);
        }
    }

    protected void onHitEntity(@NotNull EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        Entity entity = hitResult.getEntity();
        ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (!name.getNamespace().equals("moonstone") && !(entity instanceof Player) && this.age > 20) {
            entity.invulnerableTime = 0;
            entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 2.5f);
            blood_zombie_boom blood_zombie_boom2 = new blood_zombie_boom((EntityType<? extends blood_zombie_boom>)((EntityType)EntityTs.blood_zombie_boom.get()), this.level());
            blood_zombie_boom2.setPos(this.position());
            this.level().addFreshEntity((Entity)blood_zombie_boom2);
            this.discard();
        }
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (name.getNamespace().equals("moonstone") || entity instanceof Player || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }
}

