/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.zombie;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.entity.extend.MoonTamableAnimal;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.moonstoneitem.EntityTs;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class cell_zombie
extends MoonTamableAnimal {
    public cell_zombie(EntityType<? extends cell_zombie> c, Level p_34272_) {
        super(c, p_34272_);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.ZOMBIE_HURT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_DEATH;
    }

    @Override
    public void tick() {
        ResourceLocation entity;
        super.tick();
        if (this.getTarget() != null && (entity = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getTarget().getType())).getNamespace().equals("moonstone")) {
            this.setTarget(null);
        }
        this.setAttackT();
        if (this.getTarget() != null) {
            if (!this.getTarget().isAlive()) {
                this.setTarget(null);
            } else {
                LivingEntity livingEntity = this.getTarget();
                if (livingEntity instanceof Player) {
                    entity = (Player)livingEntity;
                    if (this.getOwner() != null && this.getOwner().is((Entity)entity)) {
                        this.setTarget(null);
                    }
                }
                if ((livingEntity = this.getTarget()) instanceof OwnableEntity) {
                    entity = (OwnableEntity)livingEntity;
                    if (this.getOwner() != null && entity.getOwner() != null && entity.getOwner().is((Entity)this.getOwner())) {
                        this.setTarget(null);
                    }
                }
            }
        }
        this.time = !this.getTags().contains(" CellMummy") ? (this.time += 2) : ++this.time;
        if (this.time > 1000) {
            this.kill();
        }
        if (this.getTags().contains("DamageCell") && this.getOwner() != null) {
            this.getAttributes().addTransientAttributeModifiers(this.modifierMultimap(this.getOwner()));
        }
        if (this.getTags().contains("CellCalcification") && this.getOwner() != null) {
            this.getAttributes().addTransientAttributeModifiers(this.calcificationMultimap(this.getOwner()));
            if (this.tickCount < 5) {
                this.heal(100.0f);
            }
        }
    }

    private void setAttackT() {
        if (this.getOwner() != null) {
            OwnableEntity ownableEntity;
            LivingEntity livingEntity = this.getTarget();
            if (livingEntity instanceof OwnableEntity && (ownableEntity = (OwnableEntity)livingEntity).getOwner() != null && ownableEntity.getOwner().is((Entity)this.getOwner())) {
                return;
            }
            if (this.getOwner().getLastHurtByMob() != null && !this.getOwner().getLastHurtByMob().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastHurtByMob().getType()).getNamespace().equals("moonstone")) {
                this.setTarget(this.getOwner().getLastHurtByMob());
            }
            if (this.getOwner().getLastAttacker() != null && !this.getOwner().getLastAttacker().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastAttacker().getType()).getNamespace().equals("moonstone")) {
                this.setTarget(this.getOwner().getLastAttacker());
            }
            if (this.getOwner().getLastHurtMob() != null && !this.getOwner().getLastHurtMob().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastHurtMob().getType()).getNamespace().equals("moonstone")) {
                this.setTarget(this.getOwner().getLastHurtMob());
            }
        }
    }

    private Multimap<Holder<Attribute>, AttributeModifier> calcificationMultimap(LivingEntity livingEntity) {
        HashMultimap modifierMultimap = HashMultimap.create();
        if (Handler.hascurio(livingEntity, (Item)Items.cell.get()) && Handler.hascurio(livingEntity, (Item)Items.cell_calcification.get())) {
            modifierMultimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagecell_armor"), livingEntity.getAttributeValue(Attributes.ARMOR) / 2.0, AttributeModifier.Operation.ADD_VALUE));
            modifierMultimap.put((Object)Attributes.MAX_HEALTH, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagecell_health"), livingEntity.getAttributeValue(Attributes.MAX_HEALTH) / 2.0, AttributeModifier.Operation.ADD_VALUE));
        }
        return modifierMultimap;
    }

    private Multimap<Holder<Attribute>, AttributeModifier> modifierMultimap(LivingEntity livingEntity) {
        HashMultimap modifierMultimap = HashMultimap.create();
        if (Handler.hascurio(livingEntity, (Item)Items.cell.get()) && Handler.hascurio(livingEntity, (Item)Items.adrenaline.get())) {
            modifierMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagecell_damage"), livingEntity.getAttributeValue(Attributes.ATTACK_DAMAGE), AttributeModifier.Operation.ADD_VALUE));
            modifierMultimap.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagecell_speed"), livingEntity.getAttributeValue(Attributes.MOVEMENT_SPEED), AttributeModifier.Operation.ADD_VALUE));
        }
        return modifierMultimap;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        UUID uuid;
        cell_zombie wolf2 = (cell_zombie)((EntityType)EntityTs.cell_zombie.get()).create((Level)p_146743_);
        if (wolf2 != null && (uuid = this.getOwnerUUID()) != null) {
            wolf2.setOwnerUUID(uuid);
            wolf2.setTame(true, true);
        }
        return wolf2;
    }

    @Override
    public void die(@NotNull DamageSource p_21809_) {
        super.die(p_21809_);
        if (this.getTags().contains(" CellBoom")) {
            this.level().explode(null, this.getX(), this.getY(), this.getZ(), 5.5f, false, Level.ExplosionInteraction.NONE);
        }
    }

    @Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        super.setOwnerUUID(p_21817_);
    }

    public void aiStep() {
        super.aiStep();
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper) && !(p_30389_ instanceof Ghast)) {
            if (p_30389_ instanceof cell_zombie) {
                cell_zombie wolf2 = (cell_zombie)p_30389_;
                return !wolf2.isTame() || wolf2.getOwner() != p_30390_;
            }
            if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).canHarmPlayer((Player)p_30389_)) {
                return false;
            }
            if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).isTamed()) {
                return false;
            }
            return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).isTame();
        }
        return false;
    }

    @Override
    public boolean doHurtTarget(Entity p_30372_) {
        boolean flag = p_30372_.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)((int)this.getAttributeValue(Attributes.ATTACK_DAMAGE)));
        if (this.getTags().contains("CellBlood")) {
            this.heal(this.getMaxHealth() / 10.0f);
            if (this.time > 0) {
                this.time -= 100;
            }
            this.level().playSound(null, new BlockPos((int)this.getX(), (int)this.getY(), (int)this.getZ()), SoundEvents.PANDA_EAT, SoundSource.MUSIC, 2.0f, 2.0f);
        }
        return flag;
    }

    public boolean hurt(DamageSource p_30386_, float p_30387_) {
        LivingEntity livingEntity;
        if (this.isInvulnerableTo(p_30386_)) {
            return false;
        }
        Entity entity = p_30386_.getEntity();
        if (!this.level().isClientSide) {
            this.setOrderedToSit(false);
        }
        if (entity instanceof LivingEntity && !Handler.hascurio(livingEntity = (LivingEntity)entity, (Item)Items.necora.get())) {
            this.setTarget(livingEntity);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            p_30387_ = (p_30387_ + 1.0f) / 2.0f;
        }
        return super.hurt(p_30386_, p_30387_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderMan.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }
}

