/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.zombie;

import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.moonstoneitem.EntityTs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class sword_soul
extends TamableAnimal {
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public sword_soul(EntityType<? extends sword_soul> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setNoGravity(true);
        CuriosApi.getCuriosInventory((LivingEntity)this).ifPresent(handler -> handler.getStacksHandler("ncrdna").ifPresent(stacks -> stacks.addPermanentModifier(new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"ncrdnasword_soul"), 2.0, AttributeModifier.Operation.ADD_VALUE))));
    }

    public void die(@NotNull DamageSource p_21809_) {
        LivingEntity livingEntity;
        if (this.getOwner() != null && (livingEntity = this.getOwner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.setPos(this.getOwner().position());
            CuriosApi.getCuriosInventory((LivingEntity)this).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (String id : curios.keySet()) {
                    sword_soul.drop((ICurioStacksHandler)curios.get(id), player);
                }
            });
        }
    }

    public static void drop(ICurioStacksHandler stacksHandler, ServerPlayer serverPlayer) {
        for (int i = 0; i < stacksHandler.getSlots(); ++i) {
            ItemStack stack1 = stacksHandler.getStacks().getStackInSlot(i);
            stacksHandler.getStacks().setStackInSlot(i, ItemStack.EMPTY);
            ItemStack stack2 = stacksHandler.getCosmeticStacks().getStackInSlot(i);
            stacksHandler.getCosmeticStacks().setStackInSlot(i, ItemStack.EMPTY);
            if (!stack1.isEmpty()) {
                serverPlayer.drop(stack1, true, false);
            }
            if (stack2.isEmpty()) continue;
            serverPlayer.drop(stack2, true, false);
        }
    }

    @SubscribeEvent
    public static void evil(LivingDeathEvent event) {
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    public void tick() {
        Player player;
        LivingEntity direction;
        super.tick();
        this.setNoGravity(true);
        LivingEntity target = this.getTarget();
        Vec3 currentPos = this.position();
        if (target != null) {
            Vec3 targetPos = target.position().add(0.0, 0.5, 0.0);
            direction = targetPos.subtract(currentPos).normalize();
            this.setDeltaMovement(direction.x * 0.5750000029802322, direction.y * 0.5750000029802322, direction.z * 0.5750000029802322);
        }
        if (this.getOwner() != null && (direction = this.getOwner()) instanceof Player && !Handler.hascurio((LivingEntity)(player = (Player)direction), (Item)Items.necora_baby.get())) {
            this.setPos(player.position());
            this.playRemoveOneSound((Entity)this);
            this.kill();
        }
        this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        if (this.trailPositions.size() > 10) {
            this.trailPositions.removeFirst();
        }
        Vec3 playerPos = this.position().add(0.0, 0.75, 0.0);
        int range = 20;
        List entities = this.level().getEntitiesOfClass(Mob.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (Mob mob : entities) {
            ResourceLocation entity;
            if (this.getTarget() != null || (entity = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType())).getNamespace().equals("moonstone")) continue;
            this.setTarget((LivingEntity)mob);
        }
        if (this.getTarget() != null) {
            ResourceLocation entity = BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getTarget().getType());
            if (entity.getNamespace().equals("moonstone")) {
                this.setTarget(null);
            }
            if (!this.getTarget().isAlive()) {
                this.setTarget(null);
            }
        }
        if (this.getOwner() != null) {
            if (this.getOwner().getLastHurtByMob() != null && !this.getOwner().getLastHurtByMob().is((Entity)this)) {
                this.setTarget(this.getOwner().getLastHurtByMob());
            }
            if (this.getOwner().getLastAttacker() != null && !this.getOwner().getLastAttacker().is((Entity)this)) {
                this.setTarget(this.getOwner().getLastAttacker());
            }
            if (this.getOwner().getLastHurtMob() != null && !this.getOwner().getLastHurtMob().is((Entity)this)) {
                this.setTarget(this.getOwner().getLastHurtMob());
            }
        }
        if (this.getTarget() == null || this.tickCount % 20 == 0) {
            // empty if block
        }
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound((SoundEvent)SoundEvents.RESPAWN_ANCHOR_DEPLETE.value(), 1.0f, 1.0f);
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity p_27415_) {
    }

    protected void pushEntities() {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 30.0f, 6.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uuid;
        sword_soul wolf2 = (sword_soul)((EntityType)EntityTs.sword_soul.get()).create((Level)serverLevel);
        if (wolf2 != null && (uuid = this.getOwnerUUID()) != null) {
            wolf2.setOwnerUUID(uuid);
            wolf2.setTame(true, true);
        }
        return wolf2;
    }
}

