/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.init.moonstoneitem;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class Enchants {
    public static final String Terror = "terror";
    public static final String threat = "threat";
    public static final String malice = "malice";

    public static int getEnchantmentLevel(String enchantmentName, ItemStack stack, LivingEntity entity) {
        Registry enchantmentRegistry = entity.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference reference = enchantmentRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)enchantmentName)));
        return stack.getEnchantmentLevel((Holder)reference);
    }

    public static boolean isMoonEnchant(Holder<Enchantment> enchantment, String enchantmentName) {
        ResourceKey a = ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)enchantmentName));
        return enchantment.is(a);
    }

    public static Holder.Reference<Enchantment> getEnchantHolder(Player player, String enchantmentName) {
        Registry enchantmentRegistry = player.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        return enchantmentRegistry.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)enchantmentName)));
    }

    public static void maliceAttack(LivingIncomingDamageEvent event) {
        ArrayList integers = new ArrayList();
        ArrayList getTargets = new ArrayList();
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        Object mob2;
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.isEmpty() || Enchants.getEnchantmentLevel(malice, stack, living) <= 0) continue;
                        int lvl = Enchants.getEnchantmentLevel(malice, stack, living);
                        integers.add(lvl);
                        float ss = 0.0f;
                        Iterator iterator = integers.iterator();
                        while (iterator.hasNext()) {
                            int is = (Integer)iterator.next();
                            ss += (float)is;
                        }
                        Vec3 playerPos = living.position().add(0.0, 0.75, 0.0);
                        int range = 10;
                        List entities = living.level().getEntitiesOfClass(Mob.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
                        for (Object mob2 : entities) {
                            if (mob2.getTarget() == null || !mob2.getTarget().is((Entity)living)) continue;
                            getTargets.add(1);
                        }
                        int s = 0;
                        mob2 = getTargets.iterator();
                        while (mob2.hasNext()) {
                            int ignored = (Integer)mob2.next();
                            ++s;
                        }
                        float maliceLvl = ss / 100.0f;
                        float damage = (float)s * maliceLvl;
                        if (damage > 95.0f) {
                            damage = 95.0f;
                        }
                        event.setAmount(event.getAmount() * (1.0f - (damage /= 100.0f)));
                    }
                }
            });
        }
    }

    public static void LivingHurtEvent(LivingIncomingDamageEvent event) {
        ArrayList integers = new ArrayList();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity living = livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.isEmpty() || Enchants.getEnchantmentLevel(Terror, stack, living) <= 0) continue;
                        int lvl = Enchants.getEnchantmentLevel(Terror, stack, living);
                        integers.add(lvl);
                        float ss = 0.0f;
                        Iterator iterator = integers.iterator();
                        while (iterator.hasNext()) {
                            int is = (Integer)iterator.next();
                            ss += (float)is;
                        }
                        event.setAmount(event.getAmount() * (1.0f + (ss /= 200.0f)));
                    }
                }
            });
        }
    }

    public static void threatHeal(LivingHealEvent event) {
        ArrayList integers = new ArrayList();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof LivingEntity) {
            LivingEntity living = livingEntity;
            CuriosApi.getCuriosInventory((LivingEntity)living).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.isEmpty() || Enchants.getEnchantmentLevel(threat, stack, living) <= 0) continue;
                        int lvl = Enchants.getEnchantmentLevel(threat, stack, living);
                        integers.add(lvl);
                        float ss = 0.0f;
                        Iterator iterator = integers.iterator();
                        while (iterator.hasNext()) {
                            int is = (Integer)iterator.next();
                            ss += (float)is;
                        }
                        if ((ss /= 100.0f) > 0.9f) {
                            ss = 0.9f;
                        }
                        event.setAmount(event.getAmount() * (1.0f - ss));
                    }
                }
            });
        }
    }
}

