/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.man;

import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.contents.ManBundleContents;
import com.moonstone.moonstonemod.init.moonstoneitem.DataReg;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public abstract class ManDNA
extends Item
implements ICurioItem {
    public ManDNA(Item.Properties properties) {
        super(properties);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (stack.get(DataReg.tag) == null) {
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
    }

    @Nullable
    public abstract List<Item> getDrug();

    @NotNull
    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public boolean overrideOtherStackedOnMe(ItemStack pStack, ItemStack pOther, Slot pSlot, ClickAction pAction, Player pPlayer, SlotAccess pAccess) {
        if (pAction == ClickAction.SECONDARY && pSlot.allowModification(pPlayer)) {
            ManBundleContents manBundleContents = (ManBundleContents)pStack.get(DataReg.man);
            if (manBundleContents == null) {
                return false;
            }
            boolean drug = false;
            if (this.getDrug() != null) {
                for (Item item : this.getDrug()) {
                    if (!pOther.is(item)) continue;
                    drug = true;
                    break;
                }
            }
            if (drug) {
                ManBundleContents.Mutable mutable = new ManBundleContents.Mutable(manBundleContents);
                mutable.tryInsert(pOther);
                pStack.set(DataReg.man, (Object)mutable.toImmutable());
                return true;
            }
        }
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (Screen.hasShiftDown()) {
            ManBundleContents manBundleContents = (ManBundleContents)stack.get(DataReg.man);
            if (manBundleContents != null) {
                manBundleContents.items().forEach(itemStack -> {
                    if (!itemStack.isEmpty()) {
                        tooltipComponents.addAll(itemStack.getTooltipLines(context, null, tooltipFlag));
                    }
                });
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.GOLD));
        }
        tooltipComponents.add((Component)Component.literal((String)""));
        tooltipComponents.add((Component)Component.translatable((String)"item.man.tool.string").withStyle(ChatFormatting.GOLD));
        tooltipComponents.add((Component)Component.literal((String)""));
        if (this.getDrug() != null) {
            for (Item item : this.getDrug()) {
                ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)item);
                String s = resourceLocation.toString().replace(":", ".");
                tooltipComponents.add((Component)Component.translatable((String)("item." + s)).withStyle(ChatFormatting.GOLD));
            }
        }
    }

    public static void addLoot(ObjectArrayList<ItemStack> generatedLoot, Entity entity, int gLvl) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        List<Item> list;
                        ManDNA manDNA;
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        Item patt0$temp = stack.getItem();
                        if (!(patt0$temp instanceof ManDNA) || !Handler.hascurio((LivingEntity)player, manDNA = (ManDNA)patt0$temp) || manDNA.getDrug() == null || (list = manDNA.getDrug()).isEmpty() || Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100) > gLvl) continue;
                        generatedLoot.add((Object)new ItemStack((ItemLike)list.get(new Random().nextInt(list.size()))));
                    }
                }
            });
        }
    }

    public static class Drug
    extends Item
    implements ICurioItem {
        public final List<String> stringName;

        public void curioTick(SlotContext slotContext, ItemStack stack) {
            if (stack.get(DataReg.tag) == null) {
                stack.set(DataReg.tag, (Object)new CompoundTag());
            }
        }

        public Drug(List<String> stringName) {
            super(new Item.Properties().stacksTo(1).rarity(Rarity.RARE));
            this.stringName = new ArrayList<String>(new LinkedHashSet<String>(stringName));
        }

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag tooltipFlag) {
            super.appendHoverText(stack, context, pTooltipComponents, tooltipFlag);
            for (String string : this.stringName) {
                pTooltipComponents.add((Component)Component.translatable((String)string).withStyle(ChatFormatting.GOLD));
            }
        }
    }
}

