/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ModelBlockRenderer.class})
public class ModelBlockRendererMixin {
    @Shadow
    @Final
    private BlockColors blockColors;

    @Inject(method={"putQuadData"}, at={@At(value="RETURN")})
    private void putQuadData1(BlockAndTintGetter level, BlockState state, BlockPos pos, VertexConsumer consumer, PoseStack.Pose pose, BakedQuad quad, float brightness0, float brightness1, float brightness2, float brightness3, int lightmap0, int lightmap1, int lightmap2, int lightmap3, int packedOverlay, CallbackInfo ci) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && !state.isEmpty()) {
            float maxDistance = 10.0f;
            float minAlp = 0.0f;
            int minLight = 0;
            float maxAlp = 1.0f;
            int maxLight = 240;
            BlockPos blockPosPlayer = player.getOnPos();
            float distance = (float)Math.sqrt(pos.distSqr((Vec3i)blockPosPlayer));
            if (distance > maxDistance) {
                return;
            }
            double v = Math.sqrt(maxDistance - distance) / Math.sqrt(maxDistance);
            float alp = (float)(v * (double)(maxAlp - minAlp) + (double)minAlp);
            int light = Math.min((int)(v * (double)(maxLight - minLight) + (double)minLight), maxLight);
            if (alp <= 0.0f || light <= 0) {
                return;
            }
            consumer.putBulkData(pose, quad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, 1.0f, 0.0f, 0.0f, 0.01f, new int[]{240, 240, 240, 240}, packedOverlay, true);
        }
    }
}

