/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.mixin.si_mixin.client;

import com.ytgld.seeking_immortals.Config;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.Items;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GameRendererMixin {
    @Shadow
    @Final
    private Camera mainCamera;
    @Shadow
    @Nullable
    private PostChain blurEffect;
    @Shadow
    @Final
    Minecraft minecraft;

    @Shadow
    public abstract void tick();

    @Inject(at={@At(value="RETURN")}, method={"render"})
    public void init(DeltaTracker deltaTracker, boolean renderLevel, CallbackInfo ci) {
        Entity entity = this.mainCamera.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (((Boolean)Config.SERVER.nightmare_base_black_eye.get()).booleanValue()) {
                if (Handler.hascurio((LivingEntity)player, (Item)Items.muddy_jewels.get())) {
                    return;
                }
                if (Handler.hascurio((LivingEntity)player, (Item)Items.nightmare_base_black_eye.get())) {
                    float fs = player.getPersistentData().getFloat("blurEffectOFNightmare_base_black_eye");
                    if (this.moonstone1_21_1$getPlayerLookTarget(player.level(), (LivingEntity)player) != null && this.moonstone1_21_1$getPlayerLookTarget(player.level(), (LivingEntity)player) instanceof LivingEntity) {
                        if (fs < 5.0f) {
                            player.getPersistentData().putFloat("blurEffectOFNightmare_base_black_eye", fs + 0.1f);
                        }
                    } else if (fs > 0.0f) {
                        player.getPersistentData().putFloat("blurEffectOFNightmare_base_black_eye", fs - 0.05f);
                    }
                    if (fs > 0.0f && this.blurEffect != null) {
                        this.blurEffect.setUniform("Radius", player.getPersistentData().getFloat("blurEffectOFNightmare_base_black_eye"));
                        this.blurEffect.process(deltaTracker.getGameTimeDeltaTicks());
                    }
                }
            }
        }
    }

    @Unique
    public Entity moonstone1_21_1$getPlayerLookTarget(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3 srcVec = living.getEyePosition();
        Vec3 lookVec = living.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 1.0f;
        List possibleList = level.getEntities((Entity)living, living.getBoundingBox().expandTowards(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable()) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }
}

