/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.tbl.client.shader.postprocessing;

import com.all.IPostChain;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.shaders.Uniform;
import com.moonstone.tbl.client.renderer.GLTextureObjectWrapper;
import com.moonstone.tbl.client.shader.LightSource;
import com.moonstone.tbl.client.shader.postprocessing.Warp;
import com.moonstone.tbl.common.MoonstoneTBL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;

public class WorldShader
extends PostChain
implements AutoCloseable {
    public static final ResourceLocation GAS_PARTICLE_TEXTURE = MoonstoneTBL.prefix("gas_particle");
    private final RenderTarget depthBuffer;
    private Matrix4f invertedModelviewProjectionMatrix;
    public static final int MAX_LIGHT_SOURCES_PER_PASS = 32;
    private final List<LightSource> lightSources = new ArrayList<LightSource>();
    public Vector3f cameraPos = new Vector3f();
    private static final int WORLD_INDEX = 0;
    @Nullable
    public Uniform invMVPUniform = this.getUniform(0, "u_INVMVP");
    @Nullable
    private final Uniform lightSourcePositionUniforms = this.getUniform(0, "u_lightSources_position");
    @Nullable
    private final Uniform lightSourceColorUniforms = this.getUniform(0, "u_lightSources_color");
    @Nullable
    private final Uniform lightSourceRadiusUniforms = this.getUniform(0, "u_lightSources_radius");
    @Nullable
    private final Uniform lightSourceAmountUniform = this.getUniform(0, "u_lightSourcesAmount");
    private static final Comparator<LightSource> LIGHT_SOURCE_SORTER = (o1, o2) -> {
        double d2;
        double dx1 = o1.x - Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().x();
        double dy1 = o1.y - Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().y();
        double dz1 = o1.z - Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().z();
        double dx2 = o2.x - Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().x();
        double dy2 = o2.y - Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().y();
        double dz2 = o2.z - Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().z();
        double d1 = Math.sqrt(dx1 * dx1 + dy1 * dy1 + dz1 * dz1);
        if (d1 > (d2 = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2))) {
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 0;
    };

    public WorldShader(TextureManager textureManager, ResourceProvider resourceProvider, RenderTarget screenTarget) throws IOException, JsonSyntaxException {
        super(textureManager, resourceProvider, screenTarget, ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"shaders/post/world.json"));
        this.depthBuffer = this.getTempTarget("s_diffuse_depth");
        Warp gasWarpEffect = new Warp(textureManager, resourceProvider, screenTarget);
        Minecraft.getInstance().getTextureManager().register(GAS_PARTICLE_TEXTURE, (AbstractTexture)new GLTextureObjectWrapper(gasWarpEffect.gasTextureTarget.getColorTextureId()));
    }

    public void cleanUp() {
        this.clearLights();
    }

    public void uploadUniforms() {
        this.invMVPUniform.set(this.invertedModelviewProjectionMatrix);
        float[] positionBuff = new float[96];
        float[] colorBuff = new float[96];
        Collections.sort(this.lightSources, LIGHT_SOURCE_SORTER);
        if (!this.lightSources.isEmpty()) {
            for (int i = 0; i < 32 && i < this.lightSources.size(); ++i) {
                positionBuff[i * 3] = (float)this.lightSources.get((int)i).x - this.cameraPos.x;
                positionBuff[i * 3 + 1] = (float)this.lightSources.get((int)i).y - this.cameraPos.y;
                positionBuff[i * 3 + 2] = (float)this.lightSources.get((int)i).z - this.cameraPos.z;
                colorBuff[i * 3] = this.lightSources.get((int)i).r;
                colorBuff[i * 3 + 1] = this.lightSources.get((int)i).g;
                colorBuff[i * 3 + 2] = this.lightSources.get((int)i).b;
                this.lightSourceRadiusUniforms.set(i, this.lightSources.get((int)i).radius);
            }
            this.lightSourcePositionUniforms.set(positionBuff);
            this.lightSourceColorUniforms.set(colorBuff);
        }
        this.lightSourceAmountUniform.set(Math.min(this.lightSources.size(), 32));
    }

    public RenderTarget getDepthBuffer() {
        return this.depthBuffer;
    }

    public void updateMatrices(RenderLevelStageEvent event) {
        this.cameraPos = event.getCamera().getPosition().toVector3f();
        Matrix4f modelviewMatrix = event.getModelViewMatrix().transpose(new Matrix4f());
        Matrix4f projectionMatrix = event.getProjectionMatrix().transpose(new Matrix4f());
        this.invertedModelviewProjectionMatrix = new Matrix4f();
        Matrix4f MVP = modelviewMatrix.mul((Matrix4fc)projectionMatrix);
        MVP.invert(this.invertedModelviewProjectionMatrix);
        this.invertedModelviewProjectionMatrix = this.invertedModelviewProjectionMatrix.assume(0);
    }

    public void addLight(LightSource light) {
        this.lightSources.add(light);
    }

    public void clearLights() {
        this.lightSources.clear();
    }

    public Uniform getUniform(int index, String name) {
        WorldShader worldShader = this;
        if (worldShader instanceof IPostChain) {
            IPostChain iPostChain = (IPostChain)((Object)worldShader);
            return iPostChain.moonstone1_21_1$passes().get(index).getEffect().getUniform(name);
        }
        return null;
    }
}

