/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.item.nightmare;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.event.CurioHurtEvent;
import com.ytgld.seeking_immortals.init.DataReg;
import com.ytgld.seeking_immortals.init.EntityTs;
import com.ytgld.seeking_immortals.init.Items;
import com.ytgld.seeking_immortals.item.nightmare.extend.nightmare;
import com.ytgld.seeking_immortals.test_entity.orb_entity;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class eye
extends nightmare {
    public static String health = "HealthEye";

    public static void CurioDamageEvent(CurioHurtEvent event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getStack();
        LivingIncomingDamageEvent damageEvent = event.getEvent();
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (Handler.hascurio((LivingEntity)player, (Item)Items.eye.get()) && stack.is((Item)Items.eye.get()) && compoundTag != null && (float)compoundTag.getInt(health) >= player.getMaxHealth() * 3.0f) {
            player.heal((float)compoundTag.getInt(health));
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.NEUTRAL, 1.0f, 1.0f);
            damageEvent.setAmount(0.0f);
            compoundTag.putInt(health, (int)((float)compoundTag.getInt(health) - player.getMaxHealth()));
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity;
        Entity entity2 = this.look(slotContext.entity().level(), slotContext.entity());
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).isAlive() && slotContext.entity().tickCount % 10 == 0) {
            if (!slotContext.entity().level().isClientSide) {
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 40, 1));
                entity.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 40, 1));
                entity.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 40, 1));
                entity.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 40, 1));
                entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 40, 1));
            }
            entity.invulnerableTime = 0;
            entity.hurt(entity.damageSources().magic(), slotContext.entity().getMaxHealth() / 20.0f + 3.0f);
            entity.level().playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.PHANTOM_BITE, SoundSource.AMBIENT, 1.0f, 1.0f);
            CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
            if (compoundTag != null) {
                if (slotContext.entity().getHealth() >= slotContext.entity().getMaxHealth()) {
                    compoundTag.putInt(health, (int)((float)compoundTag.getInt(health) + slotContext.entity().getMaxHealth() / 100.0f + 2.0f));
                } else {
                    slotContext.entity().heal(slotContext.entity().getMaxHealth() / 100.0f + 2.0f);
                }
            } else {
                stack.set(DataReg.tag, (Object)new CompoundTag());
            }
            orb_entity orb_entity2 = new orb_entity((EntityType<? extends orb_entity>)((EntityType)EntityTs.orb_entity.get()), slotContext.entity().level());
            orb_entity2.r = Mth.nextInt((RandomSource)RandomSource.create(), (int)100, (int)255);
            orb_entity2.g = Mth.nextInt((RandomSource)RandomSource.create(), (int)0, (int)25);
            orb_entity2.b = Mth.nextInt((RandomSource)RandomSource.create(), (int)175, (int)255);
            orb_entity2.setOwner((Entity)slotContext.entity());
            orb_entity2.setPos(entity.position().add(0.0, 1.5, 0.0));
            orb_entity2.setDeltaMovement(new Vec3((double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-0.21f, (float)0.25f), 0.25, (double)Mth.nextFloat((RandomSource)RandomSource.create(), (float)-0.311f, (float)0.25f)));
            slotContext.entity().level().addFreshEntity((Entity)orb_entity2);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        CuriosApi.addSlotModifier((Multimap)linkedHashMultimap, (String)"nightmare", (ResourceLocation)ResourceLocation.parse((String)"eyeadd_slot"), (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        return linkedHashMultimap;
    }

    public Entity look(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 20.0;
        Vec3 srcVec = living.getEyePosition();
        Vec3 lookVec = living.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 1.0f;
        List possibleList = level.getEntities((Entity)living, living.getBoundingBox().expandTowards(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable()) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> pTooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, pTooltipComponents, tooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"item.eye.tool.string.1").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.eye.tool.string.2").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.literal((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)"item.eye.tool.string.3").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.eye.tool.string.4").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.literal((String)""));
        pTooltipComponents.add((Component)Component.translatable((String)"item.eye.tool.string.7").withStyle(ChatFormatting.DARK_RED));
        pTooltipComponents.add((Component)Component.translatable((String)"item.eye.tool.string.8").withStyle(ChatFormatting.DARK_RED));
        CompoundTag compoundTag = (CompoundTag)stack.get(DataReg.tag);
        if (compoundTag != null) {
            pTooltipComponents.add((Component)Component.translatable((String)"item.eye.tool.string.5").append(": ").append(String.valueOf(compoundTag.getInt(health))).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-47223))));
        } else {
            pTooltipComponents.add((Component)Component.translatable((String)"item.eye.tool.string.6").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-47223))));
        }
    }
}

