/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.client.entitys.nightmare;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.moonstone.moonstonemod.client.entitys.nightmare.Digging;
import com.moonstone.moonstonemod.client.entitys.nightmare.Emerging;
import com.moonstone.moonstonemod.client.entitys.nightmare.Roar;
import com.moonstone.moonstonemod.client.entitys.nightmare.SetRoarTarget;
import com.moonstone.moonstonemod.client.entitys.nightmare.Sniffing;
import com.moonstone.moonstonemod.client.entitys.nightmare.SonicBoom;
import com.moonstone.moonstonemod.entity.necora.nightmare_giant;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.warden.ForceUnmount;
import net.minecraft.world.entity.ai.behavior.warden.SetWardenLookTarget;
import net.minecraft.world.entity.ai.behavior.warden.TryToSniff;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class AInightmare {
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.5f;
    private static final float SPEED_MULTIPLIER_WHEN_INVESTIGATING = 0.7f;
    private static final float SPEED_MULTIPLIER_WHEN_FIGHTING = 1.2f;
    private static final int MELEE_ATTACK_COOLDOWN = 18;
    private static final int DIGGING_DURATION = Mth.m_14167_((float)100.0f);
    public static final int EMERGE_DURATION = Mth.m_14167_((float)133.59999f);
    public static final int ROAR_DURATION = Mth.m_14167_((float)84.0f);
    private static final int SNIFFING_DURATION = Mth.m_14167_((float)83.2f);
    public static final int DIGGING_COOLDOWN = 1200;
    private static final int DISTURBANCE_LOCATION_EXPIRY_TIME = 100;
    private static final List<SensorType<? extends Sensor<? super nightmare_giant>>> SENSOR_TYPES = List.of(SensorType.f_26812_);
    private static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.f_148204_, MemoryModuleType.f_148205_, MemoryModuleType.f_26368_, MemoryModuleType.f_148206_, MemoryModuleType.f_26333_, MemoryModuleType.f_26371_, MemoryModuleType.f_26370_, MemoryModuleType.f_26326_, MemoryModuleType.f_26377_, MemoryModuleType.f_26372_, MemoryModuleType.f_26373_, MemoryModuleType.f_148194_, MemoryModuleType.f_217782_, MemoryModuleType.f_217783_, MemoryModuleType.f_217784_, MemoryModuleType.f_217785_, MemoryModuleType.f_217786_, MemoryModuleType.f_217769_, MemoryModuleType.f_217770_, MemoryModuleType.f_217771_, MemoryModuleType.f_217772_, MemoryModuleType.f_217773_, MemoryModuleType.f_217774_, MemoryModuleType.f_217775_, MemoryModuleType.f_217776_, MemoryModuleType.f_217777_);
    private static final BehaviorControl<nightmare_giant> DIG_COOLDOWN_SETTER = BehaviorBuilder.m_258034_(p_258953_ -> p_258953_.group((App)p_258953_.m_257492_(MemoryModuleType.f_217770_)).apply((Applicative)p_258953_, p_258960_ -> (p_258956_, p_258957_, p_258958_) -> {
        if (p_258953_.m_257828_(p_258960_).isPresent()) {
            p_258960_.m_257465_((Object)Unit.INSTANCE, 1200L);
        }
        return true;
    }));

    public static void updateActivity(nightmare_giant p_219513_) {
        p_219513_.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219852_, (Object)Activity.f_219853_, (Object)Activity.f_219851_, (Object)Activity.f_37988_, (Object)Activity.f_219850_, (Object)Activity.f_219849_, (Object)Activity.f_37979_));
    }

    public static Brain<?> makeBrain(nightmare_giant p_219521_, Dynamic<?> p_219522_) {
        Brain.Provider provider = Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
        Brain brain2 = provider.m_22073_(p_219522_);
        AInightmare.initCoreActivity((Brain<nightmare_giant>)brain2);
        AInightmare.initEmergeActivity((Brain<nightmare_giant>)brain2);
        AInightmare.initIdleActivity((Brain<nightmare_giant>)brain2);
        AInightmare.initRoarActivity((Brain<nightmare_giant>)brain2);
        AInightmare.initFightActivity(p_219521_, (Brain<nightmare_giant>)brain2);
        AInightmare.initInvestigateActivity((Brain<nightmare_giant>)brain2);
        brain2.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain2.m_21944_(Activity.f_37979_);
        brain2.m_21962_();
        return brain2;
    }

    private static void initCoreActivity(Brain<nightmare_giant> p_219511_) {
        p_219511_.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)SetWardenLookTarget.m_257897_(), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initEmergeActivity(Brain<nightmare_giant> p_219527_) {
        p_219527_.m_21895_(Activity.f_219852_, 5, ImmutableList.of(new Emerging(EMERGE_DURATION)), MemoryModuleType.f_217786_);
    }

    private static void initDiggingActivity(Brain<nightmare_giant> p_219532_) {
        p_219532_.m_21903_(Activity.f_219853_, ImmutableList.of((Object)Pair.of((Object)0, (Object)new ForceUnmount()), (Object)Pair.of((Object)1, new Digging(DIGGING_DURATION))), (Set)ImmutableSet.of((Object)Pair.of((Object)MemoryModuleType.f_217782_, (Object)MemoryStatus.VALUE_ABSENT), (Object)Pair.of((Object)MemoryModuleType.f_217770_, (Object)MemoryStatus.VALUE_ABSENT)));
    }

    private static void initIdleActivity(Brain<nightmare_giant> p_219537_) {
        p_219537_.m_21891_(Activity.f_37979_, 10, ImmutableList.of(SetRoarTarget.create(nightmare_giant::getEntityAngryAt), (Object)TryToSniff.m_257812_(), (Object)new RunOne((Map)ImmutableMap.of((Object)MemoryModuleType.f_217785_, (Object)MemoryStatus.VALUE_ABSENT), (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.5f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)))));
    }

    private static void initInvestigateActivity(Brain<nightmare_giant> p_219542_) {
        p_219542_.m_21895_(Activity.f_219850_, 5, ImmutableList.of(SetRoarTarget.create(nightmare_giant::getEntityAngryAt), (Object)GoToTargetLocation.m_257680_((MemoryModuleType)MemoryModuleType.f_217783_, (int)2, (float)0.7f)), MemoryModuleType.f_217783_);
    }

    private static void initSniffingActivity(Brain<nightmare_giant> p_219544_) {
        p_219544_.m_21895_(Activity.f_219849_, 5, ImmutableList.of(SetRoarTarget.create(nightmare_giant::getEntityAngryAt), new Sniffing(SNIFFING_DURATION)), MemoryModuleType.f_217785_);
    }

    private static void initRoarActivity(Brain<nightmare_giant> p_219546_) {
        p_219546_.m_21895_(Activity.f_219851_, 10, ImmutableList.of((Object)((Object)new Roar())), MemoryModuleType.f_217782_);
    }

    private static void initFightActivity(nightmare_giant p_219518_, Brain<nightmare_giant> p_219519_) {
        p_219519_.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)((Object)new SonicBoom())), MemoryModuleType.f_26372_);
    }

    private static boolean isTarget(nightmare_giant p_219515_, LivingEntity p_219516_) {
        return p_219515_.m_6274_().m_21952_(MemoryModuleType.f_26372_).filter(p_219509_ -> p_219509_ != p_219516_).isPresent();
    }

    private static void onTargetInvalid(nightmare_giant p_219529_, LivingEntity p_219530_) {
        if (!p_219529_.canTargetEntity((Entity)p_219530_)) {
            p_219529_.clearAnger((Entity)p_219530_);
        }
        AInightmare.setDigCooldown((LivingEntity)p_219529_);
    }

    public static void setDigCooldown(LivingEntity p_219506_) {
        if (p_219506_.m_6274_().m_21874_(MemoryModuleType.f_217770_)) {
            p_219506_.m_6274_().m_21882_(MemoryModuleType.f_217770_, (Object)Unit.INSTANCE, 1200L);
        }
    }

    public static void setDisturbanceLocation(nightmare_giant p_219524_, BlockPos p_219525_) {
        if (p_219524_.m_9236_().m_6857_().m_61937_(p_219525_) && !p_219524_.getEntityAngryAt().isPresent()) {
            AInightmare.setDigCooldown((LivingEntity)p_219524_);
            p_219524_.m_6274_().m_21882_(MemoryModuleType.f_217772_, (Object)Unit.INSTANCE, 100L);
            p_219524_.m_6274_().m_21882_(MemoryModuleType.f_26371_, (Object)new BlockPosTracker(p_219525_), 100L);
            p_219524_.m_6274_().m_21882_(MemoryModuleType.f_217783_, (Object)p_219525_, 100L);
            p_219524_.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        }
    }
}

