/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.moonstone.moonstonemod.Config;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.event.BookEvt;
import com.moonstone.moonstonemod.init.Items;
import com.moonstone.moonstonemod.moonstoneitem.Iplague;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DungeonLoot
extends LootModifier {
    public static final Codec<DungeonLoot> CODEC = RecordCodecBuilder.create(inst -> DungeonLoot.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DungeonLoot::new));

    protected DungeonLoot(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    private void addLoot(ObjectArrayList<ItemStack> generatedLoot, Random random, Item mustHas, Entity entity, List<Item> itemList, int gLvl) {
        Player player;
        if (entity instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)entity), mustHas)) {
            int i = random.nextInt(itemList.size());
            if (gLvl >= 100) {
                gLvl = 100;
            }
            if (Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)100) <= gLvl) {
                generatedLoot.add((Object)new ItemStack((ItemLike)itemList.get(i)));
            }
        }
    }

    private void addLootCommon(ObjectArrayList<ItemStack> generatedLoot, Random random, Entity entity, List<Item> itemList, int gLvl) {
        if (entity instanceof Player) {
            int i = random.nextInt(itemList.size());
            if (gLvl >= 100) {
                gLvl = 100;
            }
            if (Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)100) <= gLvl) {
                generatedLoot.add((Object)new ItemStack((ItemLike)itemList.get(i)));
            }
        }
    }

    private void addLootHasB(ObjectArrayList<ItemStack> generatedLoot, Random random, boolean a, List<Item> itemList, int gLvl) {
        if (a) {
            int i = random.nextInt(itemList.size());
            if (gLvl >= 100) {
                gLvl = 100;
            }
            if (Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)100) <= gLvl) {
                generatedLoot.add((Object)new ItemStack((ItemLike)itemList.get(i)));
            }
        }
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        Player player;
        ResourceLocation s = context.getQueriedLootTableId();
        String idSting = String.valueOf(s);
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        Random random = new Random();
        if (idSting.contains("chests/")) {
            if (idSting.contains("treasure")) {
                this.addLoot(generatedLoot, random, (Item)Items.bat_cell.get(), entity, List.of((Item)Items.cell_blood_attack.get(), (Item)Items.cell_desecrate.get(), (Item)Items.cell_doctor.get(), (Item)Items.cell_fear.get(), (Item)Items.cell_harvest.get(), (Item)Items.cell_immortal.get(), (Item)Items.cell_not_do.get(), (Item)Items.cell_rage.get(), (Item)Items.cell_scientist.get()), (Integer)Config.SERVER.bat.get());
            }
            if (idSting.contains("city") && ((Boolean)Config.SERVER.nine_sword_book.get()).booleanValue()) {
                this.addLootCommon(generatedLoot, random, entity, List.of((Item)Items.nine_sword_books.get()), 2);
            }
            if (idSting.contains("dungeon") || idSting.contains("mineshaft") || idSting.contains("city") || idSting.contains("treasure")) {
                this.addLoot(generatedLoot, random, (Item)Items.nightmareeye.get(), entity, List.of((Item)Items.nightmare_heart.get(), (Item)Items.nightmare_orb.get(), (Item)Items.nightmareanchor.get(), (Item)Items.nightmarecharm.get(), (Item)Items.nightmareeye.get(), (Item)Items.nightmaremoai.get(), (Item)Items.nightmarerotten.get(), (Item)Items.nightmarestone.get(), (Item)Items.nightmaretreasure.get(), (Item)Items.nightmarewater.get()), (Integer)Config.SERVER.night.get());
                this.addLoot(generatedLoot, random, (Item)Items.blood_candle.get(), entity, List.of((Item)Items.owner_blood_eye.get(), (Item)Items.owner_blood_attack_eye.get(), (Item)Items.owner_blood_speed_eye.get(), (Item)Items.owner_blood_effect_eye.get(), (Item)Items.owner_blood_boom_eye.get(), (Item)Items.owner_blood_vex.get(), (Item)Items.owner_blood_earth.get()), 3);
                this.addLoot(generatedLoot, random, (Item)Items.bloodvirus.get(), entity, List.of((Item)Items.batgene.get(), (Item)Items.batskill.get(), (Item)Items.bloodgene.get(), (Item)Items.botton.get(), (Item)Items.catalyzer.get(), (Item)Items.flygene.get(), (Item)Items.heathgene.get(), (Item)Items.ragegene.get(), (Item)Items.sleepgene.get()), (Integer)Config.SERVER.bat.get());
                this.addLoot(generatedLoot, random, (Item)Items.necora.get(), entity, List.of((Item)Items.ambush.get(), (Item)Items.atpoverdose.get(), (Item)Items.autolytic.get(), (Item)Items.fermentation.get(), (Item)Items.putrefactive.get(), (Item)Items.regenerative.get(), (Item)Items.air.get(), (Item)Items.motor.get(), (Item)Items.watergen.get()), (Integer)Config.SERVER.necora.get());
                if (entity instanceof Player) {
                    player = (Player)entity;
                    boolean wind2 = Handler.hascurio((LivingEntity)player, (Item)Items.doomeye.get()) && Handler.hascurio((LivingEntity)player, (Item)Items.doomswoud.get());
                    this.addLootHasB(generatedLoot, random, wind2, List.of((Item)Items.wind_and_rain.get()), 5);
                }
            }
        }
        if (idSting.contains("chests/") && entity instanceof Player) {
            player = (Player)entity;
            if (idSting.contains("treasure")) {
                if (!player.m_19880_().contains("treasureRageEye")) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.rage_eye.get()));
                    player.m_20049_("treasureRageEye");
                }
                boolean ab = !Handler.hascurio((LivingEntity)player, (Item)Items.cell.get()) && !Handler.hascurio((LivingEntity)player, (Item)Items.giant.get()) && Handler.hascurio((LivingEntity)player, (Item)Items.necora.get());
                this.addLootHasB(generatedLoot, random, ab, List.of((Item)Items.cell.get()), 100);
                boolean cellBat = !Handler.hascurio((LivingEntity)player, (Item)Items.bat_cell.get()) && Handler.hascurio((LivingEntity)player, (Item)Items.bloodvirus.get());
                this.addLootHasB(generatedLoot, random, cellBat, List.of((Item)Items.bat_cell.get()), 100);
                if (Handler.hascurio((LivingEntity)player, (Item)Items.necora.get())) {
                    boolean cellGiant = Handler.hascurio((LivingEntity)player, (Item)Items.giant.get());
                    this.addLootHasB(generatedLoot, random, cellGiant, List.of((Item)Items.bone_cell.get(), (Item)Items.parasitic_cell.get(), (Item)Items.mother_cell.get(), (Item)Items.disgusting_cells.get()), (Integer)Config.SERVER.necora.get());
                    boolean cellGiantNig = Handler.hascurio((LivingEntity)player, (Item)Items.giant_nightmare.get());
                    this.addLootHasB(generatedLoot, random, cellGiantNig, List.of((Item)Items.giant_boom_cell.get(), (Item)Items.not_blood_cell.get(), (Item)Items.anaerobic_cell.get(), (Item)Items.subspace_cell.get()), (Integer)Config.SERVER.necora.get());
                    boolean cell2 = Handler.hascurio((LivingEntity)player, (Item)Items.cell.get()) && !Handler.hascurio((LivingEntity)player, (Item)Items.giant.get());
                    this.addLootHasB(generatedLoot, random, cell2, List.of((Item)Items.adrenaline.get(), (Item)Items.cell_mummy.get(), (Item)Items.cell_boom.get(), (Item)Items.cell_calcification.get(), (Item)Items.cell_blood.get()), (Integer)Config.SERVER.necora.get());
                }
            }
        }
        if (idSting.contains("chests/") && idSting.contains("treasure") && entity instanceof Player) {
            player = (Player)entity;
            if (Handler.hascurio((LivingEntity)player, (Item)Items.bloodvirus.get()) && !Handler.hascurio((LivingEntity)player, (Item)Items.bat_cell.get())) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.bat_cell.get()));
            }
            if (Handler.hascurio((LivingEntity)player, (Item)Items.necora.get()) && !Handler.hascurio((LivingEntity)player, (Item)Items.giant.get()) && Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)10) == 1) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.giant.get()));
            }
        }
        for (ItemStack itemStack : generatedLoot) {
            ServerLevel serverLevel = context.m_78952_();
            if (!(itemStack.m_41720_() instanceof Iplague)) continue;
            if (itemStack.m_41783_() == null) {
                itemStack.m_41751_(new CompoundTag());
            }
            if (serverLevel.m_46791_() == Difficulty.PEACEFUL && itemStack.m_41783_() != null) {
                itemStack.m_41783_().m_128379_(Difficulty.PEACEFUL.m_19036_(), true);
            }
            if (serverLevel.m_46791_() == Difficulty.EASY && itemStack.m_41783_() != null) {
                itemStack.m_41783_().m_128379_(Difficulty.EASY.m_19036_(), true);
            }
            if (serverLevel.m_46791_() == Difficulty.NORMAL && itemStack.m_41783_() != null) {
                itemStack.m_41783_().m_128379_(Difficulty.NORMAL.m_19036_(), true);
            }
            if (serverLevel.m_46791_() != Difficulty.HARD) continue;
            int lv = Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)2);
            if (lv == 1) {
                if (itemStack.m_41783_() == null) continue;
                itemStack.m_41783_().m_128379_(Difficulty.HARD.m_19036_(), true);
                continue;
            }
            if (lv != 2 || itemStack.m_41783_() == null) continue;
            itemStack.m_41783_().m_128379_("god_loot", true);
        }
        for (ItemStack itemStack : generatedLoot) {
            BookEvt.addLvl(itemStack, Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)1, (int)3000), Mth.m_216271_((RandomSource)RandomSource.m_216327_(), (int)0, (int)3000));
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

