/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.contents;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.moonstone.moonstonemod.init.moonstoneitem.DataReg;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.math.Fraction;

public class ManBundleContents {
    public static final ManBundleContents EMPTY = new ManBundleContents(List.of());
    public static final Codec<ManBundleContents> CODEC = ItemStack.CODEC.listOf().xmap(ManBundleContents::new, p_331551_ -> p_331551_.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, ManBundleContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(ManBundleContents::new, p_331649_ -> p_331649_.items);
    private static final Fraction BUNDLE_IN_BUNDLE_WEIGHT = Fraction.getFraction((int)1, (int)2);
    private static final int NO_STACK_INDEX = -1;
    final List<ItemStack> items;
    final Fraction weight;

    ManBundleContents(List<ItemStack> items, Fraction weight) {
        this.items = items;
        this.weight = weight;
    }

    public ManBundleContents(List<ItemStack> items) {
        this(items, ManBundleContents.computeContentWeight(items));
    }

    private static Fraction computeContentWeight(List<ItemStack> content) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack itemstack : content) {
            fraction = fraction.add(ManBundleContents.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.getCount(), (int)1)));
        }
        return fraction;
    }

    static Fraction getWeight(ItemStack stack) {
        ManBundleContents bundlecontents = (ManBundleContents)stack.get(DataReg.man);
        if (bundlecontents != null) {
            return BUNDLE_IN_BUNDLE_WEIGHT.add(bundlecontents.weight());
        }
        List list = (List)stack.getOrDefault(DataComponents.BEES, List.of());
        return !list.isEmpty() ? Fraction.ONE : Fraction.getFraction((int)1, (int)2);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean equals(Object other) {
        boolean var10000;
        if (this == other) {
            return true;
        }
        if (other instanceof ManBundleContents) {
            ManBundleContents bundlecontents = (ManBundleContents)other;
            var10000 = this.weight.equals((Object)bundlecontents.weight) && ItemStack.listMatches(this.items, bundlecontents.items);
        } else {
            var10000 = false;
        }
        return var10000;
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "ManBundleContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<ItemStack> items;
        private Fraction weight;

        public Mutable(ManBundleContents contents) {
            this.items = new ArrayList<ItemStack>(contents.items);
            this.weight = contents.weight;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            return this;
        }

        private int findStackIndex(ItemStack stack) {
            if (!stack.isStackable()) {
                return -1;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)this.items.get(i), (ItemStack)stack)) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack stack) {
            Fraction fraction = Fraction.ONE.subtract(this.weight);
            return Math.min(Math.max(fraction.divideBy(ManBundleContents.getWeight(stack)).intValue(), 0), 64);
        }

        public int tryInsert(ItemStack stack) {
            if (!stack.isEmpty() && stack.getItem().canFitInsideContainerItems()) {
                int i = Math.min(stack.getCount(), this.getMaxAmountToAdd(stack));
                int totalItems = this.items.stream().mapToInt(ItemStack::getCount).sum();
                int availableSpace = 2 - totalItems;
                int maxAddable = Math.min(availableSpace, 64);
                if ((i = Math.min(i, maxAddable)) == 0) {
                    return 0;
                }
                this.weight = this.weight.add(ManBundleContents.getWeight(stack).multiplyBy(Fraction.getFraction((int)i, (int)1)));
                int j = this.findStackIndex(stack);
                if (j != -1) {
                    ItemStack itemstack = this.items.remove(j);
                    int newCount = itemstack.getCount() + i;
                    if (newCount > 64) {
                        newCount = 64;
                        i = 64 - itemstack.getCount();
                    }
                    ItemStack itemstack1 = itemstack.copyWithCount(newCount);
                    stack.shrink(i);
                    this.items.addFirst(itemstack1);
                } else {
                    this.items.addFirst(stack.split(i));
                }
                return i;
            }
            return 0;
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            ItemStack itemstack = this.items.removeFirst().copy();
            this.weight = this.weight.subtract(ManBundleContents.getWeight(itemstack).multiplyBy(Fraction.getFraction((int)itemstack.getCount(), (int)1)));
            return itemstack;
        }

        public Fraction weight() {
            return this.weight;
        }

        public ManBundleContents toImmutable() {
            return new ManBundleContents(List.copyOf(this.items), this.weight);
        }
    }
}

