/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.moonstone.moonstonemod.MoonStoneMod;
import com.moonstone.moonstonemod.client.renderer.MRender;
import com.moonstone.moonstonemod.client.renderer.MoonPost;
import com.moonstone.moonstonemod.entity.the_sword;
import com.ytgld.seeking_immortals.ClientConfig;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class TheSwordRender
extends EntityRenderer<the_sword> {
    public TheSwordRender(EntityRendererProvider.Context p_173917_) {
        super(p_173917_);
    }

    public boolean shouldRender(the_sword livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    private static void addSquare(VertexConsumer vertexConsumer, PoseStack poseStack, Vec3 up1, Vec3 up2, Vec3 down1, Vec3 down2, float alpha) {
        vertexConsumer.addVertex(poseStack.last().pose(), (float)up1.x, (float)up1.y, (float)up1.z).setColor(135, 206, 250, (int)(alpha * 255.0f)).setUv2(240, 240).setUv(0.0f, 0.0f).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)down1.x, (float)down1.y, (float)down1.z).setColor(0, 0, 0, (int)(alpha * 255.0f)).setUv2(240, 240).setUv(0.0f, 0.0f).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)down2.x, (float)down2.y, (float)down2.z).setColor(0, 0, 0, (int)(alpha * 255.0f)).setUv2(240, 240).setUv(0.0f, 0.0f).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)up2.x, (float)up2.y, (float)up2.z).setColor(135, 206, 250, (int)(alpha * 255.0f)).setUv2(240, 240).setUv(0.0f, 0.0f).setNormal(0.0f, 0.0f, 1.0f);
    }

    public static void renderLine(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 start, Vec3 end, float a, RenderType renderType, float radius) {
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        int segmentCount = 16;
        for (int i = 0; i < segmentCount; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segmentCount;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segmentCount;
            double x1 = Math.cos(angle1) * (double)radius;
            double z1 = Math.sin(angle1) * (double)radius;
            double x2 = Math.cos(angle2) * (double)radius;
            double z2 = Math.sin(angle2) * (double)radius;
            Vec3 up1 = start.add(x1, 0.0, z1);
            Vec3 up2 = start.add(x2, 0.0, z2);
            Vec3 down1 = end.add(x1, 0.0, z1);
            Vec3 down2 = end.add(x2, 0.0, z2);
            TheSwordRender.addSquare(vertexConsumer, poseStack, up1, up2, down1, down2, a);
        }
    }

    public void render(the_sword entity, float p_114486_, float p_114487_, PoseStack poseStack, MultiBufferSource bufferSource, int p_114490_) {
        super.render((Entity)entity, p_114486_, p_114487_, poseStack, bufferSource, p_114490_);
        if (((Boolean)ClientConfig.CLIENT_CONFIG.Shader.get()).booleanValue()) {
            MoonPost.renderEffectForNextTick(MoonStoneMod.POST_Blood);
        }
        if (entity.getTarget() != null) {
            float sTime = (float)((Integer)entity.getEntityData().get(the_sword.ATTACK_TIME)).intValue() / 300.0f;
            Vec3 entityPos = entity.position();
            Vec3 nearbyEntityPos = entity.getTarget().position();
            Vec3 end = nearbyEntityPos.subtract(entityPos);
            TheSwordRender.renderLine(poseStack, bufferSource, new Vec3(0.0, 0.0, 0.0), end.add(0.0, 1.0, 0.0), sTime, MRender.beacon.apply(ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/blue.png"), true), 0.1f + sTime / 10.0f);
            TheSwordRender.renderLine(poseStack, bufferSource, new Vec3(0.0, 0.0, 0.0), end.add(0.0, 1.0, 0.0), sTime, MRender.LIGHTNING, 0.1f + sTime / 10.0f);
        }
        double x = Mth.lerp((double)p_114487_, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)p_114487_, (double)entity.yOld, (double)entity.getY());
        double z = Mth.lerp((double)p_114487_, (double)entity.zOld, (double)entity.getZ());
        int integer = (Integer)entity.getEntityData().get(the_sword.ARMOR);
        poseStack.pushPose();
        poseStack.mulPose(Axis.XN.rotationDegrees((float)(entity.tickCount * 2)));
        poseStack.mulPose(Axis.YN.rotationDegrees((float)(entity.tickCount * 2)));
        poseStack.mulPose(Axis.ZN.rotationDegrees((float)(entity.tickCount * 2)));
        poseStack.translate(0.0, 0.25, 0.0);
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Item skeletonSkull = Items.SKELETON_SKULL;
        ItemStack skeletonSkullDefaultInstance = skeletonSkull.getDefaultInstance();
        BakedModel model = itemRenderer.getModel(skeletonSkullDefaultInstance, (Level)Minecraft.getInstance().level, null, 0);
        itemRenderer.render(skeletonSkullDefaultInstance, ItemDisplayContext.NONE, false, poseStack, bufferSource, Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords((Entity)entity, 0.0f), OverlayTexture.NO_OVERLAY, model);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.mulPose(Axis.XN.rotationDegrees((float)entity.tickCount * 3.3f));
        poseStack.mulPose(Axis.YN.rotationDegrees((float)entity.tickCount * 3.3f));
        poseStack.mulPose(Axis.ZN.rotationDegrees((float)entity.tickCount * 3.3f));
        poseStack.translate(-0.5, -0.5, -0.5);
        this.renderCubeFace(poseStack, bufferSource, p_114490_, MRender.LIGHTNING, integer - 1, (float)integer / 24.0f);
        this.renderCubeFace(poseStack, bufferSource, p_114490_, MRender.beacon.apply(ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/blue.png"), true), integer - 1, (float)integer / 96.0f);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(2.0f, 2.0f, 2.0f);
        poseStack.mulPose(Axis.XN.rotationDegrees((float)(-entity.tickCount) * 1.3f));
        poseStack.mulPose(Axis.YN.rotationDegrees((float)(-entity.tickCount) * 1.3f));
        poseStack.mulPose(Axis.ZN.rotationDegrees((float)(-entity.tickCount) * 1.3f));
        poseStack.translate(-0.5, -0.5, -0.5);
        this.renderCubeFace2(poseStack, bufferSource, p_114490_, MRender.LIGHTNING, integer - 1, (float)integer / 36.0f);
        this.renderCubeFace2(poseStack, bufferSource, p_114490_, MRender.beacon.apply(ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/blue.png"), true), integer - 1, (float)integer / 128.0f);
        poseStack.popPose();
        if (entity.hasTrail()) {
            poseStack.pushPose();
            poseStack.translate(-x, -y, -z);
            this.renderTrail(entity, p_114487_, poseStack, bufferSource, 0.59607846f, 0.9607843f, 1.0f, 240);
            poseStack.popPose();
        }
    }

    public void setMatrices(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, @NotNull Entity ownerBlood, int rage2) {
        float posAdd = 1.001f;
        BlockPos playerPos = ownerBlood.blockPosition();
        Vec3 playerVec = new Vec3((double)playerPos.getX(), (double)playerPos.getY(), (double)playerPos.getZ());
        for (int x = -rage2; x <= rage2; ++x) {
            for (int y = -rage2; y <= rage2; ++y) {
                for (int z = -rage2; z <= rage2; ++z) {
                    BlockPos currentPos = playerPos.offset(x, y, z);
                    Vec3 currentVec = new Vec3((double)currentPos.getX(), (double)currentPos.getY(), (double)currentPos.getZ());
                    BlockState blockState = ownerBlood.level().getBlockState(currentPos);
                    if (blockState.isEmpty() || !blockState.canOcclude()) continue;
                    matrices.pushPose();
                    matrices.translate((double)currentPos.getX() + 0.5, (double)currentPos.getY() + 0.5, (double)currentPos.getZ() + 0.5);
                    matrices.scale(posAdd, posAdd, posAdd);
                    matrices.translate(-((double)currentPos.getX() + 0.5), -((double)currentPos.getY() + 0.5), -((double)currentPos.getZ() + 0.5));
                    matrices.translate((float)currentPos.getX(), (float)currentPos.getY(), (float)currentPos.getZ());
                    double distance = playerVec.distanceTo(currentVec);
                    float alp = Math.max(0.0f, 1.0f - (float)distance / (float)rage2);
                    BakedModel bakedModel = Minecraft.getInstance().getBlockRenderer().getBlockModel(blockState);
                    for (Direction direction : Direction.values()) {
                        BlockPos offsetPos = currentPos.relative(direction);
                        if (ownerBlood.level().getBlockState(offsetPos).isSolid()) continue;
                        List quads = bakedModel.getQuads(blockState, direction, RandomSource.create());
                        for (BakedQuad quad : quads) {
                            vertexConsumers.getBuffer(MRender.LIGHTNING).putBulkData(matrices.last(), quad, new float[]{1.32f, 1.32f, 1.32f, 1.32f}, 0.0f, 0.0f, 1.0f, alp, new int[]{240, 240, 240, 240}, OverlayTexture.NO_OVERLAY, true);
                        }
                    }
                    matrices.popPose();
                }
            }
        }
    }

    private void renderTrail(the_sword entityIn, float partialTicks, PoseStack poseStack, MultiBufferSource bufferIn, float trailR, float trailG, float trailB, int packedLightIn) {
        int sampleSize = 32;
        float as = 0.3f;
        float trailZRot = 0.0f;
        Vec3 topAngleVec = new Vec3((double)as, (double)as, (double)as).zRot(trailZRot);
        Vec3 bottomAngleVec = new Vec3((double)(-as), (double)(-as), (double)as).zRot(trailZRot);
        Vec3 drawFrom = entityIn.getTrailPosition(0, partialTicks);
        VertexConsumer vertexconsumer = bufferIn.getBuffer(MRender.LIGHTNING);
        for (int samples = 0; samples < sampleSize - 1; ++samples) {
            Vec3 sample = entityIn.getTrailPosition(samples + 1, partialTicks);
            float u1 = (float)samples / (float)sampleSize;
            float u2 = u1 + 1.0f / (float)sampleSize;
            float alpha1 = 1.0f - u1;
            float alpha2 = 1.0f - u2;
            Vec3 draw1 = drawFrom;
            PoseStack.Pose posestack$pose = poseStack.last();
            Matrix4f matrix4f = posestack$pose.pose();
            vertexconsumer.addVertex(matrix4f, (float)draw1.x + (float)bottomAngleVec.x, (float)draw1.y + (float)bottomAngleVec.y, (float)draw1.z + (float)bottomAngleVec.z).setColor(trailR, trailG, trailB, alpha1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLightIn, 240).setNormal(0.0f, 0.0f, 0.0f);
            vertexconsumer.addVertex(matrix4f, (float)sample.x + (float)bottomAngleVec.x, (float)sample.y + (float)bottomAngleVec.y, (float)sample.z + (float)bottomAngleVec.z).setColor(trailR, trailG, trailB, alpha2).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLightIn, 240).setNormal(0.0f, 0.0f, 0.0f);
            vertexconsumer.addVertex(matrix4f, (float)sample.x + (float)topAngleVec.x, (float)sample.y + (float)topAngleVec.y, (float)sample.z + (float)topAngleVec.z).setColor(trailR, trailG, trailB, alpha2).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLightIn, 240).setNormal(0.0f, 0.0f, 0.0f);
            vertexconsumer.addVertex(matrix4f, (float)draw1.x + (float)topAngleVec.x, (float)draw1.y + (float)topAngleVec.y, (float)draw1.z + (float)topAngleVec.z).setColor(trailR, trailG, trailB, alpha1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(packedLightIn, 240).setNormal(0.0f, 0.0f, 0.0f);
            drawFrom = sample;
        }
    }

    public void renderCubeFace(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, RenderType renderType, int face, float a) {
        PoseStack.Pose pose = matrices.last();
        Matrix4f matrix4f = pose.pose();
        float x = 0.5f;
        float y = 0.5f;
        float z = 0.5f;
        float size = 0.5f;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(renderType);
        if (face > 0) {
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 1) {
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 2) {
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 3) {
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 4) {
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 5) {
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
    }

    public void renderCubeFace2(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, RenderType renderType, int face, float a) {
        PoseStack.Pose pose = matrices.last();
        Matrix4f matrix4f = pose.pose();
        float x = 0.5f;
        float y = 0.5f;
        float z = 0.5f;
        float size = 0.5f;
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(renderType);
        if (face > 6) {
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 7) {
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 8) {
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 9) {
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 10) {
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y + size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
        if (face > 11) {
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z + size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x + size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
            vertexConsumer.addVertex(matrix4f, x - size, y - size, z - size).setUv(0.0f, 0.0f).setUv2(light, light).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(0.0f, 0.0f, 0.0f).setColor(0.0f, 0.0f, 1.0f, a);
        }
    }

    public ResourceLocation getTextureLocation(the_sword p_114482_) {
        return ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/entity/flysword.png");
    }
}

