/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity;

import com.moonstone.moonstonemod.init.moonstoneitem.DamageTps;
import com.moonstone.moonstonemod.init.moonstoneitem.Effects;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class flysword
extends ThrowableItemProjectile {
    public int age = 0;
    private LivingEntity target;
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public flysword(EntityType<? extends flysword> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    @NotNull
    protected Item getDefaultItem() {
        return Items.IRON_SWORD;
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    public void tick() {
        super.tick();
        this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        if (this.trailPositions.size() > 8) {
            this.trailPositions.removeFirst();
        }
        this.setNoGravity(true);
        this.age += Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)2);
        if (this.age > 150) {
            this.discard();
        }
        if (!(this.age <= 30 || this.target != null && this.target.isAlive())) {
            this.findNewTarget();
        }
        if (this.target != null) {
            Vec3 targetPos = this.target.position().add(0.0, 0.5, 0.0);
            Vec3 currentPos = this.position();
            Vec3 direction = targetPos.subtract(currentPos).normalize();
            this.setDeltaMovement(direction.x * 0.375, direction.y * 0.375, direction.z * 0.375);
        }
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            OwnableEntity tamableAnimal;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (this.getOwner() == null || entity instanceof OwnableEntity && (tamableAnimal = (OwnableEntity)entity).getOwner() != null && tamableAnimal.getOwner().equals((Object)this.getOwner()) || name.getNamespace().equals("moonstone") || entity.is(this.getOwner()) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }

    protected void onHitEntity(@NotNull EntityHitResult hitResult) {
        Entity entity = hitResult.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living;
            LivingEntity livingEntity = (LivingEntity)entity;
            Entity entity2 = this.getOwner();
            if (entity2 instanceof LivingEntity && !livingEntity.is((Entity)(living = (LivingEntity)entity2))) {
                livingEntity.invulnerableTime = 0;
                livingEntity.hurt(DamageTps.swordDamage(living), 2.0f + living.getMaxHealth() / 20.0f);
                livingEntity.addEffect(new MobEffectInstance(Effects.fear, 100, 0));
                this.discard();
            }
        }
        this.discard();
    }
}

