/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.nightmare;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.moonstone.moonstonemod.entity.extend.MoonTamableAnimal;
import com.moonstone.moonstonemod.entity.nightmare.AInightmare;
import com.moonstone.moonstonemod.entity.nightmare.NearestAttackableTargetGoal;
import com.moonstone.moonstonemod.entity.nightmare.SonicBoom;
import com.moonstone.moonstonemod.entity.zombie.cell_zombie;
import com.moonstone.moonstonemod.init.moonstoneitem.EntityTs;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.AngerManagement;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class nightmare_giant
extends MoonTamableAnimal
implements OwnableEntity,
VibrationSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Integer> CLIENT_ANGER_LEVEL = SynchedEntityData.defineId(nightmare_giant.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int tendrilAnimation;
    private int tendrilAnimationO;
    private int heartAnimation;
    private int heartAnimationO;
    public AnimationState roarAnimationState = new AnimationState();
    public AnimationState sniffAnimationState = new AnimationState();
    public AnimationState emergeAnimationState = new AnimationState();
    public AnimationState diggingAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState sonicBoomAnimationState = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener;
    private final VibrationSystem.User vibrationUser;
    private VibrationSystem.Data vibrationData;
    AngerManagement angerManagement = new AngerManagement(this::canTargetEntity, Collections.emptyList());
    public int time = 0;
    int sZombieTime = 0;

    public nightmare_giant(EntityType<? extends nightmare_giant> p_219350_, Level p_219351_) {
        super(p_219350_, p_219351_);
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new VibrationSystem.Data();
        this.dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
        this.xpReward = 5;
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.UNPASSABLE_RAIL, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 8.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 8.0f);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity getOwner() {
        return super.getOwner();
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352154_) {
        return new ClientboundAddEntityPacket((Entity)this, p_352154_, this.hasPose(Pose.EMERGING) ? 1 : 0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<Villager>(this, Villager.class, false));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<Zombie>(this, Zombie.class, false));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<Spider>(this, Spider.class, false));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<Skeleton>(this, Skeleton.class, false));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<Creeper>(this, Creeper.class, false));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<EnderMan>(this, EnderMan.class, false));
        this.targetSelector.addGoal(7, new NearestAttackableTargetGoal<Monster>(this, Monster.class, false));
        this.targetSelector.addGoal(7, (Goal)new net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_219420_) {
        super.recreateFromPacket(p_219420_);
        if (p_219420_.getData() == 1) {
            this.setPose(Pose.EMERGING);
        }
    }

    public boolean checkSpawnObstruction(LevelReader p_219398_) {
        return super.checkSpawnObstruction(p_219398_) && p_219398_.noCollision((Entity)this, this.getType().getDimensions().makeBoundingBox(this.position()));
    }

    public float getWalkTargetValue(BlockPos p_219410_, LevelReader p_219411_) {
        return 0.0f;
    }

    boolean isDiggingOrEmerging() {
        return this.hasPose(Pose.DIGGING) || this.hasPose(Pose.EMERGING);
    }

    protected boolean canRide(Entity p_219462_) {
        return false;
    }

    public boolean canDisableShield() {
        return true;
    }

    protected float nextStep() {
        return this.moveDist + 0.55f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 150.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 1.5).add(Attributes.ATTACK_DAMAGE, 15.0);
    }

    public boolean dampensVibrations() {
        return true;
    }

    protected float getSoundVolume() {
        return 4.0f;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return !this.hasPose(Pose.ROARING) && !this.isDiggingOrEmerging() ? this.getAngerLevel().getAmbientSound() : null;
    }

    protected SoundEvent getHurtSound(DamageSource p_219440_) {
        return SoundEvents.ZOMBIE_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.ZOMBIE_DEATH;
    }

    protected void playStepSound(BlockPos p_219431_, BlockState p_219432_) {
        this.playSound(SoundEvents.ZOMBIE_STEP, 10.0f, 1.0f);
    }

    @Override
    public boolean doHurtTarget(Entity p_219472_) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        SonicBoom.setCooldown((LivingEntity)this, 40);
        return super.doHurtTarget(p_219472_);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(CLIENT_ANGER_LEVEL, (Object)0);
    }

    public int getClientAngerLevel() {
        return (Integer)this.entityData.get(CLIENT_ANGER_LEVEL);
    }

    private void syncClientAngerLevel() {
        this.entityData.set(CLIENT_ANGER_LEVEL, (Object)this.getActiveAnger());
    }

    @Override
    public void die(@NotNull DamageSource p_21809_) {
        if (this.getTags().contains("Giant_Boom")) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 12.5f, true, Level.ExplosionInteraction.NONE);
        }
    }

    @Override
    public void tick() {
        Level level;
        ResourceLocation entity;
        ++this.time;
        this.time = !this.getTags().contains("Giant_Time") ? (this.time += 3) : (this.time += 2);
        if (this.sZombieTime > 0) {
            --this.sZombieTime;
        }
        if (this.time > 3600) {
            this.discard();
        }
        if (this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent() && (entity = BuiltInRegistries.ENTITY_TYPE.getKey((Object)((LivingEntity)this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get()).getType())).getNamespace().equals("moonstone")) {
            this.setAttackTarget(null);
        }
        Vec3 playerPos = this.position().add(0.0, 1.25, 0.0);
        float range = 16.0f;
        List entities = this.level().getEntitiesOfClass(cell_zombie.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (Entity c : entities) {
            if (!(c instanceof cell_zombie)) continue;
            cell_zombie cellZombie = (cell_zombie)c;
            if (this.tickCount % 20 != 1) continue;
            this.heal(entities.size());
        }
        playerPos = this.position().add(0.0, 0.75, 0.0);
        int range2 = 10;
        entities = this.level().getEntitiesOfClass(Mob.class, new AABB(playerPos.x - (double)range2, playerPos.y - (double)range2, playerPos.z - (double)range2, playerPos.x + (double)range2, playerPos.y + (double)range2, playerPos.z + (double)range2));
        for (Mob mob : entities) {
            ResourceLocation entity2;
            if (this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent() || (entity2 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob.getType())).getNamespace().equals("moonstone") || !this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isEmpty()) continue;
            if (this.sZombieTime <= 0 && this.getOwner() != null) {
                for (int i = 0; i < 2; ++i) {
                    cell_zombie cellZombie = new cell_zombie((EntityType<? extends cell_zombie>)((EntityType)EntityTs.cell_zombie.get()), this.level());
                    cellZombie.teleportTo(this.getX(), this.getY(), this.getZ());
                    cellZombie.setOwnerUUID(this.getOwnerUUID());
                    cellZombie.addTag("DamageCell");
                    cellZombie.addTag("hasNig");
                    this.level().playSound(null, this.getOnPos(), SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.AMBIENT, 10.0f, 10.0f);
                    this.level().addFreshEntity((Entity)cellZombie);
                    this.sZombieTime = 300;
                }
            }
            mob.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0));
            mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 2));
            mob.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 200, 2));
            mob.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200, 2));
            this.setAttackTarget((LivingEntity)mob);
        }
        if (this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).isPresent() && !((LivingEntity)this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get()).isAlive()) {
            this.setAttackTarget(null);
        }
        if (this.getOwner() != null) {
            if (this.getOwner().getLastHurtByMob() != null && !this.getOwner().getLastHurtByMob().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastHurtByMob().getType()).getNamespace().equals("moonstone")) {
                this.setAttackTarget(this.getOwner().getLastHurtByMob());
            }
            if (this.getOwner().getLastAttacker() != null && !this.getOwner().getLastAttacker().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastAttacker().getType()).getNamespace().equals("moonstone")) {
                this.setAttackTarget(this.getOwner().getLastAttacker());
            }
            if (this.getOwner().getLastHurtMob() != null && !this.getOwner().getLastHurtMob().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastHurtMob().getType()).getNamespace().equals("moonstone")) {
                this.setAttackTarget(this.getOwner().getLastHurtMob());
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            VibrationSystem.Ticker.tick((Level)serverlevel, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
            if (this.isPersistenceRequired() || this.requiresCustomPersistence()) {
                AInightmare.setDigCooldown((LivingEntity)this);
            }
        }
        super.tick();
        if (this.level().isClientSide()) {
            if (this.tickCount % this.getHeartBeatDelay() == 0) {
                this.heartAnimation = 10;
            }
            this.tendrilAnimationO = this.tendrilAnimation;
            if (this.tendrilAnimation > 0) {
                --this.tendrilAnimation;
            }
            this.heartAnimationO = this.heartAnimation;
            if (this.heartAnimation > 0) {
                --this.heartAnimation;
            }
            switch (this.getPose()) {
                case EMERGING: {
                    this.clientDiggingParticles(this.emergeAnimationState);
                    break;
                }
                case DIGGING: {
                    this.clientDiggingParticles(this.diggingAnimationState);
                }
            }
        }
    }

    protected void customServerAiStep() {
        ServerLevel serverlevel = (ServerLevel)this.level();
        serverlevel.getProfiler().push("nightmare_giantBrain");
        this.getBrain().tick(serverlevel, (LivingEntity)this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
        if (this.tickCount % 20 == 0) {
            this.angerManagement.tick(serverlevel, this::canTargetEntity);
            this.syncClientAngerLevel();
        }
        AInightmare.updateActivity(this);
    }

    public void handleEntityEvent(byte p_219360_) {
        if (p_219360_ == 4) {
            this.roarAnimationState.stop();
            this.attackAnimationState.start(this.tickCount);
        } else if (p_219360_ == 61) {
            this.tendrilAnimation = 10;
        } else if (p_219360_ == 62) {
            this.sonicBoomAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_219360_);
        }
    }

    private int getHeartBeatDelay() {
        float f = (float)this.getClientAngerLevel() / (float)AngerLevel.ANGRY.getMinimumAnger();
        return 40 - Mth.floor((float)(Mth.clamp((float)f, (float)0.0f, (float)1.0f) * 30.0f));
    }

    public float getTendrilAnimation(float p_219468_) {
        return Mth.lerp((float)p_219468_, (float)this.tendrilAnimationO, (float)this.tendrilAnimation) / 10.0f;
    }

    public float getHeartAnimation(float p_219470_) {
        return Mth.lerp((float)p_219470_, (float)this.heartAnimationO, (float)this.heartAnimation) / 10.0f;
    }

    private void clientDiggingParticles(AnimationState p_219384_) {
        if ((float)p_219384_.getAccumulatedTime() < 4500.0f) {
            RandomSource randomsource = this.getRandom();
            BlockState blockstate = this.getBlockStateOn();
            if (blockstate.getRenderShape() != RenderShape.INVISIBLE) {
                for (int i = 0; i < 30; ++i) {
                    double d0 = this.getX() + (double)Mth.randomBetween((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    double d1 = this.getY();
                    double d2 = this.getZ() + (double)Mth.randomBetween((RandomSource)randomsource, (float)-0.7f, (float)0.7f);
                    this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockstate), d0, d1, d2, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_219422_) {
        if (DATA_POSE.equals(p_219422_)) {
            switch (this.getPose()) {
                case EMERGING: {
                    this.emergeAnimationState.start(this.tickCount);
                    break;
                }
                case DIGGING: {
                    this.diggingAnimationState.start(this.tickCount);
                    break;
                }
                case ROARING: {
                    this.roarAnimationState.start(this.tickCount);
                    break;
                }
                case SNIFFING: {
                    this.sniffAnimationState.start(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(p_219422_);
    }

    public boolean ignoreExplosion() {
        return this.isDiggingOrEmerging();
    }

    protected Brain<?> makeBrain(Dynamic<?> p_219406_) {
        return AInightmare.makeBrain(this, p_219406_);
    }

    public Brain<nightmare_giant> getBrain() {
        return super.getBrain();
    }

    protected void sendDebugPackets() {
        super.sendDebugPackets();
        DebugPackets.sendEntityBrain((LivingEntity)this);
    }

    public void updateDynamicGameEventListener(BiConsumer<DynamicGameEventListener<?>, ServerLevel> p_219413_) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            p_219413_.accept(this.dynamicGameEventListener, serverlevel);
        }
    }

    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable Entity p_219386_) {
        if (p_219386_ instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)p_219386_;
            if (this.getOwner() != null && !livingentity.is((Entity)this.getOwner()) && this.level() == p_219386_.level() && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(p_219386_) && !this.isAlliedTo(p_219386_) && livingentity.getType() != EntityType.ARMOR_STAND && livingentity.getType() != this.getType() && !livingentity.isInvulnerable() && !livingentity.isDeadOrDying() && this.level().getWorldBorder().isWithinBounds(livingentity.getBoundingBox())) {
                return true;
            }
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag p_219434_) {
        super.addAdditionalSaveData(p_219434_);
        AngerManagement.codec(this::canTargetEntity).encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.angerManagement).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219437_ -> p_219434_.put("anger", p_219437_));
        VibrationSystem.Data.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.vibrationData).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219418_ -> p_219434_.put("listener", p_219418_));
    }

    public void readAdditionalSaveData(CompoundTag p_219415_) {
        super.readAdditionalSaveData(p_219415_);
        if (p_219415_.contains("anger")) {
            AngerManagement.codec(this::canTargetEntity).parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_219415_.get("anger"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_219394_ -> {
                this.angerManagement = p_219394_;
            });
            this.syncClientAngerLevel();
        }
        if (p_219415_.contains("listener", 10)) {
            VibrationSystem.Data.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)p_219415_.getCompound("listener"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_281093_ -> {
                this.vibrationData = p_281093_;
            });
        }
    }

    private void playListeningSound() {
        if (!this.hasPose(Pose.ROARING)) {
            this.playSound(this.getAngerLevel().getListeningSound(), 10.0f, this.getVoicePitch());
        }
    }

    public AngerLevel getAngerLevel() {
        return AngerLevel.byAnger((int)this.getActiveAnger());
    }

    private int getActiveAnger() {
        return this.angerManagement.getActiveAnger((Entity)this.getTarget());
    }

    public void clearAnger(Entity p_219429_) {
        this.angerManagement.clearAnger(p_219429_);
    }

    public void increaseAngerAt(@Nullable Entity p_219442_) {
        this.increaseAngerAt(p_219442_, 35, true);
    }

    @VisibleForTesting
    public void increaseAngerAt(@Nullable Entity p_219388_, int p_219389_, boolean p_219390_) {
        if (!this.isNoAi() && this.canTargetEntity(p_219388_)) {
            AInightmare.setDigCooldown((LivingEntity)this);
            boolean flag = !(this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null) instanceof Player);
            int i = this.angerManagement.increaseAnger(p_219388_, p_219389_);
            if (p_219388_ instanceof Player && flag && AngerLevel.byAnger((int)i).isAngry()) {
                this.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            }
            if (p_219390_) {
                this.playListeningSound();
            }
        }
    }

    public Optional<LivingEntity> getEntityAngryAt() {
        return this.getAngerLevel().isAngry() ? this.angerManagement.getActiveEntity() : Optional.empty();
    }

    @Nullable
    public LivingEntity getTarget() {
        return this.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
    }

    public boolean removeWhenFarAway(double p_219457_) {
        return false;
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    public boolean hurt(DamageSource p_219381_, float p_219382_) {
        boolean flag = super.hurt(p_219381_, p_219382_);
        if (!(this.level().isClientSide || this.isNoAi() || this.isDiggingOrEmerging())) {
            Entity entity = p_219381_.getEntity();
            this.increaseAngerAt(entity, AngerLevel.ANGRY.getMinimumAnger() + 20, false);
            if (this.brain.getMemory(MemoryModuleType.ATTACK_TARGET).isEmpty() && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (!(p_219381_.isDirect() && !this.closerThan((Entity)livingentity, 5.0) || this.getOwner() == null || livingentity.is((Entity)this.getOwner()))) {
                    this.setAttackTarget(livingentity);
                }
            }
        }
        return flag;
    }

    public void setAttackTarget(LivingEntity p_219460_) {
        this.getBrain().eraseMemory(MemoryModuleType.ROAR_TARGET);
        this.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)p_219460_);
        this.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        SonicBoom.setCooldown((LivingEntity)this, 20);
    }

    public boolean isPushable() {
        return !this.isDiggingOrEmerging() && super.isPushable();
    }

    protected void doPush(Entity p_219353_) {
        if (!this.isNoAi() && !this.getBrain().hasMemoryValue(MemoryModuleType.TOUCH_COOLDOWN)) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.TOUCH_COOLDOWN, (Object)Unit.INSTANCE, 20L);
            this.increaseAngerAt(p_219353_);
        }
        super.doPush(p_219353_);
    }

    @VisibleForTesting
    public AngerManagement getAngerManagement() {
        return this.angerManagement;
    }

    protected PathNavigation createNavigation(Level p_219396_) {
        return new GroundPathNavigation(this, (Mob)this, p_219396_){

            protected PathFinder createPathFinder(int p_219479_) {
                this.nodeEvaluator = new WalkNodeEvaluator();
                this.nodeEvaluator.setCanPassDoors(true);
                return new PathFinder(this, this.nodeEvaluator, p_219479_){

                    protected float distance(Node p_219486_, Node p_219487_) {
                        return p_219486_.distanceToXZ(p_219487_);
                    }
                };
            }
        };
    }

    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }

    class VibrationUser
    implements VibrationSystem.User {
        private static final int GAME_EVENT_LISTENER_RANGE = 16;
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)nightmare_giant.this, nightmare_giant.this.getEyeHeight());
        }

        public int getListenerRadius() {
            return 16;
        }

        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.WARDEN_CAN_LISTEN;
        }

        public boolean canTriggerAvoidVibration() {
            return true;
        }

        public boolean canReceiveVibration(ServerLevel p_282574_, BlockPos p_282323_, Holder<GameEvent> p_316784_, GameEvent.Context p_282515_) {
            if (!(nightmare_giant.this.isNoAi() || nightmare_giant.this.isDeadOrDying() || nightmare_giant.this.getBrain().hasMemoryValue(MemoryModuleType.VIBRATION_COOLDOWN) || nightmare_giant.this.isDiggingOrEmerging() || !p_282574_.getWorldBorder().isWithinBounds(p_282323_))) {
                LivingEntity livingentity;
                Entity entity = p_282515_.sourceEntity();
                return !(entity instanceof LivingEntity) || nightmare_giant.this.canTargetEntity((Entity)(livingentity = (LivingEntity)entity));
            }
            return false;
        }

        public void onReceiveVibration(ServerLevel p_281325_, BlockPos p_282386_, Holder<GameEvent> p_316139_, @Nullable Entity p_281438_, @Nullable Entity p_282582_, float p_283699_) {
            if (!nightmare_giant.this.isDeadOrDying()) {
                nightmare_giant.this.brain.setMemoryWithExpiry(MemoryModuleType.VIBRATION_COOLDOWN, (Object)Unit.INSTANCE, 40L);
                p_281325_.broadcastEntityEvent((Entity)nightmare_giant.this, (byte)61);
                nightmare_giant.this.playSound(SoundEvents.WARDEN_TENDRIL_CLICKS, 5.0f, nightmare_giant.this.getVoicePitch());
                BlockPos blockpos = p_282386_;
                if (p_282582_ != null) {
                    if (nightmare_giant.this.closerThan(p_282582_, 30.0)) {
                        if (nightmare_giant.this.getBrain().hasMemoryValue(MemoryModuleType.RECENT_PROJECTILE)) {
                            if (nightmare_giant.this.canTargetEntity(p_282582_)) {
                                blockpos = p_282582_.blockPosition();
                            }
                            nightmare_giant.this.increaseAngerAt(p_282582_);
                        } else {
                            nightmare_giant.this.increaseAngerAt(p_282582_, 10, true);
                        }
                    }
                    nightmare_giant.this.getBrain().setMemoryWithExpiry(MemoryModuleType.RECENT_PROJECTILE, (Object)Unit.INSTANCE, 100L);
                } else {
                    nightmare_giant.this.increaseAngerAt(p_281438_);
                }
                if (!nightmare_giant.this.getAngerLevel().isAngry()) {
                    Optional optional = nightmare_giant.this.angerManagement.getActiveEntity();
                    if (p_282582_ != null || optional.isEmpty() || optional.get() == p_281438_) {
                        AInightmare.setDisturbanceLocation(nightmare_giant.this, blockpos);
                    }
                }
            }
        }
    }
}

