/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.item.maxitem;

import com.moonstone.moonstonemod.init.items.Items;
import com.ytgld.seeking_immortals.Config;
import com.ytgld.seeking_immortals.Handler;
import com.ytgld.seeking_immortals.init.Effects;
import com.ytgld.seeking_immortals.item.nightmare.extend.INightmare;
import com.ytgld.seeking_immortals.item.nightmare.tip.Terror;
import com.ytgld.seeking_immortals.renderer.MRender;
import com.ytgld.seeking_immortals.renderer.light.Light;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CurioAttributeModifiers;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.common.CuriosRegistry;

public class immortal
extends Item
implements ICurioItem,
INightmare,
Terror {
    public static final String transmigrateTag = "TransmigrateTag";

    @Override
    public ResourceLocation image(@Nullable LivingEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/gui/tooltip/fire.png");
    }

    @Override
    @Nullable
    public Map<Integer, Component> describe(ItemStack stack) {
        return null;
    }

    @Override
    public int maxLevel(ItemStack stack) {
        return 1;
    }

    @Override
    public int nowLevel(ItemStack stack) {
        return 1;
    }

    @Override
    public boolean showFire(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isRot(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTrail(ItemStack stack) {
        return false;
    }

    @Override
    public RenderType getTrailRenderType(ItemStack stack) {
        return MRender.light;
    }

    @Override
    public int color(ItemStack stack) {
        return Light.ARGB.color(255, 255, 0, 100);
    }

    public immortal() {
        super(new Item.Properties().stacksTo(1).component(CuriosRegistry.CURIO_ATTRIBUTE_MODIFIERS, (Object)CurioAttributeModifiers.EMPTY).durability(1000000000).rarity(Rarity.UNCOMMON));
    }

    public static void CurioHurt(LivingIncomingDamageEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                int lvl = Mth.nextInt((RandomSource)RandomSource.create(), (int)1, (int)100);
                if (Handler.hascurio((LivingEntity)player, (Item)Items.immortal.get()) && lvl <= (Integer)Config.SERVER.immortal.get()) {
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_HIT_PLAYER, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    if (living.getHealth() <= living.getMaxHealth() * 0.7f) {
                        living.hurt(living.damageSources().dryOut(), event.getAmount() * 0.5f);
                    } else {
                        living.invulnerableTime = 0;
                        living.hurt(living.damageSources().dryOut(), event.getAmount() * 1.5f);
                    }
                    event.setAmount(0.0f);
                }
            }
        }
    }

    public static void livDead(LivingDeathEvent event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            Player player;
            LivingEntity living = (LivingEntity)entity;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)livingEntity), (Item)Items.immortal.get())) {
                living.hurt(living.damageSources().dryOut(), living.getHealth() * 0.2f);
                living.addEffect(new MobEffectInstance(Effects.dead, 200, 9));
            }
        }
    }

    @NotNull
    public Component getName(@NotNull ItemStack stack) {
        Component component = super.getName(stack);
        MutableComponent co = component.copy();
        co.setStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)-65536)));
        return co;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Vec3 playerPos = player.position().add(0.0, 0.75, 0.0);
            int range = 8;
            List entities = player.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            for (LivingEntity living : entities) {
                if (living.is((Entity)player) || player.tickCount % 100 != 1) continue;
                living.addEffect(new MobEffectInstance(Effects.dead, 600, 0));
                if (living.getEffect(Effects.dead) == null) continue;
                if (living.getEffect(Effects.dead).getAmplifier() < 5) {
                    living.addEffect(new MobEffectInstance(Effects.dead, 600, living.getEffect(Effects.dead).getAmplifier() + 1));
                    continue;
                }
                living.addEffect(new MobEffectInstance(Effects.dead, 600, 5));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext level, List<Component> tooltip, TooltipFlag flags) {
        super.appendHoverText(stack, level, tooltip, flags);
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string").withStyle(ChatFormatting.RED));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string.1").withStyle(ChatFormatting.RED));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string.2").withStyle(ChatFormatting.RED));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string.3").withStyle(ChatFormatting.RED));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string.4").withStyle(ChatFormatting.RED));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string.5").withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"key.keyboard.left.shift").withStyle(ChatFormatting.DARK_RED));
            tooltip.add((Component)Component.literal((String)""));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string.6").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string.7").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD));
            tooltip.add((Component)Component.translatable((String)"item.immortal.tool.string.8").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD));
        }
    }
}

