/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.tbl.client.handler;

import com.all.ILevelRender;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.moonstone.moonstonemod.MoonStoneMod;
import com.moonstone.tbl.client.shader.ShaderHelper;
import com.moonstone.tbl.client.shader.postprocessing.DiffBlitDepth;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class ShaderHandler {
    public static final ResourceLocation DIFFBLITDEPTH_LOCAL = ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"shaders/post/diffblitdepth.json");
    @Nullable
    public static DiffBlitDepth diffBlitDepth;

    public static void loadWorldShader(ResourceProvider resourceProvider) {
        try {
            diffBlitDepth = new DiffBlitDepth(Minecraft.getInstance().getTextureManager(), resourceProvider, Minecraft.getInstance().getMainRenderTarget());
        }
        catch (IOException ioexception) {
            MoonStoneMod.LOGGER.warn("Failed to load shader: {}", (Object)DIFFBLITDEPTH_LOCAL, (Object)ioexception);
        }
        catch (JsonSyntaxException jsonsyntaxexception) {
            MoonStoneMod.LOGGER.warn("Failed to parse shader: {}", (Object)DIFFBLITDEPTH_LOCAL, (Object)jsonsyntaxexception);
        }
    }

    public static void onRenderWeather(RenderLevelStageEvent event) {
        LevelRenderer levelRenderer;
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER && (levelRenderer = Minecraft.getInstance().levelRenderer) instanceof ILevelRender) {
            ILevelRender levelRender = (ILevelRender)levelRenderer;
            if (levelRender.moonstone1_21_1$transparencyChain() != null) {
                if (ShaderHelper.INSTANCE.getWorldShader() != null) {
                    ShaderHelper.INSTANCE.getWorldShader().getDepthBuffer().copyDepthFrom(Minecraft.getInstance().getMainRenderTarget());
                }
                Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
            }
            if (ShaderHelper.INSTANCE.getWorldShader() != null) {
                ShaderHelper.INSTANCE.getWorldShader().updateMatrices(event);
                ShaderHandler.renderWorldShader(event.getRenderTick());
            }
        }
    }

    public static void renderWorldShader(float partialTick) {
        if (ShaderHelper.INSTANCE.canUseShaders() && ShaderHelper.INSTANCE.getWorldShader() != null) {
            ShaderHelper.INSTANCE.getWorldShader().uploadUniforms();
            ShaderHelper.INSTANCE.getWorldShader().process(partialTick);
            ShaderHelper.INSTANCE.getWorldShader().cleanUp();
        }
    }

    public static void onPreRenderDebug(PoseStack poseStack, MultiBufferSource buffer, Camera camera) {
        LevelRenderer levelRenderer = Minecraft.getInstance().levelRenderer;
        if (levelRenderer instanceof ILevelRender) {
            ILevelRender levelRender = (ILevelRender)levelRenderer;
            if (!ShaderHelper.INSTANCE.canUseShaders() || levelRender.moonstone1_21_1$transparencyChain() != null) {
                return;
            }
        }
        if (diffBlitDepth != null) {
            ShaderHandler.diffBlitDepth.AfterTarget.copyDepthFrom(Minecraft.getInstance().getMainRenderTarget());
        }
        RenderSystem.enableDepthTest();
        if (diffBlitDepth != null) {
            diffBlitDepth.process(Minecraft.getInstance().getTimer().getRealtimeDeltaTicks());
        }
        if (ShaderHelper.INSTANCE.getWorldShader() != null && diffBlitDepth != null) {
            ShaderHelper.INSTANCE.getWorldShader().getDepthBuffer().copyDepthFrom(ShaderHandler.diffBlitDepth.Output);
        }
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
    }

    public static void onPreTranslucentBatch() {
        if (diffBlitDepth != null) {
            ShaderHandler.diffBlitDepth.Base.copyDepthFrom(Minecraft.getInstance().getMainRenderTarget());
        }
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
    }

    public static void onPostTranslucentBatch() {
        if (diffBlitDepth != null) {
            ShaderHandler.diffBlitDepth.BeforeTarget.copyDepthFrom(Minecraft.getInstance().getMainRenderTarget());
        }
        Minecraft.getInstance().getMainRenderTarget().bindWrite(false);
    }

    public static void resize(int width, int height) {
        if (diffBlitDepth != null) {
            diffBlitDepth.resize(width, height);
        }
        if (ShaderHelper.INSTANCE.getWorldShader() != null) {
            ShaderHelper.INSTANCE.getWorldShader().resize(width, height);
        }
    }
}

