/*
 * Decompiled with CFR 0.152.
 */
package com.ytgld.seeking_immortals.test_entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class orb_entity
extends ThrowableItemProjectile {
    public int r = 255;
    public int g = 0;
    public int b = 255;
    public boolean lColor = false;
    public boolean canSee = true;
    public int live = 50;
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public orb_entity(EntityType<? extends orb_entity> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setNoGravity(true);
        this.noPhysics = true;
    }

    protected void checkSupportingBlock(boolean onGround, @Nullable Vec3 movement) {
    }

    public void tick() {
        this.setNoGravity(true);
        if (!this.lColor) {
            this.r = Mth.nextInt((RandomSource)RandomSource.create(), (int)100, (int)255);
            this.g = Mth.nextInt((RandomSource)RandomSource.create(), (int)0, (int)25);
            this.b = Mth.nextInt((RandomSource)RandomSource.create(), (int)175, (int)255);
            this.lColor = true;
        }
        if (this.canSee) {
            this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        }
        if (!(this.trailPositions.isEmpty() || this.trailPositions.size() <= 20 && this.canSee)) {
            this.trailPositions.removeFirst();
        }
        if (this.canSee) {
            if (this.getOwner() != null && this.tickCount > 6) {
                Vec3 targetPos = this.getOwner().position().add(0.0, 0.0, 0.0);
                Vec3 currentPos = this.position();
                Vec3 direction = targetPos.subtract(currentPos).normalize();
                Vec3 currentDirection = this.getDeltaMovement().normalize();
                double angle = Math.acos(currentDirection.dot(direction)) * 57.29577951308232;
                if (angle > 7.5) {
                    double angleLimit = Math.toRadians(7.5);
                    Vec3 limitedDirection = currentDirection.scale(Math.cos(angleLimit)).add(direction.normalize().scale(Math.sin(angleLimit)));
                    this.setDeltaMovement(limitedDirection.x * (double)0.3f, limitedDirection.y * (double)0.3f, limitedDirection.z * (double)0.3f);
                } else {
                    this.setDeltaMovement(direction.x * (double)0.3f, direction.y * (double)0.3f, direction.z * (double)0.3f);
                }
            }
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        if (this.tickCount > 120) {
            this.canSee = false;
            --this.live;
        } else if (!this.canSee) {
            --this.live;
        }
        if (this.live <= 0) {
            this.discard();
        }
        if (this.canSee) {
            Vec3 playerPos = this.position();
            float range = 2.0f;
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            for (LivingEntity living : entities) {
                if (this.getOwner() == null || living.is(this.getOwner()) || this.tickCount <= 15) continue;
                living.hurt(living.damageSources().magic(), 4.0f);
                living.invulnerableTime = 0;
                living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 1));
                living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 1));
                living.addEffect(new MobEffectInstance(MobEffects.WITHER, 100, 1));
                this.level().addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                this.canSee = false;
            }
            super.tick();
        }
    }

    public void playerTouch(Player player) {
        if (this.canSee) {
            this.level().addParticle((ParticleOptions)ParticleTypes.SONIC_BOOM, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            this.canSee = false;
        }
        if (this.live <= 0) {
            this.discard();
        }
    }

    public float getDistanceToGround() {
        Vec3 position = this.position();
        BlockPos blockPos = new BlockPos((int)position.x, (int)position.y, (int)position.z);
        BlockPos groundPos = blockPos.below();
        while (groundPos.getY() > -100 && this.level().getBlockState(groundPos).isAir()) {
            groundPos = groundPos.below();
        }
        Vec3 groundCenter = new Vec3((double)groundPos.getX() + 0.5, (double)groundPos.getY() + 0.5, (double)groundPos.getZ() + 0.5);
        return (float)position.distanceTo(groundCenter);
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    @NotNull
    protected Item getDefaultItem() {
        return Items.IRON_SWORD;
    }
}

