/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.other.AttReg;
import com.moonstone.moonstonemod.init.other.DataReg;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import vazkii.patchouli.api.PatchouliAPI;

public class Book
extends Item
implements ICurioItem {
    public static final String nineSword = "nineSword";
    public static final String MoDiBlood = "MoDiBlood";

    public Book() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    public boolean overrideOtherStackedOnMe(ItemStack me, ItemStack Other, Slot p_150744_, ClickAction p_150745_, Player p_150746_, SlotAccess p_150747_) {
        if (me.getCount() != 1) {
            return false;
        }
        if (p_150745_ == ClickAction.SECONDARY && p_150744_.allowModification(p_150746_) && Other.isEmpty()) {
            if (ModList.get().isLoaded("patchouli")) {
                if (p_150746_ instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)p_150746_;
                    PatchouliAPI.get().openBookGUI(player, ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"soul_book"));
                }
            } else {
                p_150746_.displayClientMessage((Component)Component.translatable((String)"moonstone.book.error").withStyle(ChatFormatting.RED), true);
            }
            return true;
        }
        return false;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        HashMultimap linkedHashMultimap = HashMultimap.create();
        CuriosApi.addSlotModifier((Multimap)linkedHashMultimap, (String)"curio", (ResourceLocation)ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), (double)1.0, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_VALUE);
        return linkedHashMultimap;
    }

    public void onEquip(SlotContext slotContext, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            slotContext.entity().getAttributes().addTransientAttributeModifiers(this.Head(player, stack));
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            slotContext.entity().getAttributes().removeAttributeModifiers(this.Head(player, stack));
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (stack.get(DataReg.tag) == null) {
            stack.set(DataReg.tag, (Object)new CompoundTag());
        }
    }

    public InteractionResultHolder<ItemStack> use(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        if (ModList.get().isLoaded("patchouli")) {
            if (p_41433_ instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)p_41433_;
                PatchouliAPI.get().openBookGUI(player, ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"soul_book"));
            }
        } else {
            p_41433_.displayClientMessage((Component)Component.translatable((String)"moonstone.book.error").withStyle(ChatFormatting.RED), true);
        }
        return super.use(p_41432_, p_41433_, p_41434_);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        if (Screen.hasShiftDown()) {
            pTooltipComponents.add((Component)Component.translatable((String)"item.book.tool.string").withStyle(ChatFormatting.GOLD));
            if (pStack.get(DataReg.tag) != null) {
                if (((CompoundTag)pStack.get(DataReg.tag)).getInt(nineSword) >= 300) {
                    pTooltipComponents.add((Component)Component.translatable((String)"item.book.tool.string.nine_sword").withStyle(ChatFormatting.AQUA));
                }
                if (((CompoundTag)pStack.get(DataReg.tag)).getInt(MoDiBlood) >= 100) {
                    pTooltipComponents.add((Component)Component.translatable((String)"item.book.tool.string.modi_blood").withStyle(ChatFormatting.AQUA));
                }
            }
        } else {
            pTooltipComponents.add((Component)Component.literal((String)"Shift").withStyle(ChatFormatting.GOLD));
        }
    }

    private Multimap<Holder<Attribute>, AttributeModifier> Head(Player player, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (stack.get(DataReg.tag) != null && ((CompoundTag)stack.get(DataReg.tag)).getInt(MoDiBlood) >= 100) {
            multimap.put(AttReg.heal, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        if (player.getMainHandItem().getItem() instanceof SwordItem && stack.get(DataReg.tag) != null && ((CompoundTag)stack.get(DataReg.tag)).getInt(nineSword) >= 300) {
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)("base_attack_damage" + this.getDescriptionId())), 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        }
        return multimap;
    }

    public static void hurt(LivingIncomingDamageEvent event) {
        Player player;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && Handler.hascurio((LivingEntity)(player = (Player)entity), (Item)Items.book.get())) {
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(handler -> {
                Map curios = handler.getCurios();
                for (Map.Entry entry : curios.entrySet()) {
                    ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                        ItemStack stack = stackHandler.getStackInSlot(i);
                        if (stack.isEmpty() || !stack.is((Item)Items.book.get())) continue;
                        if (stack.get(DataReg.tag) != null && player.getMainHandItem().isEmpty() && ((CompoundTag)stack.get(DataReg.tag)).getInt(MoDiBlood) <= 100) {
                            ((CompoundTag)stack.get(DataReg.tag)).putInt(MoDiBlood, ((CompoundTag)stack.get(DataReg.tag)).getInt(MoDiBlood) + 1);
                        }
                        if (!(player.getMainHandItem().getItem() instanceof SwordItem) || stack.get(DataReg.tag) == null || ((CompoundTag)stack.get(DataReg.tag)).getInt(nineSword) > 300) continue;
                        ((CompoundTag)stack.get(DataReg.tag)).putInt(nineSword, ((CompoundTag)stack.get(DataReg.tag)).getInt(nineSword) + 1);
                    }
                }
            });
        }
    }

    public static boolean isHasMaxInt(Player player, String string, int max) {
        if (CuriosApi.getCuriosInventory((LivingEntity)player).isPresent()) {
            Map curios = ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)player).get()).getCurios();
            for (Map.Entry entry : curios.entrySet()) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)entry.getValue();
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    if (!stack.is(Items.book) || stack.get(DataReg.tag) == null || ((CompoundTag)stack.get(DataReg.tag)).getInt(string) < max) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

