/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.logging.LogUtils;
import com.moonstone.moonstonemod.client.model.SwordSoul2Use;
import com.moonstone.moonstonemod.client.model.SwordSoul2UseOutline;
import com.moonstone.moonstonemod.client.particle.BloodPart;
import com.moonstone.moonstonemod.client.particle.BluePart;
import com.moonstone.moonstonemod.client.particle.PoprPart;
import com.moonstone.moonstonemod.client.particle.RedPart;
import com.moonstone.moonstonemod.client.renderer.MRender;
import com.moonstone.moonstonemod.crafting.AllCrafting;
import com.moonstone.moonstonemod.crafting.MoonRecipeProvider;
import com.moonstone.moonstonemod.entity.client.AsSwordRender;
import com.moonstone.moonstonemod.entity.client.AtSwordRender;
import com.moonstone.moonstonemod.entity.client.AttackBloodRender;
import com.moonstone.moonstonemod.entity.client.AxeRenderer;
import com.moonstone.moonstonemod.entity.client.BloodRender;
import com.moonstone.moonstonemod.entity.client.CoffinRender;
import com.moonstone.moonstonemod.entity.client.LineRenderer;
import com.moonstone.moonstonemod.entity.client.OwnerBloodRenderer;
import com.moonstone.moonstonemod.entity.client.SwordOfTwelveRenderer;
import com.moonstone.moonstonemod.entity.client.SwordRenderer;
import com.moonstone.moonstonemod.entity.client.TheSwordRender;
import com.moonstone.moonstonemod.entity.client.YtgldRender;
import com.moonstone.moonstonemod.entity.client.blood.BloodBatRenderer;
import com.moonstone.moonstonemod.entity.client.zombie.CellZombieG;
import com.moonstone.moonstonemod.entity.client.zombie.CellZombieN;
import com.moonstone.moonstonemod.entity.client.zombie.ZombieRenderer;
import com.moonstone.moonstonemod.event.AllEvent;
import com.moonstone.moonstonemod.event.BookEvt;
import com.moonstone.moonstonemod.event.EquippedEvt;
import com.moonstone.moonstonemod.event.MEvent;
import com.moonstone.moonstonemod.event.NewEvent;
import com.moonstone.moonstonemod.event.TextEvt;
import com.moonstone.moonstonemod.event.Village;
import com.moonstone.moonstonemod.event.ZombieEvent;
import com.moonstone.moonstonemod.event.loot.LootEvent;
import com.moonstone.moonstonemod.event.loot.LootTableEvent;
import com.moonstone.moonstonemod.init.Tab;
import com.moonstone.moonstonemod.init.items.BookItems;
import com.moonstone.moonstonemod.init.items.DNAItems;
import com.moonstone.moonstonemod.init.items.Drugs;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.other.AttReg;
import com.moonstone.moonstonemod.init.other.DataReg;
import com.moonstone.moonstonemod.init.other.Effects;
import com.moonstone.moonstonemod.init.other.EntityTs;
import com.moonstone.moonstonemod.init.other.LootReg;
import com.moonstone.moonstonemod.init.other.Particles;
import com.ytgld.seeking_immortals.ClientConfig;
import com.ytgld.seeking_immortals.Config;
import com.ytgld.seeking_immortals.client.particle.blood;
import com.ytgld.seeking_immortals.client.particle.cube;
import com.ytgld.seeking_immortals.event.key.ClientEvent;
import com.ytgld.seeking_immortals.event.key.SINetworkHandler;
import com.ytgld.seeking_immortals.event.now.EventHandler;
import com.ytgld.seeking_immortals.event.old.AdvancementEvt;
import com.ytgld.seeking_immortals.init.Keys;
import com.ytgld.seeking_immortals.item.an_element.NightmareTooltip;
import com.ytgld.seeking_immortals.item.nightmare.tip.ToolTip;
import com.ytgld.seeking_immortals.test_entity.client.LightingRender;
import com.ytgld.seeking_immortals.test_entity.client.OrbEntityRenderer;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="moonstone")
public class MoonStoneMod {
    public static final String MODID = "moonstone";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation POST_Blood = ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"shaders/post/entity_outline_blood.json");

    private void registerPayloadHandler(RegisterPayloadHandlersEvent evt) {
        SINetworkHandler.register(evt.registrar("1.0"));
    }

    public MoonStoneMod(IEventBus eventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)new com.ytgld.seeking_immortals.event.old.NewEvent());
        NeoForge.EVENT_BUS.register((Object)new AdvancementEvt());
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
        eventBus.addListener(this::registerPayloadHandler);
        com.ytgld.seeking_immortals.init.Effects.REGISTRY.register(eventBus);
        com.ytgld.seeking_immortals.init.AttReg.REGISTRY.register(eventBus);
        com.ytgld.seeking_immortals.init.DataReg.REGISTRY.register(eventBus);
        com.ytgld.seeking_immortals.init.Items.REGISTRY.register(eventBus);
        com.ytgld.seeking_immortals.init.EntityTs.REGISTRY.register(eventBus);
        com.ytgld.seeking_immortals.init.Particles.PARTICLE_TYPES.register(eventBus);
        com.ytgld.seeking_immortals.init.Tab.TABS.register(eventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.fc);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.CLIENT);
        NeoForge.EVENT_BUS.register((Object)new AllEvent());
        NeoForge.EVENT_BUS.register((Object)new LootEvent());
        NeoForge.EVENT_BUS.register((Object)new Village());
        NeoForge.EVENT_BUS.register((Object)new LootTableEvent());
        NeoForge.EVENT_BUS.register((Object)new NewEvent());
        NeoForge.EVENT_BUS.register((Object)new BookEvt());
        NeoForge.EVENT_BUS.register((Object)new EquippedEvt());
        NeoForge.EVENT_BUS.register((Object)new TextEvt());
        NeoForge.EVENT_BUS.register((Object)new MEvent());
        NeoForge.EVENT_BUS.register((Object)new ZombieEvent());
        Drugs.REGISTRY.register(eventBus);
        BookItems.REGISTRY.register(eventBus);
        AttReg.REGISTRY.register(eventBus);
        DNAItems.REGISTRY.register(eventBus);
        LootReg.REGISTRY.register(eventBus);
        EntityTs.REGISTRY.register(eventBus);
        DataReg.REGISTRY.register(eventBus);
        Effects.REGISTRY.register(eventBus);
        Particles.PARTICLE_TYPES.register(eventBus);
        Items.REGISTRY.register(eventBus);
        AllCrafting.RECIPE_SERIALIZER_REGISTRY.register(eventBus);
        eventBus.addListener(this::gatherData);
        Tab.TABS.register(eventBus);
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new MoonRecipeProvider(packOutput, lookupProvider));
    }

    @EventBusSubscriber(modid="moonstone", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class Client {
        public static ModelLayerLocation SWORD = Client.register("use_sword_model");
        public static ModelLayerLocation SWORDOut = Client.register("use_sword_model");

        @SubscribeEvent
        public static void EntityRenderersEvent(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(SWORD, SwordSoul2Use::createBodyLayer);
            event.registerLayerDefinition(SWORDOut, SwordSoul2UseOutline::createBodyLayer);
        }

        private static ModelLayerLocation register(String model) {
            return new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"model"), model);
        }

        public static void renderPoseStack(@NotNull PoseStack matrices, @NotNull VertexConsumer vertexConsumer, int light, float s, float a) {
            int stacks = 10;
            int slices = 10;
            for (int i = 0; i < stacks; ++i) {
                float phi0 = (float)Math.PI * ((float)(i + 0) / (float)stacks);
                float phi1 = (float)Math.PI * ((float)(i + 1) / (float)stacks);
                for (int j = 0; j < slices; ++j) {
                    float theta0 = (float)Math.PI * 2 * ((float)(j + 0) / (float)slices);
                    float theta1 = (float)Math.PI * 2 * ((float)(j + 1) / (float)slices);
                    float x0 = s * (float)Math.sin(phi0) * (float)Math.cos(theta0);
                    float y0 = s * (float)Math.cos(phi0);
                    float z0 = s * (float)Math.sin(phi0) * (float)Math.sin(theta0);
                    float x1 = s * (float)Math.sin(phi0) * (float)Math.cos(theta1);
                    float y1 = s * (float)Math.cos(phi0);
                    float z1 = s * (float)Math.sin(phi0) * (float)Math.sin(theta1);
                    float x2 = s * (float)Math.sin(phi1) * (float)Math.cos(theta1);
                    float y2 = s * (float)Math.cos(phi1);
                    float z2 = s * (float)Math.sin(phi1) * (float)Math.sin(theta1);
                    float x3 = s * (float)Math.sin(phi1) * (float)Math.cos(theta0);
                    float y3 = s * (float)Math.cos(phi1);
                    float z3 = s * (float)Math.sin(phi1) * (float)Math.sin(theta0);
                    vertexConsumer.addVertex(matrices.last().pose(), x0, y0, z0).setColor(1.0f, 0.0f, 0.0f, a).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                    vertexConsumer.addVertex(matrices.last().pose(), x1, y1, z1).setColor(1.0f, 0.0f, 0.0f, a).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                    vertexConsumer.addVertex(matrices.last().pose(), x2, y2, z2).setColor(1.0f, 0.0f, 0.0f, a).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                    vertexConsumer.addVertex(matrices.last().pose(), x3, y3, z3).setColor(1.0f, 0.0f, 0.0f, a).setOverlay(OverlayTexture.NO_OVERLAY).setUv(0.0f, 0.0f).setUv2(light, light).setNormal(1.0f, 0.0f, 0.0f);
                }
            }
        }

        @SubscribeEvent
        public static void registerFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)Particles.gold.get(), RedPart.Provider::new);
            event.registerSpriteSet((ParticleType)Particles.blue.get(), BluePart.Provider::new);
            event.registerSpriteSet((ParticleType)Particles.popr.get(), PoprPart.Provider::new);
            event.registerSpriteSet((ParticleType)Particles.blood.get(), BloodPart.Provider::new);
        }

        @SubscribeEvent
        public static void EntityRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EntityTs.flysword.get(), SwordRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTs.suddenrain.get(), SwordRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTs.cell_zombie.get(), ZombieRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTs.cell_giant.get(), CellZombieG::new);
            event.registerEntityRenderer((EntityType)EntityTs.nightmare_giant_to.get(), CellZombieN::new);
            event.registerEntityRenderer((EntityType)EntityTs.blood_bat.get(), BloodBatRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTs.line.get(), LineRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTs.attack_blood.get(), AttackBloodRender::new);
            event.registerEntityRenderer((EntityType)EntityTs.blood.get(), BloodRender::new);
            event.registerEntityRenderer((EntityType)EntityTs.owner_blood.get(), OwnerBloodRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTs.as_sword.get(), AsSwordRender::new);
            event.registerEntityRenderer((EntityType)EntityTs.axe.get(), AxeRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTs.sword.get(), SwordOfTwelveRenderer::new);
            event.registerEntityRenderer((EntityType)EntityTs.at_sword_entity.get(), AtSwordRender::new);
            event.registerEntityRenderer((EntityType)EntityTs.ytgld.get(), YtgldRender::new);
            event.registerEntityRenderer((EntityType)EntityTs.coffin_entity.get(), CoffinRender::new);
            event.registerEntityRenderer((EntityType)EntityTs.the_sword.get(), TheSwordRender::new);
        }

        @SubscribeEvent
        public static void EntityRenderersEvent(RegisterShadersEvent event) {
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"rendertype_gateway"), DefaultVertexFormat.POSITION_TEX_COLOR), MRender::setShaderInstance_gateway);
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"rendertype_mls"), DefaultVertexFormat.POSITION_TEX_COLOR), MRender::setShaderInstance_mls);
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"rendertype_ging"), DefaultVertexFormat.POSITION_TEX_COLOR), MRender::setShaderInstance_ging);
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"trail"), DefaultVertexFormat.POSITION_TEX_COLOR), MRender::setShaderInstance_trail);
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"eye"), DefaultVertexFormat.POSITION_TEX_COLOR), MRender::setShaderInstance_EYE);
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"snake"), DefaultVertexFormat.POSITION_TEX_COLOR), MRender::setShader_snake);
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"p_blood"), DefaultVertexFormat.POSITION_TEX_COLOR), MRender::setShaderInstance_p_blood);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }

    @EventBusSubscriber(modid="moonstone", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent evt) {
            NeoForge.EVENT_BUS.register((Object)new ClientEvent());
        }

        @SubscribeEvent
        public static void registerBindings(RegisterKeyMappingsEvent event) {
            event.register(Keys.KEY_MAPPING_LAZY_R);
        }

        @SubscribeEvent
        public static void RegisterClientTooltipComponentFactoriesEvent(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(NightmareTooltip.class, Function.identity());
            event.register(ToolTip.class, Function.identity());
        }

        @SubscribeEvent
        public static void EntityRenderersEvent(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)com.ytgld.seeking_immortals.init.EntityTs.orb_entity.get(), OrbEntityRenderer::new);
            event.registerEntityRenderer((EntityType)com.ytgld.seeking_immortals.init.EntityTs.lighting.get(), LightingRender::new);
        }

        @SubscribeEvent
        public static void registerFactories(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)com.ytgld.seeking_immortals.init.Particles.blood.get(), blood.Provider::new);
            event.registerSpriteSet((ParticleType)com.ytgld.seeking_immortals.init.Particles.cube.get(), cube.Provider::new);
        }

        @SubscribeEvent
        public static void EntityRenderersEvent(RegisterShadersEvent event) {
            try {
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"rendertype_mls"), DefaultVertexFormat.POSITION_TEX_COLOR), com.ytgld.seeking_immortals.renderer.MRender::setShaderInstance_mls);
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"rendertype_ging"), DefaultVertexFormat.POSITION_TEX_COLOR), com.ytgld.seeking_immortals.renderer.MRender::setShaderInstance_ging);
                event.registerShader(new ShaderInstance(event.getResourceProvider(), ResourceLocation.fromNamespaceAndPath((String)MoonStoneMod.MODID, (String)"p_blood"), DefaultVertexFormat.POSITION_TEX_COLOR), com.ytgld.seeking_immortals.renderer.MRender::setShaderInstance_p_blood);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
    }
}

