/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.client.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.moonstone.moonstonemod.client.layer.IBloodSize;
import com.moonstone.moonstonemod.entity.AttackBlood;
import com.moonstone.moonstonemod.init.other.EntityTs;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class BloodLayer<T extends LivingEntity, M extends PlayerModel<T>>
extends StuckInBodyLayer<T, M> {
    private final EntityRenderDispatcher dispatcher;

    public BloodLayer(EntityRendererProvider.Context context, LivingEntityRenderer<T, M> renderer) {
        super(renderer);
        this.dispatcher = context.getEntityRenderDispatcher();
    }

    protected int numStuck(T entity) {
        if (entity instanceof IBloodSize) {
            IBloodSize size = (IBloodSize)entity;
            return size.getSize();
        }
        return 0;
    }

    protected void renderStuckItem(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Entity entity, float x, float y, float z, float partialTick) {
        IBloodSize size;
        if (entity instanceof IBloodSize && (size = (IBloodSize)entity).getSize() > 0) {
            AttackBlood arrow = new AttackBlood((EntityType<? extends AttackBlood>)((EntityType)EntityTs.attack_blood.get()), entity.level());
            poseStack.pushPose();
            this.dispatcher.render((Entity)arrow, 0.0, 0.0, 0.0, 0.0f, partialTick, poseStack, buffer, packedLight);
            poseStack.popPose();
        }
    }
}

