/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.moonstone.moonstonemod.entity.AtSword;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class BluePart
extends TextureSheetParticle {
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();

    public BluePart(ClientLevel level, double x, double y, double z, float movementX, float movementY, float movementZ) {
        super(level, x, y, z, (double)movementX, (double)movementY, (double)movementZ);
        this.lifetime = 500;
        this.alpha = 0.0f;
    }

    protected int getLightColor(float p_107249_) {
        return 240;
    }

    @NotNull
    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        this.trailPositions.add(new Vec3(this.x, this.y, this.z));
        if (this.trailPositions.size() > 15) {
            this.trailPositions.removeFirst();
        }
        Vec3 playerPos = this.getPos();
        float range = 16.0f;
        List entities = this.level.getEntitiesOfClass(AtSword.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (AtSword atSword : entities) {
            if (!atSword.isNoGravity()) continue;
            this.setv((Entity)atSword);
        }
        this.alpha = 0.0f;
        --this.lifetime;
        if (this.lifetime <= 0) {
            this.remove();
        }
        super.tick();
    }

    public void setv(Entity e) {
        Vec3 targetPos = e.position().add(0.0, 0.0, 0.0);
        Vec3 currentPos = this.getPos();
        Vec3 direction = targetPos.subtract(currentPos).normalize();
        Vec3 currentDirection = new Vec3(this.xd, this.yd, this.zd).normalize();
        double angle = Math.acos(currentDirection.dot(direction)) * 57.29577951308232;
        if (angle > 10.0) {
            double angleLimit = Math.toRadians(10.0);
            Vec3 limitedDirection = currentDirection.scale(Math.cos(angleLimit)).add(direction.normalize().scale(Math.sin(angleLimit)));
            this.setParticleSpeed(limitedDirection.x * 0.5, limitedDirection.y * 0.5, limitedDirection.z * 0.5);
        } else {
            this.setParticleSpeed(direction.x * 0.5, direction.y * 0.5, direction.z * 0.5);
        }
    }

    public void setBlue(PoseStack matrices, BluePart entity, VertexConsumer vertexConsumers) {
        matrices.pushPose();
        for (int i = 1; i < entity.getTrailPositions().size(); ++i) {
            Vec3 prevPos = entity.getTrailPositions().get(i - 1);
            Vec3 currPos = entity.getTrailPositions().get(i);
            Vec3 adjustedPrevPos = new Vec3(prevPos.x - entity.getPos().x, prevPos.y - entity.getPos().y, prevPos.z - entity.getPos().z);
            Vec3 adjustedCurrPos = new Vec3(currPos.x - entity.getPos().x, currPos.y - entity.getPos().y, currPos.z - entity.getPos().z);
            float alpha = (float)i / (float)entity.getTrailPositions().size();
            this.renderBlood(matrices, vertexConsumers, adjustedPrevPos, adjustedCurrPos, alpha, RenderType.lightning(), 0.1f);
        }
        matrices.popPose();
    }

    public void renderBlood(PoseStack poseStack, VertexConsumer vertexConsumer, Vec3 start, Vec3 end, float a, RenderType renderType, float r) {
        int segmentCount = 16;
        for (int i = 0; i < segmentCount; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)segmentCount;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)segmentCount;
            double x1 = Math.cos(angle1) * (double)r;
            double z1 = Math.sin(angle1) * (double)r;
            double x2 = Math.cos(angle2) * (double)r;
            double z2 = Math.sin(angle2) * (double)r;
            Vec3 up1 = start.add(x1, 0.0, z1);
            Vec3 up2 = start.add(x2, 0.0, z2);
            Vec3 down1 = end.add(x1, 0.0, z1);
            Vec3 down2 = end.add(x2, 0.0, z2);
            this.addSquare(vertexConsumer, poseStack, up1, up2, down1, down2, a);
        }
    }

    private void addSquare(VertexConsumer vertexConsumer, PoseStack poseStack, Vec3 up1, Vec3 up2, Vec3 down1, Vec3 down2, float alpha) {
        vertexConsumer.addVertex(poseStack.last().pose(), (float)up1.x, (float)up1.y, (float)up1.z).setColor(187, 255, 255, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)down1.x, (float)down1.y, (float)down1.z).setColor(187, 255, 255, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)down2.x, (float)down2.y, (float)down2.z).setColor(187, 255, 255, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)up2.x, (float)up2.y, (float)up2.z).setColor(187, 255, 255, (int)(alpha * 255.0f)).setUv2(240, 240).setNormal(0.0f, 0.0f, 1.0f);
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Provider(SpriteSet sprite) implements ParticleProvider<SimpleParticleType>
    {
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BluePart particle = new BluePart(level, x, y, z, (float)xSpeed, (float)ySpeed, (float)zSpeed);
            particle.pickSprite(this.sprite);
            return particle;
        }
    }
}

