/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.crafting;

import com.moonstone.moonstonemod.crafting.AllCrafting;
import com.moonstone.moonstonemod.init.other.DataReg;
import com.moonstone.moonstonemod.item.plague.TheNecora.CanNot;
import java.util.ArrayList;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class RecipeGodDNA
extends CustomRecipe {
    private final CraftingBookCategory category;

    public RecipeGodDNA(CraftingBookCategory category) {
        super(category);
        this.category = category;
    }

    @NotNull
    public CraftingBookCategory category() {
        return this.category;
    }

    public boolean matches(CraftingInput craftingInput, @NotNull Level level) {
        int count = 0;
        ArrayList<Item> arrayList = new ArrayList<Item>();
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack currentStack = craftingInput.getItem(i);
            arrayList.add(currentStack.getItem());
            if (currentStack.getItem() instanceof CanNot || currentStack.get(DataReg.tag) == null || !((CompoundTag)currentStack.get(DataReg.tag)).getBoolean("god_loot") || ++count <= 2) continue;
            return false;
        }
        if (arrayList.size() > 2) {
            return false;
        }
        return count == 2;
    }

    @NotNull
    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        int count = 0;
        for (int i = 0; i < craftingInput.size(); ++i) {
            ItemStack currentStack = craftingInput.getItem(i);
            if (currentStack.get(DataReg.tag) == null || !((CompoundTag)currentStack.get(DataReg.tag)).getBoolean("god_loot") || ++count != 2) continue;
            ItemStack stack = currentStack.copy();
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putBoolean("isGod", true);
            stack.set(DataReg.tag, (Object)compoundTag);
            return stack;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AllCrafting.DNA.get();
    }
}

