/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity;

import com.moonstone.moonstonemod.EventHandler;
import com.moonstone.moonstonemod.event.mevent.AttackBloodEvent;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.other.DamageTps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AttackBlood
extends ThrowableItemProjectile {
    private LivingEntity target;
    private final List<Vec3> trailPositions = new ArrayList<Vec3>();
    public float damages = 4.0f;
    public float addDamgae = 0.0f;
    public boolean follow = true;
    public boolean slime = false;
    public boolean boom = false;
    public boolean effect = false;
    public boolean isPlayer = false;
    public float speeds = 0.1875f;
    public float maxTime = 200.0f;
    public int live = 50;
    public boolean canSee = true;

    public AttackBlood(EntityType<? extends AttackBlood> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    public LivingEntity getTarget() {
        return this.target;
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }

    public List<Vec3> getTrailPositions() {
        return this.trailPositions;
    }

    protected Item getDefaultItem() {
        return (Item)Items.blood.get();
    }

    @NotNull
    public ItemStack getItem() {
        return ((Item)Items.blood.get()).getDefaultInstance();
    }

    public float getXRot() {
        return 0.0f;
    }

    public float getYRot() {
        return 0.0f;
    }

    public boolean isInWater() {
        return false;
    }

    public void move(MoverType type, Vec3 pos) {
    }

    public void tick() {
        super.tick();
        this.setNoGravity(true);
        this.noPhysics = true;
        Vec3 playerPos = this.position().add(0.0, 0.75, 0.0);
        boolean range = true;
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.getTags().contains("live")) {
                AttackBloodEvent attackBloodEvent = EventHandler.attackBloodEvent(this, player);
                this.maxTime *= attackBloodEvent.getMaxTime();
                this.damages *= attackBloodEvent.getDamage();
                this.speeds *= attackBloodEvent.getSpeed();
                this.addTag("live");
            }
        }
        if (this.canSee) {
            List entities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            for (LivingEntity entity2 : entities) {
                Entity entity3;
                if (this.getOwner() == null || entity2.is(this.getOwner()) || !((entity3 = this.getOwner()) instanceof Player)) continue;
                Player player = (Player)entity3;
                ResourceLocation entitys = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity2.getType());
                if (entitys.getNamespace().equals("moonstone") || !entity2.isAlive()) continue;
                entity2.invulnerableTime = 0;
                if (this.boom) {
                    this.level().explode(this.getOwner(), this.getX(), this.getY(), this.getZ(), 3.0f, false, Level.ExplosionInteraction.NONE);
                }
                if (this.effect) {
                    entity2.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 100, 1));
                    entity2.addEffect(new MobEffectInstance(MobEffects.POISON, 100, 1));
                    entity2.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 1));
                }
                if (this.slime) {
                    player.heal(this.damages + this.addDamgae);
                }
                if (this.isPlayer) {
                    entity2.hurt(this.getOwner().damageSources().playerAttack(player), (float)((double)(this.damages + this.addDamgae + player.getMaxHealth() / 33.0f) + player.getAttributeValue(Attributes.ATTACK_DAMAGE) / 33.0));
                } else {
                    entity2.hurt(DamageTps.abyssDamage(entity2), (float)((double)(this.damages + this.addDamgae + player.getMaxHealth() / 33.0f) + player.getAttributeValue(Attributes.ATTACK_DAMAGE) / 33.0));
                }
                this.canSee = false;
            }
        }
        if (this.canSee) {
            if (this.boom && (float)this.tickCount >= this.maxTime) {
                this.level().explode(this.getOwner(), this.getX(), this.getY(), this.getZ(), 3.0f, false, Level.ExplosionInteraction.NONE);
                this.canSee = false;
            }
            if ((float)this.tickCount > this.maxTime) {
                this.canSee = false;
            }
            if (this.target != null && !this.target.isAlive()) {
                this.findNewTarget();
            }
        }
        float s = 0.075f;
        if (this.canSee) {
            if (this.target != null) {
                if (this.follow) {
                    targetPos = this.target.position().add(0.0, 0.5, 0.0);
                    currentPos = this.position();
                    direction = targetPos.subtract(currentPos).normalize();
                    Vec3 currentDirection = this.getDeltaMovement().normalize();
                    double angle = Math.acos(currentDirection.dot(direction)) * 57.29577951308232;
                    if (angle > 45.0) {
                        double angleLimit = Math.toRadians(45.0);
                        Vec3 limitedDirection = currentDirection.scale(Math.cos(angleLimit)).add(direction.normalize().scale(Math.sin(angleLimit)));
                        this.setDeltaMovement(limitedDirection.x * (double)(0.125f + s), limitedDirection.y * (double)(0.125f + s), limitedDirection.z * (double)(0.125f + s));
                    } else {
                        this.setDeltaMovement(direction.x * (double)(0.125f + s), direction.y * (double)(0.125f + s), direction.z * (double)(0.125f + s));
                    }
                } else if (this.tickCount <= 1) {
                    targetPos = this.target.position().add(0.0, 0.5, 0.0);
                    currentPos = this.position();
                    direction = targetPos.subtract(currentPos).normalize();
                    this.setDeltaMovement(direction.x * (double)(this.speeds + s), direction.y * (double)(this.speeds + s), direction.z * (double)(this.speeds + s));
                }
            }
        } else {
            this.setDeltaMovement(0.0, 0.0, 0.0);
        }
        if (this.canSee) {
            this.trailPositions.add(new Vec3(this.getX(), this.getY(), this.getZ()));
        }
        if (!(this.trailPositions.isEmpty() || this.trailPositions.size() <= 30 && this.canSee)) {
            this.trailPositions.removeFirst();
        }
        if (!this.canSee) {
            --this.live;
        }
        if (this.live <= 0) {
            this.discard();
        }
        this.setNoGravity(true);
        this.setYRot(0.0f);
        this.setXRot(0.0f);
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (this.getOwner() == null || name.getNamespace().equals("moonstone") || entity.is(this.getOwner()) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }

    public float getMaxTime() {
        return this.maxTime;
    }

    public void setMaxTime(float maxTime) {
        this.maxTime = maxTime;
    }

    public void setBoom(boolean boom) {
        this.boom = boom;
    }

    public void setDamage(float damage) {
        this.damages = damage;
    }

    public void setAddDamgae(float addDamgae) {
        this.addDamgae = addDamgae;
    }

    public void setEffect(boolean effect) {
        this.effect = effect;
    }

    public void setSpeed(float speed) {
        this.speeds = speed;
    }

    public float getSpeeds() {
        return this.speeds;
    }

    public float getDamages() {
        return this.damages;
    }

    public void setHeal(boolean slime) {
        this.slime = slime;
    }

    public void setCannotFollow(boolean t) {
        this.follow = t;
    }
}

