/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity;

import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.init.items.Items;
import com.moonstone.moonstonemod.init.other.EntityTs;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwordOfTwelveOther
extends TamableAnimal {
    public static final EntityDataAccessor<Integer> ARMOR = SynchedEntityData.defineId(SwordOfTwelveOther.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> ATTACK_TIME = SynchedEntityData.defineId(SwordOfTwelveOther.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private LivingEntity target;
    public static final int max = 32;
    private int trailPointer = -1;
    private final Vec3[][] trailPositions = new Vec3[32][2];

    @Nullable
    public LivingEntity getTarget() {
        return this.target;
    }

    public SwordOfTwelveOther(EntityType<? extends SwordOfTwelveOther> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.setNoGravity(true);
        for (int i = 0; i < this.trailPositions.length; ++i) {
            this.trailPositions[i][0] = Vec3.ZERO;
            this.trailPositions[i][1] = Vec3.ZERO;
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 100.0).add(Attributes.ARMOR, 10.0);
    }

    public boolean isInvulnerable() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(ARMOR, (Object)0);
        pBuilder.define(ATTACK_TIME, (Object)0);
    }

    public void die(@NotNull DamageSource p_21809_) {
    }

    public Vec3 getTrailPosition(int pointer, float partialTick) {
        if (this.isRemoved()) {
            partialTick = 1.0f;
        }
        int i = this.trailPointer - pointer & 0x1F;
        int j = this.trailPointer - pointer - 1 & 0x1F;
        Vec3 d0 = this.trailPositions[j][0];
        Vec3 d1 = this.trailPositions[i][0].subtract(d0);
        return d0.add(d1.scale((double)partialTick));
    }

    public Vec3 getHelmetPosition() {
        return this.position();
    }

    public void tickVisual() {
        Vec3 blue = this.getHelmetPosition();
        this.trailPointer = (this.trailPointer + 1) % this.trailPositions.length;
        this.trailPositions[this.trailPointer][0] = blue;
    }

    public boolean hasTrail() {
        return this.trailPointer != -1;
    }

    public void tick() {
        Player player;
        LivingEntity livingEntity;
        super.tick();
        this.setNoGravity(true);
        if ((Integer)this.entityData.get(ARMOR) <= 0) {
            this.invulnerableTime = 10;
            this.heal(100.0f);
        }
        if (this.tickCount % 100 == 1 && (Integer)this.entityData.get(ARMOR) < 13) {
            this.entityData.set(ARMOR, (Object)((Integer)this.entityData.get(ARMOR) + 1));
        }
        if (this.tickCount % 20 == 1) {
            this.findNewTarget();
        }
        LivingEntity owner = this.getOwner();
        if (this.target != null) {
            LivingEntity livingEntity2;
            if (this.tickCount % 10 == 0 && this.target.isAlive() && this.getOwner() != null && (livingEntity2 = this.getOwner()) instanceof Player) {
                Player player2 = (Player)livingEntity2;
                this.target.hurt(this.target.damageSources().playerAttack(player2), (float)(this.getOwner().getAttributeValue(Attributes.ATTACK_DAMAGE) / 10.0) * (float)((Integer)this.entityData.get(ARMOR)).intValue() / 150.0f * (float)((Integer)this.entityData.get(ATTACK_TIME)).intValue() / 6.0f);
            }
            if (this.tickCount % 2 == 0) {
                if (this.target.isAlive()) {
                    if ((Integer)this.entityData.get(ATTACK_TIME) < 300) {
                        this.entityData.set(ATTACK_TIME, (Object)((Integer)this.entityData.get(ATTACK_TIME) + 1));
                    }
                } else if ((Integer)this.entityData.get(ATTACK_TIME) > 0) {
                    this.entityData.set(ATTACK_TIME, (Object)((Integer)this.entityData.get(ATTACK_TIME) - 2));
                }
            }
        }
        Vec3 currentPos = this.position();
        if (owner != null) {
            if (this.tickCount % 20 == 1) {
                owner.heal(owner.getMaxHealth() * (float)((Integer)this.entityData.get(ARMOR)).intValue() / 100.0f);
            }
            double desiredDistance = 2.0;
            Vec3 targetPos = owner.position().add(0.0, 3.0, 0.0);
            Vec3 forward = owner.getLookAngle();
            Vec3 direction = forward.scale(-1.0).normalize();
            Vec3 newTargetPos = targetPos.add(direction.scale(desiredDistance));
            this.setDeltaMovement(newTargetPos.subtract(currentPos).normalize().scale((double)0.15f));
        }
        if (this.getOwner() != null && (livingEntity = this.getOwner()) instanceof Player) {
            player = (Player)livingEntity;
            Vec3 playerPos = player.position();
            int range = 20;
            List entities = player.level().getEntitiesOfClass(Mob.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
            if (!Handler.hascurio((LivingEntity)player, (Item)Items.the_god_sword.get())) {
                this.discard();
            }
            if (player.getCooldowns().isOnCooldown((Item)Items.the_god_sword.get())) {
                this.discard();
            }
        }
        if (this.level().isClientSide) {
            this.tickVisual();
        }
        if ((livingEntity = this.getOwner()) instanceof Player) {
            player = (Player)livingEntity;
            if (!Handler.hascurio((LivingEntity)player, (Item)Items.the_god_sword.get())) {
                this.discard();
            }
            if (!player.getTags().contains("HasTheSword")) {
                this.discard();
            }
            if (player.getCooldowns().isOnCooldown((Item)Items.the_god_sword.get())) {
                this.discard();
            }
        }
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.0f + p_186343_.level().getRandom().nextFloat() * 0.4f);
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        this.playRemoveOneSound((Entity)this);
        if ((Integer)this.entityData.get(ARMOR) > 1) {
            LivingEntity livingEntity = this.getOwner();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (!player.level().isClientSide) {
                    LivingEntity living;
                    player.heal(amount * 2.0f);
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 200, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 200, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.CONDUIT_POWER, 200, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 200, 2));
                    Entity entity = source.getEntity();
                    if (entity instanceof LivingEntity && !(living = (LivingEntity)entity).is((Entity)player)) {
                        living.hurt(living.damageSources().dryOut(), amount * 1.5f);
                        living.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 500, 2));
                        living.addEffect(new MobEffectInstance(MobEffects.POISON, 500, 2));
                        living.addEffect(new MobEffectInstance(MobEffects.WITHER, 500, 2));
                        living.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 500, 2));
                        living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 500, 2));
                        living.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 500, 2));
                        living.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 500, 2));
                    }
                }
            }
        } else {
            return false;
        }
        this.entityData.set(ARMOR, (Object)((Integer)this.entityData.get(ARMOR) - 1));
        return true;
    }

    protected void doPush(Entity p_27415_) {
    }

    protected void pushEntities() {
    }

    private void findNewTarget() {
        AABB searchBox = this.getBoundingBox().inflate(16.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, searchBox);
        double closestDistance = Double.MAX_VALUE;
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            double distance;
            OwnableEntity tamableAnimal;
            ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
            if (this.getOwner() == null || entity instanceof OwnableEntity && (tamableAnimal = (OwnableEntity)entity).getOwner() != null && tamableAnimal.getOwner().equals((Object)this.getOwner()) || name.getNamespace().equals("moonstone") || entity.is((Entity)this.getOwner()) || !((distance = this.distanceToSqr((Entity)entity)) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        this.target = closestEntity;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        UUID uuid;
        SwordOfTwelveOther wolf = (SwordOfTwelveOther)((EntityType)EntityTs.the_sword.get()).create((Level)serverLevel);
        if (wolf != null && (uuid = this.getOwnerUUID()) != null) {
            wolf.setOwnerUUID(uuid);
            wolf.setTame(true, true);
        }
        return wolf;
    }
}

