/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.bloodvruis;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.moonstone.moonstonemod.init.other.EntityTs;
import com.moonstone.moonstonemod.init.other.Particles;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BloodBat
extends TamableAnimal {
    public int time = 0;
    public final AnimationState flyAnimationState = new AnimationState();
    public final AnimationState restAnimationState = new AnimationState();

    public BloodBat(EntityType<? extends BloodBat> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAtt() {
        HashMultimap modifierMultimap = HashMultimap.create();
        modifierMultimap.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagemoonstone.bat.armor"), 10.0, AttributeModifier.Operation.ADD_VALUE));
        return modifierMultimap;
    }

    public Multimap<Holder<Attribute>, AttributeModifier> Rage() {
        HashMultimap modifierMultimap = HashMultimap.create();
        modifierMultimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"base_attack_damagemoonstone.bat.damage"), -0.5, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        return modifierMultimap;
    }

    public void tick() {
        OwnableEntity entity;
        LivingEntity mob2;
        super.tick();
        this.setupAnimationStates();
        this.setNoGravity(true);
        Vec3 playerPos = this.position().add(0.0, 0.75, 0.0);
        if (this.getTarget() != null) {
            float m = (float)BloodBat.calculateDistance(this.getTarget(), (LivingEntity)this);
            if (m > 4.0f) {
                d2 = this.getTarget().getX() + 0.5 - this.getX();
                d0 = this.getTarget().getY() + 0.1 - this.getY();
                d1 = this.getTarget().getZ() + 0.5 - this.getZ();
                vec3 = this.getDeltaMovement();
                vec31 = vec3.add((Math.signum(d2) * 0.5 - vec3.x) * (double)0.1f, (Math.signum(d0) * (double)0.7f - vec3.y) * (double)0.1f, (Math.signum(d1) * 0.5 - vec3.z) * (double)0.1f);
                this.setDeltaMovement(new Vec3(vec31.x, vec31.y * 1.1, vec31.z));
                float f = (float)(Mth.atan2((double)vec31.z, (double)vec31.x) * 57.2957763671875) - 90.0f;
                float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
                this.zza = 0.5f;
                this.setYRot(this.getYRot() + f1);
            } else {
                d2 = this.getTarget().getX() + 0.5 - this.getX();
                d0 = this.getTarget().getY() + 0.1 - this.getY();
                d1 = this.getTarget().getZ() + 0.5 - this.getZ();
                vec3 = this.getDeltaMovement();
                vec31 = vec3.add((Math.signum(d2) * 0.5 - vec3.x) * (double)0.1f, (Math.signum(d0) * (double)0.7f - vec3.y) * (double)0.1f, (Math.signum(d1) * 0.5 - vec3.z) * (double)0.1f);
                this.setDeltaMovement(new Vec3(-vec31.x, -vec31.y, -vec31.z));
            }
        }
        int range = 20;
        List entities = this.level().getEntitiesOfClass(Mob.class, new AABB(playerPos.x - (double)range, playerPos.y - (double)range, playerPos.z - (double)range, playerPos.x + (double)range, playerPos.y + (double)range, playerPos.z + (double)range));
        for (Mob mob2 : entities) {
            ResourceLocation entity2;
            OwnableEntity tamableAnimal;
            if (this.getTarget() != null || this.getOwner() == null || mob2 instanceof OwnableEntity && (tamableAnimal = (OwnableEntity)mob2).getOwner() != null && tamableAnimal.getOwner().equals((Object)this.getOwner()) || (entity2 = BuiltInRegistries.ENTITY_TYPE.getKey((Object)mob2.getType())).getNamespace().equals("moonstone")) continue;
            this.setTarget((LivingEntity)mob2);
        }
        if (this.getTarget() != null && !this.getTarget().isAlive()) {
            this.setTarget(null);
        }
        if (this.getTarget() != null && this.getOwner() != null && (mob2 = this.getTarget()) instanceof OwnableEntity && (entity = (OwnableEntity)mob2).getOwner() != null && this.getOwner() != null && entity.getOwner().is((Entity)this.getOwner())) {
            this.setTarget(null);
        }
        if (this.getOwner() != null) {
            if (this.getOwner().getLastHurtByMob() != null && !this.getOwner().getLastHurtByMob().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastHurtByMob().getType()).getNamespace().equals("moonstone")) {
                this.setTarget(this.getOwner().getLastHurtByMob());
            }
            if (this.getOwner().getLastAttacker() != null && !this.getOwner().getLastAttacker().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastAttacker().getType()).getNamespace().equals("moonstone")) {
                this.setTarget(this.getOwner().getLastAttacker());
            }
            if (this.getOwner().getLastHurtMob() != null && !this.getOwner().getLastHurtMob().is((Entity)this) && !BuiltInRegistries.ENTITY_TYPE.getKey((Object)this.getOwner().getLastHurtMob().getType()).getNamespace().equals("moonstone")) {
                this.setTarget(this.getOwner().getLastHurtMob());
            }
        }
        if (this.getTags().contains("CellImmortal")) {
            this.getAttributes().addTransientAttributeModifiers(this.getAtt());
        }
        if (this.getTags().contains("CellRage")) {
            this.getAttributes().addTransientAttributeModifiers(this.Rage());
        }
        this.time = this.getTags().contains("CellFear") ? ++this.time : (this.time += 2);
        if (this.time > 1200) {
            this.kill();
        }
        if (this.tickCount % 20 == 0) {
            Vec3 position = this.position();
            int is = 18;
            List items = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(position.x - (double)is, position.y - (double)is, position.z - (double)is, position.x + (double)is, position.y + (double)is, position.z + (double)is));
            for (LivingEntity livingEntity : items) {
                ResourceLocation name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)livingEntity.getType());
                if (name == null || name.getNamespace().equals("moonstone") || this.getOwner() == null || this.getOwner().is((Entity)livingEntity) || this.getTarget() == null || !this.getTarget().is((Entity)livingEntity)) continue;
                Vec3 vec3 = this.position().add(0.0, 0.35, 0.0);
                Vec3 vec31 = livingEntity.getEyePosition().subtract(vec3);
                Vec3 vec32 = vec31.normalize();
                if (Mth.floor((double)vec31.length()) >= 5) continue;
                for (int i = 1; i < Mth.floor((double)vec31.length()) + 10; ++i) {
                    Vec3 vec33 = vec3.add(vec32.scale((double)i));
                    this.level().addParticle((ParticleOptions)Particles.gold.get(), vec33.x, vec33.y, vec33.z, 0.0, 0.0, 0.0);
                }
                if (this.getAttribute(Attributes.ATTACK_DAMAGE) == null) continue;
                if (this.getTags().contains("CellDoctor")) {
                    this.heal((float)(this.getAttribute(Attributes.ATTACK_DAMAGE).getValue() / 5.0));
                }
                if (livingEntity instanceof Mob) {
                    Mob mob3 = (Mob)livingEntity;
                    if (this.getTags().contains("CellDesecrate") && !mob3.isInvertedHealAndHarm()) {
                        mob3.hurt(this.damageSources().sonicBoom((Entity)this), (float)(1.0 + this.getAttribute(Attributes.ATTACK_DAMAGE).getValue() * (double)1.4f));
                        mob3.invulnerableTime = 0;
                    }
                }
                if (this.getTags().contains("CellBloodAttack")) {
                    this.getOwner().heal((float)(this.getAttribute(Attributes.ATTACK_DAMAGE).getValue() / 10.0));
                }
                livingEntity.hurt(this.damageSources().sonicBoom((Entity)this), (float)(1.0 + this.getAttribute(Attributes.ATTACK_DAMAGE).getValue()));
                livingEntity.invulnerableTime = 0;
            }
        }
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.BAT_DEATH;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return SoundEvents.BAT_HURT;
    }

    public void die(@NotNull DamageSource p_21809_) {
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity p_27415_) {
    }

    public boolean hurt(DamageSource p_27567_, float p_27568_) {
        if (p_27567_.is(DamageTypes.FALL)) {
            return false;
        }
        return super.hurt(p_27567_, p_27568_);
    }

    protected void pushEntities() {
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(6, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Turtle.class, false, Turtle.BABY_ON_LAND_SELECTOR));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Spider.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Skeleton.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderMan.class, false));
        this.targetSelector.addGoal(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false));
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_146743_, AgeableMob p_146744_) {
        UUID uuid;
        BloodBat wolf = (BloodBat)((EntityType)EntityTs.blood_bat.get()).create((Level)p_146743_);
        if (wolf != null && (uuid = this.getOwnerUUID()) != null) {
            wolf.setOwnerUUID(uuid);
            wolf.setTame(true, true);
        }
        return wolf;
    }

    public static double calculateDistance(LivingEntity entity1, LivingEntity entity2) {
        Vec3 pos1 = entity1.position();
        Vec3 pos2 = entity2.position();
        double dx = pos1.x - pos2.x;
        double dy = pos1.y - pos2.y;
        double dz = pos1.z - pos2.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private void setupAnimationStates() {
        this.restAnimationState.stop();
        this.flyAnimationState.startIfStopped(this.tickCount);
    }

    public boolean isFood(ItemStack pStack) {
        return false;
    }
}

