/*
 * Decompiled with CFR 0.152.
 */
package com.moonstone.moonstonemod.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.moonstone.moonstonemod.Handler;
import com.moonstone.moonstonemod.entity.FlySwordBlue;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AsSwordRender<T extends FlySwordBlue>
extends EntityRenderer<T> {
    public AsSwordRender(EntityRendererProvider.Context p_173917_) {
        super(p_173917_);
    }

    public boolean shouldRender(T livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public void render(T pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        double x = Mth.lerp((double)pPartialTicks, (double)((FlySwordBlue)((Object)pEntity)).xOld, (double)pEntity.getX());
        double y = Mth.lerp((double)pPartialTicks, (double)((FlySwordBlue)((Object)pEntity)).yOld, (double)pEntity.getY());
        double z = Mth.lerp((double)pPartialTicks, (double)((FlySwordBlue)((Object)pEntity)).zOld, (double)pEntity.getZ());
        pPoseStack.pushPose();
        pPoseStack.translate(pEntity.getX() - x, pEntity.getY() - y, pEntity.getZ() - z);
        this.setT(pPoseStack, pEntity, pBuffer);
        pPoseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)((FlySwordBlue)((Object)pEntity)).yRotO, (float)pEntity.getYRot()) - 90.0f));
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)pPartialTicks, (float)((FlySwordBlue)((Object)pEntity)).xRotO, (float)pEntity.getXRot())));
        pPoseStack.mulPose(Axis.XP.rotationDegrees(45.0f));
        pPoseStack.scale(0.05625f, 0.05625f, 0.05625f);
        pPoseStack.translate(-4.0f, 0.0f, 0.0f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(pEntity)));
        PoseStack.Pose posestack$pose = pPoseStack.last();
        this.vertex(posestack$pose, vertexconsumer, -7, -2, -2, 0.0f, 0.15625f, -1, 0, 0, pPackedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, -2, 2, 0.15625f, 0.15625f, -1, 0, 0, pPackedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, 2, 2, 0.15625f, 0.3125f, -1, 0, 0, pPackedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, 2, -2, 0.0f, 0.3125f, -1, 0, 0, pPackedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, 2, -2, 0.0f, 0.15625f, 1, 0, 0, pPackedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, 2, 2, 0.15625f, 0.15625f, 1, 0, 0, pPackedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, -2, 2, 0.15625f, 0.3125f, 1, 0, 0, pPackedLight);
        this.vertex(posestack$pose, vertexconsumer, -7, -2, -2, 0.0f, 0.3125f, 1, 0, 0, pPackedLight);
        for (int j = 0; j < 4; ++j) {
            pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            this.vertex(posestack$pose, vertexconsumer, -8, -2, 0, 0.0f, 0.0f, 0, 1, 0, pPackedLight);
            this.vertex(posestack$pose, vertexconsumer, 8, -2, 0, 0.5f, 0.0f, 0, 1, 0, pPackedLight);
            this.vertex(posestack$pose, vertexconsumer, 8, 2, 0, 0.5f, 0.15625f, 0, 1, 0, pPackedLight);
            this.vertex(posestack$pose, vertexconsumer, -8, 2, 0, 0.0f, 0.15625f, 0, 1, 0, pPackedLight);
        }
        pPoseStack.popPose();
        super.render(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    private void setT(PoseStack matrices, T entity, MultiBufferSource vertexConsumers) {
        matrices.pushPose();
        matrices.mulPose(Axis.ZP.rotationDegrees(0.0f));
        matrices.mulPose(Axis.YP.rotationDegrees(0.0f));
        matrices.mulPose(Axis.XP.rotationDegrees(0.0f));
        for (int i = 1; i < ((FlySwordBlue)((Object)entity)).getTrailPositions().size(); ++i) {
            Vec3 prevPos = ((FlySwordBlue)((Object)entity)).getTrailPositions().get(i - 1);
            Vec3 currPos = ((FlySwordBlue)((Object)entity)).getTrailPositions().get(i);
            Vec3 adjustedPrevPos = new Vec3(prevPos.x - entity.getX(), prevPos.y - entity.getY(), prevPos.z - entity.getZ());
            Vec3 adjustedCurrPos = new Vec3(currPos.x - entity.getX(), currPos.y - entity.getY(), currPos.z - entity.getZ());
            float alpha = (float)i / (float)((FlySwordBlue)((Object)entity)).getTrailPositions().size();
            Handler.renderSword(matrices, vertexConsumers, adjustedPrevPos, adjustedCurrPos, alpha, RenderType.lightning(), 0.0375f);
        }
        matrices.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(T p_114482_) {
        return ResourceLocation.fromNamespaceAndPath((String)"moonstone", (String)"textures/entity/flysword.png");
    }

    public void vertex(PoseStack.Pose pPose, VertexConsumer pConsumer, int pX, int pY, int pZ, float pU, float pV, int pNormalX, int pNormalY, int pNormalZ, int pPackedLight) {
        pConsumer.addVertex(pPose, (float)pX, (float)pY, (float)pZ).setColor(-1).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(pPackedLight).setNormal(pPose, (float)pNormalX, (float)pNormalZ, (float)pNormalY);
    }
}

